/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.response;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.UplAttribute;
import com.tcdng.unify.core.annotation.UplAttributes;
import com.tcdng.unify.web.ui.AbstractJsonPageControllerResponse;
import com.tcdng.unify.web.ui.widget.Page;
import com.tcdng.unify.web.ui.widget.Panel;
import com.tcdng.unify.web.ui.widget.ResponseWriter;

@Component(value="showpopupresponse")
@UplAttributes(value={@UplAttribute(name="popup", type=String.class), @UplAttribute(name="systemInfo", type=boolean.class, defaultVal="false")})
public class ShowPopupResponse
extends AbstractJsonPageControllerResponse {
    public ShowPopupResponse() {
        super("showPopupHdl", true);
    }

    @Override
    protected void doGenerate(ResponseWriter writer, Page page) throws UnifyException {
        this.logDebug("Preparing show popup response: path ID = [{0}]", new Object[]{page.getPathId()});
        this.appendPopupPanelsJSON(writer, page);
        writer.write(",");
        this.appendRefreshAttributesJson(writer, false);
    }

    private void appendPopupPanelsJSON(ResponseWriter writer, Page page) throws UnifyException {
        Panel panel = null;
        String popupShortName = (String)this.getUplAttribute(String.class, "popup");
        if (popupShortName != null) {
            panel = page.getPanelByShortName(popupShortName);
        } else {
            String reqPopupName = this.getRequestContextUtil().getRequestPopupName();
            if (reqPopupName != null) {
                panel = page.isWidget(reqPopupName) ? page.getPanelByLongName(reqPopupName) : page.getPanelByShortName(reqPopupName);
            }
        }
        if (panel != null) {
            if (((Boolean)this.getUplAttribute(Boolean.TYPE, "systemInfo")).booleanValue()) {
                writer.write(",\"showSysInfoPopup\":");
            } else {
                writer.write(",\"showPopup\":");
            }
            writer.writeJsonPanel(panel, false);
        }
    }
}

