/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.response;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.web.ui.response.RefreshPanelResponse;
import com.tcdng.unify.web.ui.widget.Page;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.panel.SwitchPanel;
import java.util.Arrays;

@Component(value="switchpanelresponse")
public class SwitchPanelResponse
extends RefreshPanelResponse {
    private String[] targets;
    private String[] panels;

    @Override
    protected void doGenerate(ResponseWriter writer, Page page) throws UnifyException {
        String[] panels = this.getPanels();
        this.logDebug("Preparing switch panel response: path ID = [{0}], panelCount = [{1}]", new Object[]{page.getPathId(), panels.length});
        for (int i = 0; i < panels.length; ++i) {
            SwitchPanel switchPanel = (SwitchPanel)page.getPanelByShortName(panels[i]);
            switchPanel.switchContent(this.targets[i]);
        }
        super.doGenerate(writer, page);
    }

    @Override
    protected void onInitialize() throws UnifyException {
        this.panels = super.getPanels();
        this.panels = Arrays.copyOf(this.panels, this.panels.length);
        this.targets = new String[this.panels.length];
        for (int i = 0; i < this.panels.length; ++i) {
            int index = this.panels[i].lastIndexOf(46);
            this.targets[i] = this.panels[i].substring(index + 1);
            this.panels[i] = this.panels[i].substring(0, index);
        }
    }

    @Override
    protected String[] getPanels() throws UnifyException {
        return this.panels;
    }
}

