/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.response;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.web.ui.AbstractJsonPageControllerResponse;
import com.tcdng.unify.web.ui.widget.ContentPanel;
import com.tcdng.unify.web.ui.widget.Page;
import com.tcdng.unify.web.ui.widget.ResponseWriter;

@Component(value="unloadcontentresponse")
public class UnloadContentResponse
extends AbstractJsonPageControllerResponse {
    public UnloadContentResponse() {
        super("loadContentHdl", true);
    }

    @Override
    protected void doGenerate(ResponseWriter writer, Page page) throws UnifyException {
        this.logDebug("Preparing unload content response: path ID = [{0}]", new Object[]{page.getPathId()});
        if (this.getRequestContextUtil().isRemoteViewer()) {
            writer.write(",\"closeRemoteTab\":true");
        } else {
            ContentPanel contentPanel = this.getRequestContextUtil().getRequestDocument().getContentPanel();
            this.appendRefreshPageJSON(writer, contentPanel, page);
            writer.write(",");
            this.appendRefreshAttributesJson(writer, true);
            this.appendRegisteredDebounceWidgets(writer, false);
            writer.write(",\"busyIndicator\":\"").write(contentPanel.getBusyIndicatorId()).write("\"");
            writer.write(",\"scrollToTop\":true");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendRefreshPageJSON(ResponseWriter writer, ContentPanel contentPanel, Page page) throws UnifyException {
        this.setSessionAttribute("unload_origin", page);
        try {
            writer.write(",\"refreshPanels\":[");
            writer.writeJsonPanel(contentPanel, true);
            writer.write("]");
        }
        finally {
            this.removeSessionAttribute("unload_origin");
        }
    }
}

