/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.response;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.web.ui.AbstractJsonPageControllerResponse;
import com.tcdng.unify.web.ui.widget.Page;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.data.ValidationInfo;

@Component(value="validationerrorresponse")
public class ValidationErrorResponse
extends AbstractJsonPageControllerResponse {
    public ValidationErrorResponse() {
        super("validationErrorHdl", false);
    }

    @Override
    protected void doGenerate(ResponseWriter writer, Page page) throws UnifyException {
        this.logDebug("Preparing validation error response: path ID = [{0}]", new Object[]{page.getPathId()});
        StringBuilder htmlSb = new StringBuilder();
        writer.write(",\"validationInfo\":[");
        boolean appendSymbol = false;
        for (ValidationInfo validationInfo : this.getRequestContextUtil().getRequestValidationInfoList()) {
            if (appendSymbol) {
                writer.write(Character.valueOf(','));
            } else {
                appendSymbol = true;
            }
            writer.write("{\"pId\":\"").write(validationInfo.getId()).write("\", \"borderStyle\":\"").write(validationInfo.getBorderStyle()).write("\"");
            writer.write(",\"pBrdId\":\"").write(validationInfo.getBorderId()).write("\"");
            writer.write(",\"pNotfId\":\"").write(validationInfo.getNotificationId()).write("\"");
            if (!validationInfo.isPass()) {
                String message = validationInfo.getMessage();
                this.logDebug("Preparing validation error response: error = [{0}]", new Object[]{message});
                if (htmlSb.length() == 0) {
                    writer.write(",\"setFocus\":true");
                    htmlSb.append(true);
                }
                writer.write(",\"msg\":\"");
                writer.write(message);
                writer.write("\"");
            }
            writer.write("}");
        }
        writer.write("]");
    }
}

