/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.util;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.format.NumberSymbols;
import com.tcdng.unify.core.format.NumberType;
import java.util.ArrayList;
import java.util.HashSet;

public final class WebRegexUtils {
    private WebRegexUtils() {
    }

    public static String getNameFormatRegex(boolean underscore, boolean dollar, boolean period, boolean dash) throws UnifyException {
        StringBuilder sb = new StringBuilder();
        sb.append("/^[\\\\w");
        if (underscore) {
            sb.append("\\\\_");
        }
        if (dollar) {
            sb.append("\\\\$");
        }
        if (period) {
            sb.append("\\\\.");
        }
        if (dash) {
            sb.append("-");
        }
        sb.append("]*$/");
        return sb.toString();
    }

    public static String getNameAndSpecialCharactersFormatRegex() throws UnifyException {
        return "/^[\\\\w\\\\^\\\\$\\\\?\\\\*\\\\+\\\\.\\\\<\\\\>\\\\-\\\\=\\\\!\\\\_\\\\@\\\\#\\\\%]*$/";
    }

    public static String getIdentifierFormatRegex() throws UnifyException {
        return "/^([_a-zA-Z][_a-zA-Z0-9]*)?$/";
    }

    public static String getAlphanumericFormatRegex(boolean special, boolean space) throws UnifyException {
        if (special) {
            if (space) {
                return "/^[ 0-9a-zA-Z/&%\\\\-\\\\.\\\\(\\\\)]*$/";
            }
            return "/^[0-9a-zA-Z/&%\\\\-\\\\.\\\\(\\\\)]*$/";
        }
        if (space) {
            return "/^[ 0-9a-zA-Z]*$/";
        }
        return "/^[0-9a-zA-Z]*$/";
    }

    public static String getWordFormatRegex() throws UnifyException {
        return "/^[a-zA-Z]*$/";
    }

    public static String getFullNameFormatRegex(boolean special) throws UnifyException {
        if (special) {
            return "/^[a-zA-Z][ a-zA-Z/&%\\\\-\\\\.\\\\(\\\\)]*$/";
        }
        return "/^[a-zA-Z][ a-zA-Z]*$/";
    }

    public static String getSeriesRegex() throws UnifyException {
        return "/^[a-zA-Z][a-zA-Z]*[0-9]*$/";
    }

    public static String getIntegerTextFormatRegex(boolean allowPlus, boolean allowMinus) throws UnifyException {
        if (allowPlus && allowMinus) {
            return "/^(\\\\+|\\\\-)?[0-9]*$/";
        }
        if (allowPlus) {
            return "/^(\\\\+)?[0-9]*$/";
        }
        if (allowMinus) {
            return "/^(\\\\-)?[0-9]*$/";
        }
        return "/^[0-9]*$/";
    }

    public static String getNumberFormatRegex(NumberSymbols numberSymbols, int precision, int scale, boolean acceptNegative, boolean useGrouping, boolean strictFormat) throws UnifyException {
        StringBuilder sb = new StringBuilder();
        sb.append("/^");
        if (acceptNegative) {
            WebRegexUtils.appendOptionalFormattingRegex(sb, numberSymbols.getNegativePrefix(), numberSymbols.getPositivePrefix());
        } else {
            WebRegexUtils.appendOptionalFormattingRegex(sb, numberSymbols.getPositivePrefix());
        }
        if (scale > 0 && !NumberType.INTEGER.equals((Object)numberSymbols.getNumberType())) {
            precision -= scale;
        }
        String digit = WebRegexUtils.escapeSpecial("d");
        int groupSize = numberSymbols.getGroupSize();
        if (precision > 0) {
            if (useGrouping) {
                int fullGroupCount = precision / groupSize;
                int remainder = precision % groupSize;
                if (remainder > 0) {
                    WebRegexUtils.appendRangeOption(sb, digit, remainder);
                }
                if (fullGroupCount > 0) {
                    sb.append("(");
                    WebRegexUtils.appendOptionalFormattingRegex(sb, String.valueOf(numberSymbols.getGroupingSeparator()));
                    WebRegexUtils.appendRangeOption(sb, digit, groupSize);
                    sb.append("){0,").append(fullGroupCount).append('}');
                }
            } else {
                WebRegexUtils.appendRangeOption(sb, digit, precision);
            }
        } else if (!strictFormat) {
            if (useGrouping) {
                WebRegexUtils.appendRangeOption(sb, digit, groupSize);
                sb.append("(");
                WebRegexUtils.appendOptionalFormattingRegex(sb, String.valueOf(numberSymbols.getGroupingSeparator()));
                WebRegexUtils.appendRangeOption(sb, digit, groupSize);
                sb.append(")*");
            } else {
                sb.append("[").append(digit).append("]*");
            }
        }
        if (!NumberType.INTEGER.equals((Object)numberSymbols.getNumberType())) {
            sb.append('(');
            if (scale > 0) {
                WebRegexUtils.escapeSpecial(sb, String.valueOf(numberSymbols.getDecimalSeparator()));
                WebRegexUtils.appendRangeOption(sb, digit, scale);
            } else if (!strictFormat) {
                WebRegexUtils.escapeSpecial(sb, String.valueOf(numberSymbols.getDecimalSeparator()));
                sb.append("[").append(digit).append("]*");
            }
            sb.append(")?");
        }
        if (acceptNegative) {
            WebRegexUtils.appendOptionalFormattingRegex(sb, numberSymbols.getNegativeSuffix(), numberSymbols.getPositiveSuffix());
        } else {
            WebRegexUtils.appendOptionalFormattingRegex(sb, numberSymbols.getPositiveSuffix());
        }
        sb.append("$/");
        return sb.toString();
    }

    private static void appendRangeOption(StringBuilder sb, String pattern, int range) {
        sb.append("[").append(pattern).append(")]{0,").append(range).append('}');
    }

    private static void appendOptionalFormattingRegex(StringBuilder sb, String string) {
        int len = 0;
        if (string != null && (len = string.length()) > 0) {
            sb.append('(');
            boolean appendSym = false;
            for (int i = 1; i <= len; ++i) {
                if (appendSym) {
                    sb.append('|');
                } else {
                    appendSym = true;
                }
                WebRegexUtils.escapeSpecial(sb, string.substring(0, i));
            }
            sb.append(")?");
        }
    }

    private static void appendOptionalFormattingRegex(StringBuilder sb, String ... strings) {
        ArrayList<String> sbList = new ArrayList<String>();
        HashSet<String> testSet = new HashSet<String>();
        for (String string : strings) {
            if (testSet.contains(string)) continue;
            StringBuilder psb = new StringBuilder();
            WebRegexUtils.appendOptionalFormattingRegex(psb, string);
            if (psb.length() > 0) {
                sbList.add(psb.toString());
            }
            testSet.add(string);
        }
        if (!sbList.isEmpty()) {
            sb.append('(');
            boolean appendSym = false;
            for (String string : sbList) {
                if (appendSym) {
                    sb.append('|');
                } else {
                    appendSym = true;
                }
                sb.append(string);
            }
            sb.append(')');
        }
    }

    private static String escapeSpecial(String string) {
        StringBuilder sb = new StringBuilder();
        WebRegexUtils.escapeSpecial(sb, string);
        return sb.toString();
    }

    private static void escapeSpecial(StringBuilder sb, String string) {
        int len = string.length();
        block3: for (int i = 0; i < len; ++i) {
            char ch = string.charAt(i);
            switch (ch) {
                case '$': 
                case '(': 
                case ')': 
                case ',': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case 'd': 
                case '|': {
                    sb.append("\\\\");
                    sb.append(ch);
                    continue block3;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
    }
}

