/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.util;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.util.StringUtils;

public final class WebUtils {
    private WebUtils() {
    }

    public static String encodeShortcut(String shortcut) throws UnifyException {
        String encodedShortcut = null;
        if (StringUtils.isNotBlank((String)shortcut)) {
            int encoded = 0;
            String[] elements = shortcut.toUpperCase().split("\\+");
            boolean validShortcut = false;
            for (int i = 0; i < elements.length; ++i) {
                if ("SHIFT".equalsIgnoreCase(elements[i])) {
                    validShortcut = (encoded & 0x100) == 0;
                    if (!validShortcut) break;
                    encoded |= 0x100;
                    continue;
                }
                if ("CTRL".equalsIgnoreCase(elements[i])) {
                    validShortcut = (encoded & 0x200) == 0;
                    if (!validShortcut) break;
                    encoded |= 0x200;
                    continue;
                }
                if ("ALT".equalsIgnoreCase(elements[i])) {
                    validShortcut = (encoded & 0x400) == 0;
                    if (!validShortcut) break;
                    encoded |= 0x400;
                    continue;
                }
                validShortcut = (encoded & 0xFF) == 0 && elements[i].length() == 1;
                if (!validShortcut) break;
                encoded += elements[i].charAt(0);
            }
            if (!validShortcut) {
                throw new UnifyException("UWI_0006", new Object[]{shortcut});
            }
            encodedShortcut = String.valueOf(encoded);
        }
        return encodedShortcut;
    }
}

