/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.util;

import com.tcdng.unify.core.UnifyException;
import java.util.HashMap;
import java.util.Map;

public final class WriterUtils {
    private static Map<String, String> actionToJSMap = new HashMap<String, String>();
    private static Map<String, String> eventToJSMap;
    private static long refCounter;

    private WriterUtils() {
    }

    public static String getActionJSFunction(String actionType) throws UnifyException {
        String functionName = actionToJSMap.get(actionType);
        if (functionName == null) {
            throw new UnifyException("UWI_0001", new Object[]{actionType});
        }
        return functionName;
    }

    public static String getActionJSFunctionOptional(String actionType) throws UnifyException {
        String functionName = actionToJSMap.get(actionType);
        if (functionName == null) {
            return actionType;
        }
        return functionName;
    }

    public static String getEventJS(String eventType) throws UnifyException {
        String eventJS = eventToJSMap.get(eventType);
        if (eventJS == null) {
            throw new UnifyException("UWI_0001", new Object[]{eventType});
        }
        return eventJS;
    }

    public static long getNextRefId() {
        return ++refCounter;
    }

    static {
        actionToJSMap.put("forward", "ux.forward");
        actionToJSMap.put("submit", "ux.submit");
        actionToJSMap.put("post", "ux.post");
        actionToJSMap.put("posttopath", "ux.postToPath");
        actionToJSMap.put("postcommand", "ux.postCommand");
        actionToJSMap.put("openwindow", "ux.openWindow");
        actionToJSMap.put("download", "ux.download");
        actionToJSMap.put("clear", "ux.clear");
        actionToJSMap.put("disable", "ux.disable");
        actionToJSMap.put("show", "ux.show");
        actionToJSMap.put("hide", "ux.hide");
        actionToJSMap.put("delegate", "ux.delegate");
        actionToJSMap.put("setallchecked", "ux.setAllChecked");
        actionToJSMap.put("populateselect", "ux.populateSelectOptions");
        actionToJSMap.put("openpopup", "ux.openPopup");
        actionToJSMap.put("hidepopup", "ux.hidePopup");
        actionToJSMap.put("repositionmenupopup", "ux.repositionMenuPopup");
        eventToJSMap = new HashMap<String, String>();
        eventToJSMap.put("onblur", "blur");
        eventToJSMap.put("onchange", "change");
        eventToJSMap.put("oninput", "input");
        eventToJSMap.put("onclick", "click");
        eventToJSMap.put("ondblclick", "dblclick");
        eventToJSMap.put("onmouseover", "mouseover");
        eventToJSMap.put("onmouseout", "mouseout");
        eventToJSMap.put("onenter", "enter");
        eventToJSMap.put("onfocus", "focus");
    }
}

