/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.UplAttribute;
import com.tcdng.unify.core.annotation.UplAttributes;
import com.tcdng.unify.core.data.ValueStore;
import com.tcdng.unify.core.upl.UplElementReferences;
import com.tcdng.unify.core.util.StringUtils;
import com.tcdng.unify.web.ui.DataTransferBlock;
import com.tcdng.unify.web.ui.util.WidgetUtils;
import com.tcdng.unify.web.ui.widget.AbstractWidget;
import com.tcdng.unify.web.ui.widget.Container;
import com.tcdng.unify.web.ui.widget.DataTransferWidget;
import com.tcdng.unify.web.ui.widget.Layout;
import com.tcdng.unify.web.ui.widget.Widget;
import com.tcdng.unify.web.ui.widget.WidgetNameInfo;
import com.tcdng.unify.web.ui.widget.WidgetRepository;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@UplAttributes(value={@UplAttribute(name="layout", type=Layout.class), @UplAttribute(name="components", type=UplElementReferences.class), @UplAttribute(name="alternate", type=boolean.class, defaultVal="false"), @UplAttribute(name="arrayCascade", type=boolean.class, defaultVal="false"), @UplAttribute(name="space", type=boolean.class, defaultVal="false")})
public abstract class AbstractContainer
extends AbstractWidget
implements Container {
    private WidgetRepository widgetRepository;
    private Map<String, Widget> internalWidgets;
    private Object oldValue;
    private ValueStore thisValueStore;
    private ValueStore bindingValueStore;
    private boolean useLayoutIfPresent;

    public AbstractContainer() {
        this(true);
    }

    public AbstractContainer(boolean useLayoutIfPresent) {
        this.useLayoutIfPresent = useLayoutIfPresent;
    }

    @Override
    public boolean isField() {
        return false;
    }

    @Override
    public void setWidgetRepository(WidgetRepository widgetRepository) throws UnifyException {
        this.widgetRepository = widgetRepository;
    }

    @Override
    public WidgetRepository getWidgetRepository() {
        return this.widgetRepository;
    }

    @Override
    public boolean hasWidgetRepository() {
        return this.widgetRepository != null;
    }

    @Override
    public void setValueStore(ValueStore valueStore) throws UnifyException {
        super.setValueStore(valueStore);
        this.cascadeValueStore();
    }

    @Override
    public Set<String> getWidgetLongNames() throws UnifyException {
        return this.widgetRepository.getWidgetInfo(this.getLongName()).getDeepNames();
    }

    protected WidgetNameInfo getWidgetInfo() throws UnifyException {
        return this.widgetRepository.getWidgetInfo(this.getLongName());
    }

    @Override
    public boolean isWidget(String longName) throws UnifyException {
        return this.widgetRepository.isWidget(longName);
    }

    @Override
    public Widget getWidgetByLongName(String longName) throws UnifyException {
        Widget widget = this.widgetRepository.getWidget(longName);
        if (widget == null) {
            throw new UnifyException("UWI_000C", new Object[]{longName, this.getLongName()});
        }
        return widget;
    }

    @Override
    public Widget getWidgetByShortName(String shortName) throws UnifyException {
        Widget widget = this.widgetRepository.getWidget(this.getLongName(), shortName);
        if (widget != null) {
            return widget;
        }
        String parentLongName = this.getParentLongName();
        if (StringUtils.isNotBlank((String)parentLongName) && (widget = this.widgetRepository.getWidget(parentLongName, shortName)) != null) {
            return widget;
        }
        throw new UnifyException("UWI_000D", new Object[]{shortName, this.getLongName()});
    }

    @Override
    public <T> T getWidgetByLongName(Class<T> clazz, String longName) throws UnifyException {
        return (T)this.getWidgetByLongName(longName);
    }

    @Override
    public <T> T getWidgetByShortName(Class<T> clazz, String shortName) throws UnifyException {
        return (T)this.getWidgetByShortName(shortName);
    }

    @Override
    public void setWidgetDisabled(String shortName, boolean disabled) throws UnifyException {
        this.getWidgetByShortName(shortName).setDisabled(disabled);
    }

    @Override
    public boolean isWidgetDisabled(String shortName) throws UnifyException {
        return this.getWidgetByShortName(shortName).isDisabled();
    }

    @Override
    public void setWidgetVisible(String shortName, boolean visible) throws UnifyException {
        this.getWidgetByShortName(shortName).setVisible(visible);
    }

    @Override
    public boolean isWidgetVisible(String shortName) throws UnifyException {
        return this.getWidgetByShortName(shortName).isVisible();
    }

    @Override
    public void setWidgetEditable(String shortName, boolean editable) throws UnifyException {
        this.getWidgetByShortName(shortName).setEditable(editable);
    }

    @Override
    public boolean isWidgetEditable(String shortName) throws UnifyException {
        return this.getWidgetByShortName(shortName).isEditable();
    }

    @Override
    public void populate(DataTransferBlock transferBlock) throws UnifyException {
        if (transferBlock != null) {
            DataTransferBlock childBlock = transferBlock.getChildBlock();
            DataTransferWidget childWidget = (DataTransferWidget)this.internalWidgets.get(childBlock.getId());
            childWidget.populate(childBlock);
        }
    }

    @Override
    public List<String> getLayoutWidgetLongNames() throws UnifyException {
        return this.getShallowReferencedLongNames("components");
    }

    @Override
    public boolean isUseLayoutIfPresent() {
        return this.useLayoutIfPresent;
    }

    @Override
    public List<ValueStore> getRepeatValueStores() throws UnifyException {
        return null;
    }

    @Override
    public Layout getLayout() throws UnifyException {
        return (Layout)this.getUplAttribute(Layout.class, "layout");
    }

    @Override
    public boolean isSpace() throws UnifyException {
        return (Boolean)this.getUplAttribute(Boolean.TYPE, "space");
    }

    @Override
    public boolean isAlternate() throws UnifyException {
        return (Boolean)this.getUplAttribute(Boolean.TYPE, "alternate");
    }

    @Override
    public boolean isRepeater() {
        return false;
    }

    @Override
    public final void setValue(Object value) throws UnifyException {
        super.setValue(value);
        this.cascadeValueStore();
    }

    @Override
    public final Object getValue(String attribute) throws UnifyException {
        if (attribute != null) {
            return super.getValue(attribute);
        }
        if (this.getValueStore() != null) {
            return this.getValueStore().getValueObject();
        }
        return null;
    }

    @Override
    public void cascadeValueStore() throws UnifyException {
        String binding = this.getBinding();
        ValueStore valueStore = this.getValueStore();
        if (binding == null) {
            for (String longName : this.getShallowWidgetLongNames()) {
                Widget widget = this.widgetRepository.getWidget(longName);
                if (!widget.isValueConforming(this)) continue;
                widget.setValueStore(valueStore);
            }
        } else {
            Object value = this.getValue(binding);
            if (this.oldValue != value) {
                this.bindingValueStore = null;
                if (value == null) {
                    for (String longName : this.getShallowWidgetLongNames()) {
                        Widget widget = this.widgetRepository.getWidget(longName);
                        if (!widget.isValueConforming(this)) continue;
                        if (widget.isFixedConforming()) {
                            widget.setValueStore(valueStore);
                            continue;
                        }
                        widget.setValueStore(null);
                    }
                } else if (((Boolean)this.getUplAttribute(Boolean.TYPE, "arrayCascade")).booleanValue()) {
                    List values = (List)value;
                    int i = 0;
                    for (String longName : this.getShallowWidgetLongNames()) {
                        Widget widget = this.widgetRepository.getWidget(longName);
                        if (!widget.isValueConforming(this)) continue;
                        if (widget.isFixedConforming()) {
                            widget.setValueStore(valueStore);
                            continue;
                        }
                        widget.setValueStore(this.createValueStore(values.get(i), i++));
                    }
                } else {
                    this.bindingValueStore = this.createValueStore(value);
                    for (String longName : this.getShallowWidgetLongNames()) {
                        Widget widget = this.widgetRepository.getWidget(longName);
                        if (!widget.isValueConforming(this)) continue;
                        if (widget.isFixedConforming()) {
                            widget.setValueStore(valueStore);
                            continue;
                        }
                        widget.setValueStore(this.bindingValueStore);
                    }
                }
                this.oldValue = value;
            }
        }
    }

    @Override
    public Widget getChildWidget(String childId) throws UnifyException {
        if (this.internalWidgets != null) {
            return this.internalWidgets.get(childId);
        }
        return null;
    }

    protected Set<String> getAllWidgetLongNames() throws UnifyException {
        return this.widgetRepository.getWidgetLongNames();
    }

    protected List<String> getAllWidgetIds() throws UnifyException {
        return this.widgetRepository.getWidgetIds();
    }

    protected Widget addInternalWidget(String descriptor) throws UnifyException {
        Widget widget = (Widget)this.getUplComponent(this.getSessionLocale(), descriptor, false);
        if (this.internalWidgets == null) {
            this.internalWidgets = new HashMap<String, Widget>();
        }
        int childIndex = this.internalWidgets.size();
        String childId = WidgetUtils.getChildId(this.getId(), widget.getId(), childIndex);
        widget.setId(childId);
        widget.onPageConstruct();
        widget.setContainer(this.getContainer());
        this.setWidgetValueBeanToThis(widget);
        this.internalWidgets.put(childId, widget);
        return widget;
    }

    protected void setComponentValueBeanToThis(String shortName) throws UnifyException {
        Widget widget = this.getWidgetByShortName(shortName);
        this.setWidgetValueBeanToThis(widget);
    }

    protected void setVisible(String shortName, boolean visible) throws UnifyException {
        this.getWidgetByShortName(shortName).setVisible(visible);
    }

    protected void setEditable(String shortName, boolean editable) throws UnifyException {
        this.getWidgetByShortName(shortName).setEditable(editable);
    }

    protected void setDisabled(String shortName, boolean disabled) throws UnifyException {
        this.getWidgetByShortName(shortName).setDisabled(disabled);
    }

    protected boolean isNoReferencedComponents() throws UnifyException {
        return this.getWidgetLongNames().isEmpty();
    }

    protected ValueStore getChildBindingValueStore() throws UnifyException {
        if (this.bindingValueStore != null) {
            return this.bindingValueStore;
        }
        return this.getValueStore();
    }

    protected List<String> getShallowWidgetLongNames() throws UnifyException {
        return this.widgetRepository.getWidgetInfo(this.getLongName()).getShallowNames();
    }

    private void setWidgetValueBeanToThis(Widget widget) throws UnifyException {
        if (this.thisValueStore == null) {
            this.thisValueStore = this.createValueStore(this);
        }
        widget.setValueStore(this.thisValueStore);
        widget.setConforming(false);
    }
}

