/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.UplAttribute;
import com.tcdng.unify.core.annotation.UplAttributes;
import com.tcdng.unify.core.constant.TriState;
import com.tcdng.unify.core.upl.UplElementReferences;
import com.tcdng.unify.web.ui.DataTransferBlock;
import com.tcdng.unify.web.ui.util.WidgetUtils;
import com.tcdng.unify.web.ui.widget.AbstractWidget;
import com.tcdng.unify.web.ui.widget.Control;
import com.tcdng.unify.web.ui.widget.control.ControlColorMode;
import java.util.Collections;
import java.util.List;

@UplAttributes(value={@UplAttribute(name="focus", type=boolean.class), @UplAttribute(name="sortable", type=boolean.class), @UplAttribute(name="required", type=boolean.class, defaultVal="false"), @UplAttribute(name="layoutColorMode", type=boolean.class, defaultVal="false")})
public abstract class AbstractControl
extends AbstractWidget
implements Control {
    private TriState required = TriState.CONFORMING;
    private ControlColorMode colorMode = ControlColorMode.NORMAL;

    @Override
    public String getStyleClass() throws UnifyException {
        if (ControlColorMode.NORMAL.equals((Object)this.colorMode) || this.isLayoutColorMode()) {
            return super.getStyleClass();
        }
        return super.getStyleClass() + " " + this.colorMode.styleClass();
    }

    @Override
    public String getId() throws UnifyException {
        int index = this.getValueIndex();
        if (index >= 0) {
            return WidgetUtils.getDataIndexId(super.getId(), index);
        }
        return super.getId();
    }

    @Override
    public String getBaseId() throws UnifyException {
        return super.getId();
    }

    @Override
    public String getFacadeId() throws UnifyException {
        return this.getPrefixedId("fac_");
    }

    @Override
    public String getBorderId() throws UnifyException {
        return this.getId();
    }

    @Override
    public String getNotificationId() throws UnifyException {
        return this.getPrefixedId("notf_");
    }

    @Override
    public void populate(DataTransferBlock transferBlock) throws UnifyException {
        String binding = this.getBinding();
        if (binding != null) {
            this.getValueStore().store(transferBlock.getItemIndex(), binding, transferBlock.getValue());
        }
    }

    @Override
    public boolean setFocus() throws UnifyException {
        return this.getRequestContextUtil().setFocusOnWidgetId(this.getId());
    }

    @Override
    public boolean isFocus() throws UnifyException {
        return (Boolean)this.getUplAttribute(Boolean.TYPE, "focus");
    }

    @Override
    public boolean isLayoutColorMode() throws UnifyException {
        return (Boolean)this.getUplAttribute(Boolean.TYPE, "layoutColorMode");
    }

    @Override
    public void setRequired(TriState required) throws UnifyException {
        this.required = required;
    }

    @Override
    public TriState getRequired() throws UnifyException {
        TriState result = this.getViewDirective().getRequired();
        if (result.isConforming() && (result = this.required).isConforming()) {
            result = TriState.getTriState((boolean)((Boolean)this.getUplAttribute(Boolean.TYPE, "required")));
        }
        return result;
    }

    @Override
    public boolean isField() {
        return true;
    }

    @Override
    public void setColorMode(ControlColorMode colorMode) {
        this.colorMode = colorMode;
    }

    @Override
    public ControlColorMode getColorMode() {
        return this.colorMode;
    }

    protected List<String> getPageNames(UplElementReferences uer) throws UnifyException {
        if (uer != null) {
            return this.getPageManager().getPageNames(uer.getLongNames());
        }
        return Collections.emptyList();
    }
}

