/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.UplAttribute;
import com.tcdng.unify.core.annotation.UplAttributes;
import com.tcdng.unify.core.data.ValueStore;
import com.tcdng.unify.core.upl.UplElementReferences;
import com.tcdng.unify.core.upl.UplUtils;
import com.tcdng.unify.core.util.DataUtils;
import com.tcdng.unify.web.ui.DataTransferBlock;
import com.tcdng.unify.web.ui.util.WidgetUtils;
import com.tcdng.unify.web.ui.widget.AbstractControl;
import com.tcdng.unify.web.ui.widget.DataTransferWidget;
import com.tcdng.unify.web.ui.widget.MultiControl;
import com.tcdng.unify.web.ui.widget.Page;
import com.tcdng.unify.web.ui.widget.Widget;
import com.tcdng.unify.web.ui.widget.panel.StandalonePanel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@UplAttributes(value={@UplAttribute(name="components", type=UplElementReferences.class), @UplAttribute(name="valueMarker", type=String.class)})
public abstract class AbstractMultiControl
extends AbstractControl
implements MultiControl {
    private Map<String, ChildWidgetInfo> widgetInfoMap = new LinkedHashMap<String, ChildWidgetInfo>();
    private ValueStore thisValueStore;
    private List<String> standalonePanelNames;
    private String uplValueMarker;
    private int childIndex;

    @Override
    public final void onPageConstruct() throws UnifyException {
        super.onPageConstruct();
        this.uplValueMarker = (String)this.getUplAttribute(String.class, "valueMarker");
        this.doOnPageConstruct();
    }

    @Override
    public void addChildWidget(Widget widget) throws UnifyException {
        this.doAddChildWidget(widget, false, false, false, true);
    }

    @Override
    public void setValueStore(ValueStore valueStore) throws UnifyException {
        super.setValueStore(valueStore);
        for (ChildWidgetInfo childWidgetInfo : this.widgetInfoMap.values()) {
            if (!childWidgetInfo.isConforming()) continue;
            childWidgetInfo.getWidget().setValueStore(valueStore);
        }
    }

    @Override
    public void setDisabled(boolean disabled) {
        super.setDisabled(disabled);
        for (ChildWidgetInfo childWidgetInfo : this.widgetInfoMap.values()) {
            if (childWidgetInfo.isIgnoreParentState()) continue;
            childWidgetInfo.getWidget().setDisabled(disabled);
        }
    }

    @Override
    public void setEditable(boolean editable) {
        super.setEditable(editable);
        for (ChildWidgetInfo childWidgetInfo : this.widgetInfoMap.values()) {
            if (childWidgetInfo.isIgnoreParentState()) continue;
            childWidgetInfo.getWidget().setEditable(editable);
        }
    }

    @Override
    public void populate(DataTransferBlock transferBlock) throws UnifyException {
        if (transferBlock != null) {
            DataTransferBlock childBlock = transferBlock.getChildBlock();
            if (childBlock == null) {
                super.populate(transferBlock);
            } else {
                DataTransferWidget dtWidget = (DataTransferWidget)this.getChildWidgetInfo(childBlock.getId()).getWidget();
                dtWidget.populate(childBlock);
                this.onInternalChildPopulated(dtWidget);
            }
        }
    }

    @Override
    public ChildWidgetInfo getChildWidgetInfo(String childId) {
        return this.widgetInfoMap.get(childId);
    }

    @Override
    public Collection<ChildWidgetInfo> getChildWidgetInfos() {
        return this.widgetInfoMap.values();
    }

    @Override
    public int getChildWidgetCount() {
        return this.widgetInfoMap.size();
    }

    @Override
    public void setId(String id) throws UnifyException {
        boolean changed = !DataUtils.equals((Object)this.getId(), (Object)id);
        super.setId(id);
        if (changed && !this.widgetInfoMap.isEmpty()) {
            LinkedHashMap<String, ChildWidgetInfo> map = new LinkedHashMap<String, ChildWidgetInfo>();
            for (ChildWidgetInfo childWidgetInfo : this.widgetInfoMap.values()) {
                Widget widget = childWidgetInfo.getWidget();
                String newChildId = WidgetUtils.renameChildId(id, widget.getId());
                widget.setId(newChildId);
                map.put(newChildId, childWidgetInfo);
            }
            this.widgetInfoMap = map;
        }
    }

    @Override
    public final Object getValue(String attribute) throws UnifyException {
        if (attribute != null) {
            return super.getValue(attribute);
        }
        if (this.getValueStore() != null) {
            return this.getValueStore().getValueObject();
        }
        return null;
    }

    @Override
    public Widget getChildWidget(String childId) throws UnifyException {
        ChildWidgetInfo childWidgetInfo;
        if (this.widgetInfoMap != null && (childWidgetInfo = this.widgetInfoMap.get(childId)) != null) {
            return childWidgetInfo.getWidget();
        }
        return null;
    }

    protected String getUplValueMarker() {
        return this.uplValueMarker;
    }

    protected Widget addExternalChildWidget(String descriptor) throws UnifyException {
        Widget widget = (Widget)this.getUplComponent(this.getSessionLocale(), descriptor, false);
        this.doAddChildWidget(widget, true, false, false, true);
        return widget;
    }

    protected Widget addExternalChildStandalonePanel(String panelName, String cloneId) throws UnifyException {
        String uniqueName = UplUtils.generateUplComponentCloneName((String)panelName, (String)cloneId);
        Page page = this.getRequestContextUtil().getRequestPage();
        StandalonePanel standalonePanel = page.getStandalonePanel(uniqueName);
        if (standalonePanel == null) {
            standalonePanel = this.getPageManager().createStandalonePanel(this.getSessionLocale(), uniqueName);
            page.addStandalonePanel(uniqueName, standalonePanel);
            this.getUIControllerUtil().updatePageControllerInfo(this.getRequestContextUtil().getResponsePathParts().getControllerName(), uniqueName);
            if (this.standalonePanelNames == null) {
                this.standalonePanelNames = new ArrayList<String>();
            }
            this.standalonePanelNames.add(uniqueName);
        }
        standalonePanel.setContainer(this.getContainer());
        this.doAddChildWidget(standalonePanel, true, false, false, true);
        return standalonePanel;
    }

    @Override
    public void addPageAliases() throws UnifyException {
        super.addPageAliases();
        if (this.standalonePanelNames != null) {
            Page page = this.getRequestContextUtil().getRequestPage();
            for (String uniqueName : this.standalonePanelNames) {
                StandalonePanel standalonePanel = page.getStandalonePanel(uniqueName);
                if (standalonePanel == null) continue;
                List<String> aliases = this.getPageManager().getExpandedReferences(standalonePanel.getId());
                this.getRequestContextUtil().addPageAlias(this.getId(), (String[])DataUtils.toArray(String.class, aliases));
            }
        }
    }

    protected final ValueStore createValueStore(Object storageObject, int dataIndex) throws UnifyException {
        if (this.uplValueMarker != null) {
            return super.createValueStore(storageObject, this.uplValueMarker, dataIndex);
        }
        return super.createValueStore(storageObject, dataIndex);
    }

    protected void removeAllExternalChildWidgets() throws UnifyException {
        LinkedHashMap<String, ChildWidgetInfo> map = new LinkedHashMap<String, ChildWidgetInfo>();
        for (Map.Entry<String, ChildWidgetInfo> entry : this.widgetInfoMap.entrySet()) {
            if (entry.getValue().isExternal()) continue;
            map.put(entry.getKey(), entry.getValue());
        }
        this.widgetInfoMap = map;
        if (this.standalonePanelNames != null) {
            Page page = this.getRequestContextUtil().getRequestPage();
            for (String uniqueName : this.standalonePanelNames) {
                page.removeStandalonePanel(uniqueName);
            }
        }
        this.standalonePanelNames = null;
    }

    protected Widget addInternalChildWidget(String descriptor) throws UnifyException {
        return this.addInternalChildWidget(descriptor, false, false);
    }

    protected Widget addInternalChildWidget(String descriptor, boolean conforming, boolean ignoreParentState) throws UnifyException {
        Widget widget = (Widget)this.getUplComponent(this.getSessionLocale(), descriptor, false);
        this.doAddChildWidget(widget, true, conforming, ignoreParentState, false);
        return widget;
    }

    protected void addPageAlias(Widget widget) throws UnifyException {
        this.getRequestContextUtil().addPageAlias(this.getId(), widget.getId());
    }

    protected void addPageAlias(String id) throws UnifyException {
        this.getRequestContextUtil().addPageAlias(this.getId(), id);
    }

    protected void onInternalChildPopulated(Widget widget) throws UnifyException {
    }

    protected abstract void doOnPageConstruct() throws UnifyException;

    private void doAddChildWidget(Widget widget, boolean pageConstruct, boolean conforming, boolean ignoreParentState, boolean external) throws UnifyException {
        String childId = WidgetUtils.getChildId(this.getId(), widget.getId(), this.childIndex++);
        widget.setId(childId);
        if (pageConstruct) {
            widget.onPageConstruct();
            widget.setContainer(this.getContainer());
        }
        if (!ignoreParentState) {
            widget.setEditable(this.isEditable());
            widget.setDisabled(this.isDisabled());
        }
        if (conforming) {
            widget.setValueStore(this.getValueStore());
        } else {
            widget.setValueStore(this.getThisValueStore());
        }
        widget.setConforming(conforming);
        this.widgetInfoMap.put(childId, new ChildWidgetInfo(widget, ignoreParentState, external));
    }

    private ValueStore getThisValueStore() throws UnifyException {
        if (this.thisValueStore == null) {
            this.thisValueStore = this.createValueStore(this);
        }
        return this.thisValueStore;
    }

    public static class ChildWidgetInfo {
        private Widget widget;
        private boolean external;
        private boolean ignoreParentState;

        public ChildWidgetInfo(Widget widget, boolean ignoreParentState, boolean external) {
            this.widget = widget;
            this.ignoreParentState = ignoreParentState;
            this.external = external;
        }

        public Widget getWidget() {
            return this.widget;
        }

        public boolean isIgnoreParentState() {
            return this.ignoreParentState;
        }

        public boolean isExternal() {
            return this.external;
        }

        public boolean isConforming() {
            return this.widget.isConforming();
        }

        public boolean isPrivilegeVisible() throws UnifyException {
            return this.widget.isVisible();
        }

        public String toString() {
            return "ChildWidgetInfo [widget=" + this.widget + ", external=" + this.external + ", ignoreParentState=" + this.ignoreParentState + "]";
        }
    }
}

