/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.UplAttribute;
import com.tcdng.unify.core.annotation.UplAttributes;
import com.tcdng.unify.core.data.DownloadFile;
import com.tcdng.unify.core.util.StringUtils;
import com.tcdng.unify.web.annotation.Action;
import com.tcdng.unify.web.ui.widget.AbstractContainer;
import com.tcdng.unify.web.ui.widget.Panel;
import com.tcdng.unify.web.ui.widget.PanelEventListener;
import com.tcdng.unify.web.ui.widget.data.Hint;
import com.tcdng.unify.web.ui.widget.data.MessageBox;
import com.tcdng.unify.web.ui.widget.data.MessageIcon;
import com.tcdng.unify.web.ui.widget.data.MessageMode;
import java.util.ArrayList;
import java.util.List;

@UplAttributes(value={@UplAttribute(name="backImageSrc", type=String.class), @UplAttribute(name="refreshPath", type=String.class), @UplAttribute(name="refreshEvery", type=int.class), @UplAttribute(name="refreshOnUserAct", type=boolean.class, defaultVal="true"), @UplAttribute(name="legend", type=String.class), @UplAttribute(name="hideOnNoComponents", type=boolean.class, defaultVal="false")})
public abstract class AbstractPanel
extends AbstractContainer
implements Panel {
    private List<PanelEventListener> listeners;
    private boolean allowRefresh = true;

    @Override
    public void resetState() throws UnifyException {
    }

    @Override
    @Action
    public void switchState() throws UnifyException {
        this.getRequestContextUtil().setPanelSwitchStateFlag(this);
    }

    @Override
    public boolean isVisible() throws UnifyException {
        if (((Boolean)this.getUplAttribute(Boolean.TYPE, "hideOnNoComponents")).booleanValue() && this.isNoReferencedComponents()) {
            return false;
        }
        return super.isVisible();
    }

    @Override
    public boolean isAllowRefresh() {
        return this.allowRefresh;
    }

    @Override
    public boolean isSupportReadOnly() {
        return false;
    }

    @Override
    public boolean isSupportDisabled() {
        return false;
    }

    @Override
    public void addEventListener(PanelEventListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<PanelEventListener>();
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeEventListener(PanelEventListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public String getBackImageSrc() throws UnifyException {
        return (String)this.getUplAttribute(String.class, "backImageSrc");
    }

    @Override
    public String getRefreshPath() throws UnifyException {
        return (String)this.getUplAttribute(String.class, "refreshPath");
    }

    @Override
    public int getRefreshEvery() throws UnifyException {
        return (Integer)this.getUplAttribute(Integer.TYPE, "refreshEvery");
    }

    @Override
    public boolean isRefreshOnUserAct() throws UnifyException {
        return (Boolean)this.getUplAttribute(Boolean.TYPE, "refreshOnUserAct");
    }

    @Override
    public String getLegend() throws UnifyException {
        return (String)this.getUplAttribute(String.class, "legend");
    }

    protected void hintUser(String messageKey, Object ... params) throws UnifyException {
        this.getRequestContextUtil().hintUser(Hint.MODE.INFO, messageKey, params);
    }

    protected void hintUser(Hint.MODE mode, String messageKey, Object ... params) throws UnifyException {
        this.getRequestContextUtil().hintUser(mode, messageKey, params);
    }

    protected void clearHintUser() throws UnifyException {
        this.getRequestContextUtil().clearHintUser();
    }

    protected void setAllowRefresh(boolean allowRefresh) {
        this.allowRefresh = allowRefresh;
    }

    protected void notifyListeners(String eventCode) throws UnifyException {
        if (this.listeners != null) {
            for (PanelEventListener listener : this.listeners) {
                listener.notify(this, eventCode);
            }
        }
    }

    protected void fileDownloadResult(DownloadFile downloadFile, boolean hidePopup) throws UnifyException {
        this.setRequestAttribute("WR.downloadFile", downloadFile);
        if (hidePopup) {
            this.setCommandResultMapping("resrv.downloadfilehidepopup");
        } else {
            this.setCommandResultMapping("resrv.downloadfile");
        }
    }

    protected void showMessageBox(String message) throws UnifyException {
        this.showMessageBox(MessageIcon.INFO, MessageMode.OK, "$m{messagebox.message}", message, null);
    }

    protected void showMessageBox(MessageIcon messageIcon, MessageMode messageMode, String message) throws UnifyException {
        this.showMessageBox(messageIcon, messageMode, "$m{messagebox.message}", message, null);
    }

    protected void showMessageBox(String message, String actionPath) throws UnifyException {
        this.showMessageBox(MessageIcon.INFO, MessageMode.OK, "$m{messagebox.message}", message, actionPath);
    }

    protected void showMessageBox(String caption, String message, String fullActionPath) throws UnifyException {
        this.showMessageBox(MessageIcon.INFO, MessageMode.OK, caption, message, fullActionPath);
    }

    protected void showMessageBox(MessageIcon messageIcon, MessageMode messageMode, String caption, String message, String fullActionPath) throws UnifyException {
        if (StringUtils.isBlank((String)fullActionPath)) {
            fullActionPath = "/commonutilities/hidePopup";
        }
        caption = this.resolveSessionMessage(caption, new Object[0]);
        message = this.resolveSessionMessage(message, new Object[0]);
        this.setSessionAttribute("UNIFYWEB.MESSAGEBOX", new MessageBox(messageIcon, messageMode, caption, message, fullActionPath));
        this.setCommandResultMapping("showapplicationmessage");
    }
}

