/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.regex.RegexPatternStore;
import com.tcdng.unify.web.ui.DataTransfer;
import com.tcdng.unify.web.ui.DataTransferBlock;
import com.tcdng.unify.web.ui.widget.AbstractPageValidation;
import com.tcdng.unify.web.ui.widget.Control;
import com.tcdng.unify.web.ui.widget.Widget;
import java.util.List;
import java.util.regex.Matcher;

public abstract class AbstractRegexPageValidation
extends AbstractPageValidation {
    private String validationCode;
    private String regexKey;
    private String errorKey;

    public AbstractRegexPageValidation(String validationCode, String regexKey, String errorKey) {
        this.validationCode = validationCode;
        this.regexKey = regexKey;
        this.errorKey = errorKey;
    }

    @Override
    public boolean validate(List<Widget> widgets, DataTransfer dataTransfer) throws UnifyException {
        boolean pass = true;
        for (Widget widget : widgets) {
            Matcher matcher;
            String value;
            if (!widget.isVisible()) continue;
            boolean localPass = true;
            DataTransferBlock dataTransferBlock = dataTransfer.getDataTransferBlock(widget.getId());
            if (dataTransferBlock != null && (value = this.getTransferValue(String.class, dataTransferBlock)) != null && !(matcher = ((RegexPatternStore)this.getComponent("appication-regexpatternstore")).getPattern(this.getSessionLocale(), this.regexKey).matcher(value)).matches()) {
                String caption = (String)widget.getUplAttribute(String.class, "caption");
                String message = this.getSessionMessage(this.errorKey, new Object[]{caption});
                this.addValidationFail((Control)widget, this.validationCode, message);
                localPass = false;
                pass = false;
            }
            if (!localPass) continue;
            this.addValidationPass((Control)widget, this.validationCode);
        }
        return pass;
    }
}

