/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.util.DataUtils;
import com.tcdng.unify.web.ui.widget.AbstractContainer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractValueListContainer<T, U>
extends AbstractContainer {
    private List<U> oldItemList;
    private List<T> valueList = Collections.emptyList();

    public AbstractValueListContainer() {
        this(false);
    }

    public AbstractValueListContainer(boolean useLayoutIfPresent) {
        super(useLayoutIfPresent);
    }

    public List<T> getValueList() throws UnifyException {
        List<U> itemList = this.getItemList();
        if (this.oldItemList != itemList || itemList != null && itemList.size() != this.valueList.size()) {
            if (DataUtils.isNotBlank(itemList)) {
                int size = itemList.size();
                this.valueList = new ArrayList<T>(itemList.size());
                for (int i = 0; i < size; ++i) {
                    this.valueList.add(this.newValue(itemList.get(i), i));
                }
            } else {
                this.valueList = Collections.emptyList();
            }
            this.oldItemList = itemList;
            this.onCreateValueList(this.valueList);
        }
        return this.valueList;
    }

    protected void invalidateValueList() {
        this.oldItemList = null;
        this.valueList = null;
    }

    protected abstract List<U> getItemList() throws UnifyException;

    protected abstract T newValue(U var1, int var2) throws UnifyException;

    protected abstract void onCreateValueList(List<T> var1) throws UnifyException;
}

