/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.web.ui.widget.AbstractMultiControl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractValueListMultiControl<T, U>
extends AbstractMultiControl {
    private List<U> oldItemList;
    private List<T> valueList = Collections.emptyList();

    public List<T> getValueList() throws UnifyException {
        List<U> itemList = this.getItemList();
        if (this.oldItemList != itemList || itemList != null && itemList.size() != this.valueList.size()) {
            if (itemList != null && !itemList.isEmpty()) {
                int size = itemList.size();
                this.valueList = new ArrayList<T>(itemList.size());
                for (int i = 0; i < size; ++i) {
                    this.valueList.add(this.newValue(itemList.get(i), i));
                }
            } else {
                this.valueList = Collections.emptyList();
            }
            this.oldItemList = itemList;
            this.onCreateValueList(this.valueList);
        }
        return this.valueList;
    }

    protected U getItem(int index) {
        if (this.oldItemList != null && index < this.oldItemList.size()) {
            return this.oldItemList.get(index);
        }
        return null;
    }

    protected void invalidateValueList() {
        this.oldItemList = null;
        this.valueList = null;
    }

    protected abstract List<U> getItemList() throws UnifyException;

    protected abstract T newValue(U var1, int var2) throws UnifyException;

    protected abstract void onCreateValueList(List<T> var1) throws UnifyException;
}

