/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.ViewDirective;
import com.tcdng.unify.core.annotation.UplAttribute;
import com.tcdng.unify.core.annotation.UplAttributes;
import com.tcdng.unify.core.data.ValueStore;
import com.tcdng.unify.core.upl.AbstractUplComponent;
import com.tcdng.unify.core.util.StringUtils;
import com.tcdng.unify.web.TargetPath;
import com.tcdng.unify.web.ui.PageRequestContextUtil;
import com.tcdng.unify.web.ui.UIControllerUtil;
import com.tcdng.unify.web.ui.util.WidgetUtils;
import com.tcdng.unify.web.ui.widget.Container;
import com.tcdng.unify.web.ui.widget.EventHandler;
import com.tcdng.unify.web.ui.widget.Page;
import com.tcdng.unify.web.ui.widget.PageManager;
import com.tcdng.unify.web.ui.widget.Panel;
import com.tcdng.unify.web.ui.widget.Widget;
import com.tcdng.unify.web.ui.widget.WriteWork;
import com.tcdng.unify.web.ui.widget.panel.StandalonePanel;
import java.text.MessageFormat;
import java.util.Collection;

@UplAttributes(value={@UplAttribute(name="binding", type=String.class), @UplAttribute(name="styleClass", type=String.class, defaultVal="$e{}"), @UplAttribute(name="styleClassBinding", type=String.class), @UplAttribute(name="style", type=String.class), @UplAttribute(name="caption", type=String.class), @UplAttribute(name="captionBinding", type=String.class), @UplAttribute(name="captionParamBinding", type=String.class), @UplAttribute(name="columnStyle", type=String.class), @UplAttribute(name="columnSelectSummary", type=boolean.class), @UplAttribute(name="hint", type=String.class), @UplAttribute(name="hintBinding", type=String.class), @UplAttribute(name="readOnly", type=boolean.class, defaultVal="false"), @UplAttribute(name="ignoreParentState", type=boolean.class, defaultVal="false"), @UplAttribute(name="privilege", type=String.class), @UplAttribute(name="fixedConforming", type=boolean.class, defaultVal="false"), @UplAttribute(name="hidden", type=boolean.class, defaultVal="false"), @UplAttribute(name="behaviorAlways", type=boolean.class, defaultVal="false"), @UplAttribute(name="eventHandler", type=EventHandler[].class)})
public abstract class AbstractWidget
extends AbstractUplComponent
implements Widget {
    private String id;
    private String groupId;
    private Container container;
    private ValueStore valueStore;
    private int tabIndex = -1;
    private boolean conforming = true;
    private boolean disabled = false;
    private boolean editable = true;
    private boolean visible = true;

    @Override
    public String getId() throws UnifyException {
        return this.id;
    }

    @Override
    public void setId(String id) throws UnifyException {
        this.id = id;
    }

    @Override
    public String getGroupId() throws UnifyException {
        return this.groupId;
    }

    @Override
    public void setGroupId(String groupId) throws UnifyException {
        this.groupId = groupId;
    }

    @Override
    public String getFacadeId() throws UnifyException {
        return this.id;
    }

    @Override
    public String getPrefixedId(String prefix) throws UnifyException {
        return prefix + this.getId();
    }

    @Override
    public String getNamingIndexedId(int index) throws UnifyException {
        return WidgetUtils.getNamingIndexId(this.getId(), index);
    }

    @Override
    public String getCaption() throws UnifyException {
        String caption = null;
        String captionBinding = (String)this.getUplAttribute(String.class, "captionBinding");
        if (captionBinding != null && !captionBinding.isEmpty()) {
            caption = this.getStringValue(captionBinding);
        }
        caption = caption != null ? caption : (String)this.getUplAttribute(String.class, "caption");
        String captionParamBinding = (String)this.getUplAttribute(String.class, "captionParamBinding");
        if (captionParamBinding != null) {
            return MessageFormat.format(caption, this.getValue(captionParamBinding));
        }
        return caption;
    }

    @Override
    public String getBinding() throws UnifyException {
        return (String)this.getUplAttribute(String.class, "binding");
    }

    @Override
    public String getColumnStyle() throws UnifyException {
        return (String)this.getUplAttribute(String.class, "columnStyle");
    }

    @Override
    public boolean getColumnSelectSummary() throws UnifyException {
        return (Boolean)this.getUplAttribute(Boolean.TYPE, "columnSelectSummary");
    }

    @Override
    public String getStyleClass() throws UnifyException {
        return (String)this.getUplAttribute(String.class, "styleClass");
    }

    @Override
    public String getStyleClassBinding() throws UnifyException {
        return (String)this.getUplAttribute(String.class, "styleClassBinding");
    }

    @Override
    public String getStyleClassValue() throws UnifyException {
        String styleClassBinding = (String)this.getUplAttribute(String.class, "styleClassBinding");
        if (styleClassBinding != null) {
            return this.getValue(String.class, styleClassBinding);
        }
        return null;
    }

    @Override
    public String getStyle() throws UnifyException {
        if (this.isHidden()) {
            return "display:none;";
        }
        return (String)this.getUplAttribute(String.class, "style");
    }

    @Override
    public String getHint() throws UnifyException {
        return this.getUplAttribute(String.class, "hint", "hintBinding");
    }

    @Override
    public boolean isHidden() throws UnifyException {
        return (Boolean)this.getUplAttribute(Boolean.TYPE, "hidden");
    }

    @Override
    public boolean isIgnoreParentState() throws UnifyException {
        return (Boolean)this.getUplAttribute(Boolean.TYPE, "ignoreParentState");
    }

    @Override
    public boolean isMasked() throws UnifyException {
        return false;
    }

    @Override
    public Container getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(Container container) {
        this.container = container;
    }

    @Override
    public void setValueStore(ValueStore valueStore) throws UnifyException {
        this.valueStore = valueStore;
    }

    @Override
    public ValueStore getValueStore() {
        return this.valueStore;
    }

    @Override
    public String getValueMarker() {
        if (this.valueStore != null) {
            return this.valueStore.getDataMarker();
        }
        return null;
    }

    @Override
    public int getValueIndex() {
        if (this.valueStore != null) {
            return this.valueStore.getDataIndex();
        }
        return -1;
    }

    @Override
    public String getContainerId() throws UnifyException {
        if (this.container != null) {
            return this.container.getId();
        }
        return null;
    }

    @Override
    public String getPanelId() throws UnifyException {
        Panel panel = this.getPanel();
        if (panel != null) {
            return panel.getId();
        }
        return null;
    }

    @Override
    public Widget getRelayWidget() throws UnifyException {
        return null;
    }

    @Override
    public boolean isRelayCommand() {
        return false;
    }

    @Override
    public boolean isConforming() {
        return this.conforming;
    }

    @Override
    public boolean isValueConforming(Container container) {
        return container == this.container && this.conforming;
    }

    @Override
    public boolean isFixedConforming() throws UnifyException {
        return (Boolean)this.getUplAttribute(Boolean.TYPE, "fixedConforming");
    }

    @Override
    public boolean isUseFacade() throws UnifyException {
        return false;
    }

    @Override
    public boolean isUseFacadeFocus() throws UnifyException {
        return this.isUseFacade();
    }

    @Override
    public boolean isBindEventsToFacade() throws UnifyException {
        return this.isUseFacade();
    }

    @Override
    public void setConforming(boolean conforming) {
        this.conforming = conforming;
    }

    @Override
    public boolean isDisabled() throws UnifyException {
        return this.disabled || this.getViewDirective().isDisabled();
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    @Override
    public boolean isContainerDisabled() throws UnifyException {
        if (this.container != null && !this.isIgnoreParentState()) {
            return this.container.isContainerDisabled() || this.isDisabled();
        }
        return this.isDisabled();
    }

    @Override
    public boolean isEditable() throws UnifyException {
        return this.editable && (Boolean)this.getUplAttribute(Boolean.TYPE, "readOnly") == false && this.getViewDirective().isEditable();
    }

    @Override
    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    @Override
    public boolean isContainerEditable() throws UnifyException {
        if (this.container != null && !this.isIgnoreParentState()) {
            return this.container.isContainerEditable() && this.isEditable();
        }
        return this.isEditable();
    }

    @Override
    public boolean isActive() throws UnifyException {
        return this.isContainerEditable() && !this.isContainerDisabled();
    }

    @Override
    public boolean isVisible() throws UnifyException {
        return this.visible && this.getViewDirective().isVisible();
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public boolean isContainerVisible() throws UnifyException {
        if (this.container != null && !this.isIgnoreParentState()) {
            return this.container.isContainerVisible() && this.isVisible();
        }
        return this.isVisible();
    }

    @Override
    public boolean isBehaviorAlways() throws UnifyException {
        return (Boolean)this.getUplAttribute(Boolean.TYPE, "behaviorAlways");
    }

    @Override
    public boolean isValidatable() throws UnifyException {
        return this.isVisible() && !this.disabled && this.editable;
    }

    @Override
    public boolean isSupportReadOnly() {
        return true;
    }

    @Override
    public boolean isSupportDisabled() {
        return true;
    }

    @Override
    public void setAlternateMode(boolean alternateMode) {
    }

    @Override
    public int getTabIndex() {
        return this.tabIndex;
    }

    @Override
    public void setTabIndex(int tabIndex) {
        this.tabIndex = tabIndex;
    }

    @Override
    public void onPageConstruct() throws UnifyException {
    }

    @Override
    public Object getValue() throws UnifyException {
        return this.getValue((String)this.getUplAttribute(String.class, "binding"));
    }

    @Override
    public <T> T getValue(Class<T> valueClass) throws UnifyException {
        return (T)this.convert(valueClass, this.getValue(), null);
    }

    @Override
    public void setValue(Object value) throws UnifyException {
        this.setValue((String)this.getUplAttribute(String.class, "binding"), value);
    }

    @Override
    public String getStringValue() throws UnifyException {
        return (String)this.convert(String.class, this.getValue(), null);
    }

    @Override
    public String getStringValue(String attribute) throws UnifyException {
        return (String)this.convert(String.class, this.getValue(attribute), null);
    }

    @Override
    public <T> T getValue(Class<T> clazz, String attribute) throws UnifyException {
        return (T)this.convert(clazz, this.getValue(attribute), null);
    }

    @Override
    public <T, U extends Collection<T>> U getValue(Class<U> clazz, Class<T> dataClass) throws UnifyException {
        return (U)this.convert(clazz, dataClass, this.getValue(), null);
    }

    @Override
    public boolean isLayoutCaption() throws UnifyException {
        return true;
    }

    @Override
    public void addPageAliases() throws UnifyException {
    }

    @Override
    public boolean isField() {
        return false;
    }

    @Override
    public Object getValue(String attribute) throws UnifyException {
        if (attribute != null) {
            if (this.valueStore != null && this.valueStore.isGettable(attribute)) {
                return this.valueStore.retrieve(attribute);
            }
            if (this.isSessionAttribute(attribute)) {
                return this.getSessionAttribute(attribute);
            }
            if (this.isApplicationAttribute(attribute)) {
                return this.getApplicationAttribute(attribute);
            }
            if (this.isRequestAttribute(attribute)) {
                return this.getRequestAttribute(attribute);
            }
        }
        return null;
    }

    @Override
    public Panel getPanel() throws UnifyException {
        for (Container container = this.container; container != null; container = container.getContainer()) {
            if (!(container instanceof Panel)) continue;
            return (Panel)container;
        }
        return null;
    }

    @Override
    public StandalonePanel getStandalonePanel() throws UnifyException {
        for (Container container = this.container; container != null; container = container.getContainer()) {
            if (!(container instanceof StandalonePanel)) continue;
            return (StandalonePanel)container;
        }
        return null;
    }

    @Override
    public void updateInternalState() throws UnifyException {
    }

    @Override
    public WriteWork getWriteWork() throws UnifyException {
        String workId = this.getWorkId();
        WriteWork work = (WriteWork)this.getRequestAttribute(workId);
        if (work == null) {
            work = new WriteWork();
            this.setRequestAttribute(workId, work);
        }
        return work;
    }

    protected void setPageAttribute(String name, Object value) throws UnifyException {
        this.getRequestContextUtil().getRequestPage().setAttribute(name, value);
    }

    protected Object clearPageAttribute(String name) throws UnifyException {
        return this.getRequestContextUtil().getRequestPage().clearAttribute(name);
    }

    protected Object getPageAttribute(String name) throws UnifyException {
        return this.getRequestContextUtil().getRequestPage().getAttribute(name);
    }

    protected Page getPage() throws UnifyException {
        return this.getRequestContextUtil().getRequestPage();
    }

    protected <T> T getPageAttribute(Class<T> clazz, String name) throws UnifyException {
        return (T)this.getRequestContextUtil().getRequestPage().getAttribute(name);
    }

    protected ViewDirective getViewDirective() throws UnifyException {
        if (this.isApplicationIgnoreViewDirective()) {
            return ViewDirective.ALLOW_VIEW_DIRECTIVE;
        }
        return this.getViewDirective((String)this.getUplAttribute(String.class, "privilege"));
    }

    protected <T> T getRequestTarget(Class<T> clazz) throws UnifyException {
        return this.getRequestContextUtil().getRequestTargetValue(clazz);
    }

    protected String getRequestCommandTag() throws UnifyException {
        return this.getRequestContextUtil().getRequestCommandTag();
    }

    protected void commandRefreshPanels(String ... panelLongName) throws UnifyException {
        this.getRequestContextUtil().setResponseRefreshPanels(panelLongName);
        this.setCommandResultMapping("resrv.refreshpanels");
    }

    protected void commandRefreshPanelsAndHidePopup(String ... panelLongName) throws UnifyException {
        this.getRequestContextUtil().setResponseRefreshPanels(panelLongName);
        this.setCommandResultMapping("resrv.refreshhidepopup");
    }

    protected void commandShowPopup(String panelLongName) throws UnifyException {
        this.getRequestContextUtil().setRequestPopupName(panelLongName);
        this.setCommandResultMapping("resrv.showpopup");
    }

    protected void commandHidePopup() throws UnifyException {
        this.setCommandResultMapping("resrv.hidepopup");
    }

    protected void commandPost(String path) throws UnifyException {
        this.setRequestAttribute("WR.commandPostPath", path);
        this.setCommandResultMapping("resrv.postresponse");
    }

    protected void refreshApplicationMenu() throws UnifyException {
        this.setSessionAttribute("UNIFYWEB.REFRESHMENU", Boolean.TRUE);
    }

    protected void setCommandResultMapping(String resultMappingName) throws UnifyException {
        this.getRequestContextUtil().setCommandResultMapping(resultMappingName);
    }

    protected void setCommandResponsePath(TargetPath targetPath) throws UnifyException {
        this.getRequestContextUtil().setCommandResponsePath(targetPath);
    }

    protected UIControllerUtil getUIControllerUtil() throws UnifyException {
        return (UIControllerUtil)this.getComponent("application-uicontrollerutil");
    }

    protected PageManager getPageManager() throws UnifyException {
        return (PageManager)this.getComponent("application-pagemanager");
    }

    protected PageRequestContextUtil getRequestContextUtil() throws UnifyException {
        return (PageRequestContextUtil)this.getComponent("application-pagerequestcontextutil");
    }

    protected void setValue(String attribute, Object value) throws UnifyException {
        if (this.valueStore != null && attribute != null) {
            this.valueStore.store(attribute, value);
        }
    }

    protected void appendUplAttribute(StringBuilder sb, String attribute) throws UnifyException {
        Object value = this.getUplAttribute(Object.class, attribute);
        if (value != null) {
            sb.append(' ').append(attribute).append(':').append(value);
        }
    }

    protected <T> T getUplAttribute(Class<T> type, String attribute, String attributeBinding) throws UnifyException {
        String listBinding;
        Object list = this.getUplAttribute(type, attribute);
        if (list == null && StringUtils.isNotBlank((String)(listBinding = (String)this.getUplAttribute(String.class, attributeBinding)))) {
            list = this.getValue(type, listBinding);
        }
        return (T)list;
    }

    private String getWorkId() throws UnifyException {
        return this.getPrefixedId("wrk_");
    }
}

