/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget;

import com.tcdng.unify.core.AbstractUnifyComponent;
import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.Configurable;
import com.tcdng.unify.core.constant.LocaleType;
import com.tcdng.unify.core.data.FactoryMap;
import com.tcdng.unify.core.data.ListData;
import com.tcdng.unify.core.data.Listable;
import com.tcdng.unify.core.format.Formatter;
import com.tcdng.unify.core.list.ListCommand;
import com.tcdng.unify.core.list.SearchProvider;
import com.tcdng.unify.core.util.DataUtils;
import com.tcdng.unify.core.util.ReflectUtils;
import com.tcdng.unify.web.ui.widget.ListControl;
import com.tcdng.unify.web.ui.widget.ListControlInfo;
import com.tcdng.unify.web.ui.widget.ListControlUtils;
import com.tcdng.unify.web.ui.widget.PageManager;
import com.tcdng.unify.web.ui.widget.Panel;
import com.tcdng.unify.web.util.HtmlUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component(value="application-listcontrolutil")
public class ListControlUtilsImpl
extends AbstractUnifyComponent
implements ListControlUtils {
    @Configurable
    private PageManager pageManager;
    private FactoryMap<String, ListInfo> listInfoMap = new FactoryMap<String, ListInfo>(){

        protected ListInfo create(String listName, Object ... params) throws Exception {
            ListCommand listCommand;
            if (ListControlUtilsImpl.this.isComponent(listName) && (listCommand = (ListCommand)ListControlUtilsImpl.this.getComponent(listName)) instanceof SearchProvider) {
                SearchProvider sp = (SearchProvider)listCommand;
                return new ListInfo(sp.getKeyProperty(), sp.getDescProperty());
            }
            return ListInfo.BLANK;
        }
    };

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    @Override
    public ListControlInfo getListControlInfo(ListControl listControl, Formatter<Object> formatter) throws UnifyException {
        List<? extends Listable> listableList = listControl.getListables();
        int len = listableList.size();
        String[] selectIds = new String[len];
        String[] keys = new String[len];
        String[] labels = new String[len];
        for (int i = 0; i < len; ++i) {
            Listable listable = listableList.get(i);
            keys[i] = listable.getListKey();
            labels[i] = formatter != null && formatter.isLabelFormat() ? HtmlUtils.getStringWithHtmlEscape((String)formatter.format((Object)listable.getListDescription())) : HtmlUtils.getStringWithHtmlEscape((String)listable.getListDescription());
            selectIds[i] = listControl.getNamingIndexedId(i);
        }
        return new ListControlInfo(selectIds, keys, labels);
    }

    @Override
    public List<? extends Listable> getListables(ListControl listControl) throws UnifyException {
        String reqId = "reqList_" + listControl.getId();
        List<Object> list = (ArrayList<ListData>)this.getRequestAttribute(reqId);
        if (list == null) {
            String listName = listControl.getList();
            list = this.getList(LocaleType.SESSION, listName, this.resolveParams(listControl));
            if (!list.isEmpty()) {
                String descProperty;
                ListInfo listInfo = (ListInfo)this.listInfoMap.get((Object)listName);
                String keyProperty = listInfo.getListKey();
                if (keyProperty == null) {
                    keyProperty = listControl.getListKey();
                }
                if ((descProperty = listInfo.getListDescription()) == null) {
                    descProperty = listControl.getListDescription();
                }
                if (keyProperty != null || descProperty != null) {
                    ArrayList<ListData> newList = new ArrayList<ListData>();
                    for (Listable listable : list) {
                        String key = listable.getListKey();
                        String description = listable.getListDescription();
                        if (keyProperty != null) {
                            key = String.valueOf(ReflectUtils.getBeanProperty((Object)listable, (String)keyProperty));
                        }
                        if (descProperty != null) {
                            description = String.valueOf(ReflectUtils.getBeanProperty((Object)listable, (String)descProperty));
                        }
                        newList.add(new ListData(key, description));
                    }
                    list = newList;
                }
            }
            this.setRequestAttribute(reqId, list);
        }
        return list;
    }

    @Override
    public Map<String, Listable> getListMap(ListControl listControl) throws UnifyException {
        String descProperty;
        String listName = listControl.getList();
        ListInfo listInfo = (ListInfo)this.listInfoMap.get((Object)listName);
        String keyProperty = listInfo.getListKey();
        if (keyProperty == null) {
            keyProperty = listControl.getListKey();
        }
        if ((descProperty = listInfo.getListDescription()) == null) {
            descProperty = listControl.getListDescription();
        }
        if (keyProperty != null || descProperty != null) {
            List list = this.getList(LocaleType.SESSION, listName, this.resolveParams(listControl));
            if (!list.isEmpty()) {
                HashMap<String, Listable> map = new HashMap<String, Listable>();
                for (Listable listable : list) {
                    String key = listable.getListKey();
                    String description = listable.getListDescription();
                    if (keyProperty != null) {
                        key = String.valueOf(ReflectUtils.getBeanProperty((Object)listable, (String)keyProperty));
                    }
                    if (descProperty != null) {
                        description = String.valueOf(ReflectUtils.getBeanProperty((Object)listable, (String)descProperty));
                    }
                    map.put(key, (Listable)new ListData(key, description));
                }
                return map;
            }
            return Collections.emptyMap();
        }
        return this.getListMap(LocaleType.SESSION, listControl.getList(), this.resolveParams(listControl));
    }

    protected void onInitialize() throws UnifyException {
    }

    protected void onTerminate() throws UnifyException {
    }

    protected Object[] resolveParams(ListControl listControl) throws UnifyException {
        Object[] listParams = listControl.getListParams();
        if (listParams == null || listParams.length == 0) {
            return DataUtils.ZEROLEN_OBJECT_ARRAY;
        }
        Object[] params = null;
        switch (listControl.getListParamType()) {
            case IMMEDIATE: {
                params = listParams;
                break;
            }
            case PANEL: {
                params = new Object[listParams.length];
                Panel panel = listControl.getPanel();
                for (int i = 0; i < params.length; ++i) {
                    params[i] = listControl.getValue((String)listParams[i]);
                    if (params[i] != null) continue;
                    params[i] = panel.getValue(Object.class, (String)listParams[i]);
                }
                break;
            }
            default: {
                params = new Object[listParams.length];
                for (int i = 0; i < params.length; ++i) {
                    params[i] = listControl.getValue((String)listParams[i]);
                }
            }
        }
        return params;
    }

    private static class ListInfo {
        public static final ListInfo BLANK = new ListInfo();
        private String listKey;
        private String listDescription;

        public ListInfo() {
        }

        public ListInfo(String listKey, String listDescription) {
            this.listKey = listKey;
            this.listDescription = listDescription;
        }

        public String getListKey() {
            return this.listKey;
        }

        public String getListDescription() {
            return this.listDescription;
        }
    }
}

