/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget;

import com.tcdng.unify.core.AbstractUnifyComponent;
import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.Configurable;
import com.tcdng.unify.core.data.FactoryMap;
import com.tcdng.unify.core.data.LocaleFactoryMaps;
import com.tcdng.unify.core.system.SequenceNumberService;
import com.tcdng.unify.core.upl.UplCompiler;
import com.tcdng.unify.core.upl.UplComponent;
import com.tcdng.unify.core.upl.UplDocumentAttributes;
import com.tcdng.unify.core.upl.UplElementAttributes;
import com.tcdng.unify.core.upl.UplElementReferences;
import com.tcdng.unify.core.util.DataUtils;
import com.tcdng.unify.core.util.StringUtils;
import com.tcdng.unify.web.ui.widget.Container;
import com.tcdng.unify.web.ui.widget.Control;
import com.tcdng.unify.web.ui.widget.EventHandler;
import com.tcdng.unify.web.ui.widget.MultiControl;
import com.tcdng.unify.web.ui.widget.Page;
import com.tcdng.unify.web.ui.widget.PageAction;
import com.tcdng.unify.web.ui.widget.PageManager;
import com.tcdng.unify.web.ui.widget.PageValidation;
import com.tcdng.unify.web.ui.widget.PropertyInfo;
import com.tcdng.unify.web.ui.widget.Section;
import com.tcdng.unify.web.ui.widget.StandalonePanelInfo;
import com.tcdng.unify.web.ui.widget.Widget;
import com.tcdng.unify.web.ui.widget.WidgetNameInfo;
import com.tcdng.unify.web.ui.widget.WidgetRepository;
import com.tcdng.unify.web.ui.widget.panel.StandalonePanel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.zip.CRC32;

@Component(value="application-pagemanager")
public class PageManagerImpl
extends AbstractUnifyComponent
implements PageManager {
    private static final String PAGENAME_PREFIX = "p";
    private static final String REMOTE_WEBVIEWER_PAGENAME_PREFIX = "rp";
    @Configurable
    private UplCompiler uplCompiler;
    @Configurable
    private SequenceNumberService sequenceNumberService;
    private PageNameMap pageNameMap;
    private LocaleFactoryMaps<String, StandalonePanelInfo> standalonePanelInfoByNameMap;
    private FactoryMap<String, Map<String, PropertyInfo>> pageNamePropertyBindings;
    private Map<String, List<String>> expandedReferences = new HashMap<String, List<String>>();
    private Map<String, List<String>> valueReferences = new HashMap<String, List<String>>();
    private List<String> documentStyleSheets = Collections.emptyList();
    private List<String> documentScripts = Collections.emptyList();
    private String pageNamePrefix = "p";

    public PageManagerImpl() {
        this.pageNameMap = new PageNameMap();
        this.standalonePanelInfoByNameMap = new LocaleFactoryMaps<String, StandalonePanelInfo>(){

            protected StandalonePanelInfo createObject(Locale locale, String name, Object ... params) throws Exception {
                UplDocumentAttributes uplDocumentAttributes = null;
                uplDocumentAttributes = params.length > 0 ? (UplDocumentAttributes)params[0] : PageManagerImpl.this.uplCompiler.compileComponentDocuments(locale, name);
                PageManagerImpl.this.expandReferences(uplDocumentAttributes, (UplElementAttributes)uplDocumentAttributes);
                HashSet<String> nonreusableComponentLongNames = new HashSet<String>();
                LinkedHashMap<String, PageValidation> reusablePageValidations = new LinkedHashMap<String, PageValidation>();
                LinkedHashMap<String, PageAction> reusablePageActions = new LinkedHashMap<String, PageAction>();
                for (String string : uplDocumentAttributes.getLongNames()) {
                    UplElementAttributes uea = uplDocumentAttributes.getChildElementByLongName(string);
                    Class type = PageManagerImpl.this.getComponentType(uea.getComponentName());
                    boolean isPageAction = false;
                    isPageAction = PageAction.class.isAssignableFrom(type);
                    if (isPageAction || PageValidation.class.isAssignableFrom(type)) {
                        UplComponent uplComponent = PageManagerImpl.this.getUplComponent(locale, uea.getKey());
                        String pageName = PageManagerImpl.this.getPageName(string);
                        if (isPageAction) {
                            UplElementReferences uer;
                            PageAction pageAction = (PageAction)uplComponent;
                            pageAction.setId(pageName);
                            PageManagerImpl.this.expandReferences(uplDocumentAttributes, uea);
                            if (pageAction.isUplAttribute("valueComponentList") && !PageManagerImpl.this.valueReferences.containsKey(pageName) && (uer = (UplElementReferences)uea.getAttributeValue(UplElementReferences.class, "valueComponentList")) != null) {
                                PageManagerImpl.this.valueReferences.put(pageName, Collections.unmodifiableList(StringUtils.removeDuplicates(PageManagerImpl.this.getPageNames(uer.getLongNames()))));
                            }
                            reusablePageActions.put(string, pageAction);
                            continue;
                        }
                        PageValidation pageValidation = (PageValidation)uplComponent;
                        pageValidation.setId(pageName);
                        PageManagerImpl.this.expandReferences(uplDocumentAttributes, uea);
                        reusablePageValidations.put(string, pageValidation);
                        continue;
                    }
                    if (uea.isAttribute("dataComponents")) {
                        PageManagerImpl.this.expandReferences(uplDocumentAttributes, uea);
                    }
                    nonreusableComponentLongNames.add(string);
                }
                for (Map.Entry entry : reusablePageActions.entrySet()) {
                    UplElementReferences uer;
                    PageAction pageAction = (PageAction)entry.getValue();
                    if (!pageAction.isUplAttribute("validations") || (uer = (UplElementReferences)pageAction.getUplAttribute(UplElementReferences.class, "validations")) == null) continue;
                    for (String validationLongName : uer.getLongNames()) {
                        if (reusablePageValidations.get(validationLongName) != null) continue;
                        throw new UnifyException("UWI_000A", new Object[]{entry.getKey(), validationLongName});
                    }
                }
                HashMap<String, WidgetNameInfo> widgetNameInfos = new HashMap<String, WidgetNameInfo>();
                for (String longName : nonreusableComponentLongNames) {
                    UplElementAttributes uea = uplDocumentAttributes.getChildElementByLongName(longName);
                    widgetNameInfos.put(longName, PageManagerImpl.this.createWidgetInfo(uea, nonreusableComponentLongNames));
                    for (String attribute : uea.getAttributeNames()) {
                        EventHandler[] eventHandlers;
                        Object value = uea.getAttributeValue(Object.class, attribute);
                        if (!(value instanceof EventHandler[])) continue;
                        for (EventHandler eventHandler : eventHandlers = (EventHandler[])value) {
                            UplElementReferences uer = (UplElementReferences)eventHandler.getUplAttribute(UplElementReferences.class, "action");
                            if (uer == null) continue;
                            ArrayList<PageAction> pageActionList = new ArrayList<PageAction>();
                            for (String actionLongName : uer.getLongNames()) {
                                PageAction pageAction = (PageAction)reusablePageActions.get(actionLongName);
                                if (pageAction == null) {
                                    throw new UnifyException("UWI_0008", new Object[]{longName, actionLongName});
                                }
                                pageActionList.add(pageAction);
                            }
                            eventHandler.setPageAction((PageAction[])DataUtils.toArray(PageAction.class, pageActionList));
                        }
                    }
                }
                widgetNameInfos.put(uplDocumentAttributes.getLongName(), PageManagerImpl.this.createWidgetInfo((UplElementAttributes)uplDocumentAttributes, nonreusableComponentLongNames));
                StandalonePanelInfo standalonePanelInfo = new StandalonePanelInfo(Collections.unmodifiableMap(widgetNameInfos), Collections.unmodifiableMap(reusablePageValidations), Collections.unmodifiableMap(reusablePageActions));
                return standalonePanelInfo;
            }
        };
        this.pageNamePropertyBindings = new FactoryMap<String, Map<String, PropertyInfo>>(){

            protected Map<String, PropertyInfo> create(String name, Object ... params) throws Exception {
                HashMap<String, PropertyInfo> propertyBindingMap = new HashMap<String, PropertyInfo>();
                StandalonePanel sp = PageManagerImpl.this.createStandalonePanel(Locale.getDefault(), name);
                for (String longName : sp.getWidgetLongNames()) {
                    String containerProperty;
                    Widget widget = sp.getWidgetByLongName(longName);
                    String property = widget.getBinding();
                    if (property == null) continue;
                    String id = widget.getId();
                    boolean masked = widget.isMasked();
                    StringBuilder longSb = new StringBuilder();
                    longSb.append(property);
                    Container container = null;
                    while ((container = widget.getContainer()) != null && !StringUtils.isBlank((String)(containerProperty = container.getBinding()))) {
                        longSb.insert(0, '.');
                        longSb.insert(0, containerProperty);
                        widget = container;
                    }
                    String shortProperty = property;
                    int index = property.lastIndexOf(46);
                    if (index >= 0) {
                        shortProperty = property.substring(index + 1);
                    }
                    propertyBindingMap.put(id, new PropertyInfo(property, shortProperty, longSb.toString(), masked));
                }
                return propertyBindingMap;
            }
        };
    }

    public void setUplCompiler(UplCompiler uplCompiler) {
        this.uplCompiler = uplCompiler;
    }

    public void setSequenceNumberService(SequenceNumberService sequenceNumberService) {
        this.sequenceNumberService = sequenceNumberService;
    }

    @Override
    public List<String> getDocumentStyleSheets() throws UnifyException {
        return this.documentStyleSheets;
    }

    @Override
    public List<String> getDocumentsScripts() throws UnifyException {
        return this.documentScripts;
    }

    @Override
    public Page createPage(Locale locale, String name) throws UnifyException {
        return (Page)this.createStandalonePanel(locale, name);
    }

    @Override
    public boolean invalidateStaleDocument(String name) throws UnifyException {
        if (this.uplCompiler.invalidateStaleDocument(name)) {
            Set infoList = this.standalonePanelInfoByNameMap.removeSubkeys((Object)name);
            for (StandalonePanelInfo standalonePanelInfo : infoList) {
                standalonePanelInfo.invalidate();
            }
            this.pageNamePropertyBindings.remove((Object)name);
            return true;
        }
        return false;
    }

    @Override
    public StandalonePanel createStandalonePanel(Locale locale, String name) throws UnifyException {
        UplDocumentAttributes uplDocumentAttributes = this.uplCompiler.compileComponentDocuments(locale, name);
        String spLongName = uplDocumentAttributes.getLongName();
        String id = this.getPageName(spLongName);
        StandalonePanelContext ctx = new StandalonePanelContext((StandalonePanelInfo)this.standalonePanelInfoByNameMap.get((Object)locale, (Object)name, new Object[]{uplDocumentAttributes}));
        StandalonePanelInfo standalonePanelInfo = ctx.getStandalonePanelInfo();
        StandalonePanel standalonePanel = (StandalonePanel)this.getUplComponent(locale, uplDocumentAttributes.getKey());
        standalonePanel.setId(id);
        standalonePanel.setStandalonePanelInfo(standalonePanelInfo);
        for (String longName : standalonePanelInfo.getWidgetLongNames()) {
            if (longName.equals(spLongName)) continue;
            UplElementAttributes uea = uplDocumentAttributes.getChildElementByLongName(longName);
            Widget widget = (Widget)this.getUplComponent(locale, uea.getKey());
            widget.setId(this.getPageName(longName));
            ctx.addWidget(widget);
        }
        for (String longName : ctx.getWidgetLongNames()) {
            this.wireWidget(ctx, ctx.getWidget(longName));
        }
        this.wireWidget(ctx, standalonePanel);
        for (String longName : ctx.getWidgetLongNames()) {
            Widget widget = ctx.getWidget(longName);
            if (widget.getContainer() != null) continue;
            Container parentContainer = (Container)ctx.getWidget(widget.getParentLongName());
            if (parentContainer != null) {
                widget.setContainer(parentContainer);
            } else {
                widget.setContainer(standalonePanel);
            }
            ctx.addRepositoryWidget(widget);
        }
        for (Widget widget : ctx.getWidgets()) {
            widget.onPageConstruct();
        }
        standalonePanel.onPageConstruct();
        return standalonePanel;
    }

    @Override
    public Map<String, PropertyInfo> getStandalonePanelPropertyBindings(String name) throws UnifyException {
        this.standalonePanelInfoByNameMap.get((Object)Locale.getDefault(), (Object)name, new Object[0]);
        return (Map)this.pageNamePropertyBindings.get((Object)name);
    }

    @Override
    public String getPageName(String longName) throws UnifyException {
        return (String)this.pageNameMap.get(longName);
    }

    @Override
    public List<String> getPageNames(Collection<String> longNames) throws UnifyException {
        if (DataUtils.isNotBlank(longNames)) {
            ArrayList<String> resultList = new ArrayList<String>();
            for (String longName : longNames) {
                resultList.add((String)this.pageNameMap.get(longName));
            }
            return resultList;
        }
        return Collections.emptyList();
    }

    @Override
    public String getLongName(String pageName) throws UnifyException {
        return this.pageNameMap.getLongName(pageName);
    }

    @Override
    public List<String> getLongNames(Collection<String> pageNames) throws UnifyException {
        ArrayList<String> longNames = new ArrayList<String>();
        for (String pageName : pageNames) {
            longNames.add(this.pageNameMap.getLongName(pageName));
        }
        return longNames;
    }

    @Override
    public List<String> getExpandedReferences(String pageName) throws UnifyException {
        List<String> resultList = this.expandedReferences.get(pageName);
        if (resultList != null) {
            return resultList;
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getExpandedReferencesForLongNames(Collection<String> longNames) throws UnifyException {
        if (DataUtils.isNotBlank(longNames)) {
            ArrayList<String> resultList = new ArrayList<String>();
            for (String longName : longNames) {
                List<String> list = this.expandedReferences.get(this.pageNameMap.get(longName));
                if (!DataUtils.isNotBlank(list)) continue;
                resultList.addAll(list);
            }
            return resultList;
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getExpandedReferencesForPageNames(Collection<String> pageNames) throws UnifyException {
        if (DataUtils.isNotBlank(pageNames)) {
            ArrayList<String> resultList = new ArrayList<String>();
            for (String pageName : pageNames) {
                List<String> list = this.expandedReferences.get(pageName);
                if (!DataUtils.isNotBlank(list)) continue;
                resultList.addAll(list);
            }
            return resultList;
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getValueReferences(String pageName) throws UnifyException {
        return this.valueReferences.get(pageName);
    }

    protected void onInitialize() throws UnifyException {
        List scripts;
        List styleSheets;
        if (((Boolean)this.getContainerSetting(Boolean.TYPE, "application.web.remote.viewing", false)).booleanValue()) {
            this.pageNamePrefix = REMOTE_WEBVIEWER_PAGENAME_PREFIX;
        }
        if ((styleSheets = (List)DataUtils.convert(ArrayList.class, String.class, (Object)this.getContainerSetting(Object.class, "application.web.stylesheet"))) != null) {
            ArrayList<String> actStyleSheets = new ArrayList<String>();
            for (String styleSheet : styleSheets) {
                actStyleSheets.add(styleSheet);
            }
            this.documentStyleSheets = Collections.unmodifiableList(actStyleSheets);
        }
        if ((scripts = (List)DataUtils.convert(ArrayList.class, String.class, (Object)this.getContainerSetting(Object.class, "application.web.script"))) != null) {
            this.documentScripts = Collections.unmodifiableList(scripts);
        }
    }

    protected void onTerminate() throws UnifyException {
    }

    private void wireWidget(StandalonePanelContext ctx, Widget widget) throws UnifyException {
        if (widget instanceof Container) {
            this.setContainerWidgetRepository(ctx, (Container)widget);
        } else if (widget instanceof MultiControl) {
            MultiControl multiControl = (MultiControl)widget;
            for (String longName : multiControl.getShallowReferencedLongNames("components")) {
                Widget cWidget = ctx.getWidget(longName);
                if (cWidget instanceof Container) {
                    this.setContainerWidgetRepository(ctx, (Container)cWidget);
                }
                multiControl.addChildWidget((Control)cWidget);
            }
        }
    }

    private void setContainerWidgetRepository(StandalonePanelContext ctx, Container container) throws UnifyException {
        if (!container.hasWidgetRepository()) {
            container.setWidgetRepository(ctx.getWidgetRepository());
            for (String longName : container.getShallowReferencedLongNames("components")) {
                Widget refWidget = ctx.getWidget(longName);
                refWidget.setContainer(container);
                ctx.addRepositoryWidget(refWidget);
            }
        }
    }

    private WidgetNameInfo createWidgetInfo(UplElementAttributes uea, Set<String> widgetLongNames) throws UnifyException {
        HashSet<String> shallowNames = new HashSet<String>();
        for (String shallowName : uea.getShallowReferencedLongNames()) {
            if (!widgetLongNames.contains(shallowName)) continue;
            shallowNames.add(shallowName);
        }
        if (uea.isAttribute("section")) {
            Section[] sections = (Section[])uea.getAttributeValue(Section[].class, "section");
            for (Section section : sections) {
                UplElementReferences uplRef = (UplElementReferences)section.getUplAttribute(UplElementReferences.class, "components");
                for (String shallowName : uplRef.getLongNames()) {
                    if (!widgetLongNames.contains(shallowName)) continue;
                    shallowNames.add(shallowName);
                }
            }
        }
        HashSet<String> deepNames = new HashSet<String>();
        for (String deepName : uea.getDeepReferencedLongNames()) {
            if (!widgetLongNames.contains(deepName)) continue;
            deepNames.add(deepName);
        }
        return new WidgetNameInfo(Collections.unmodifiableList(new ArrayList(shallowNames)), Collections.unmodifiableSet(deepNames));
    }

    private void expandReferences(UplDocumentAttributes uplDocumentAttributes, UplElementAttributes uea) throws UnifyException {
        String pageName = this.getPageName(uea.getLongName());
        if (!this.expandedReferences.containsKey(pageName)) {
            List<String> expandedList = new ArrayList<String>();
            this.subExpandReferences(expandedList, uplDocumentAttributes, uea);
            expandedList = StringUtils.removeDuplicates(expandedList);
            expandedList.remove(uea.getLongName());
            this.expandedReferences.put(pageName, Collections.unmodifiableList(this.getPageNames(expandedList)));
        }
    }

    private void subExpandReferences(List<String> expandedList, UplDocumentAttributes uplDocumentAttributes, UplElementAttributes uea) throws UnifyException {
        Class type;
        Section[] sections;
        for (Section[] longName : uea.getShallowReferencedLongNames("components")) {
            this.subExpandReferences(expandedList, uplDocumentAttributes, uplDocumentAttributes.getChildElementByLongName((String)longName));
        }
        for (Section[] longName : uea.getShallowReferencedLongNames("dataComponents")) {
            this.subExpandReferences(expandedList, uplDocumentAttributes, uplDocumentAttributes.getChildElementByLongName((String)longName));
        }
        if (uea.isAttribute("section") && (sections = (Section[])uea.getAttributeValue(Section[].class, "section")) != null) {
            for (Section section : sections) {
                UplElementReferences uplRef = (UplElementReferences)section.getUplAttribute(UplElementReferences.class, "components");
                for (String longName : uplRef.getLongNames()) {
                    this.subExpandReferences(expandedList, uplDocumentAttributes, uplDocumentAttributes.getChildElementByLongName(longName));
                }
            }
        }
        Set childElements = uea.getChildElements();
        for (UplElementAttributes ueaInner : childElements) {
            this.subExpandReferences(expandedList, uplDocumentAttributes, ueaInner);
        }
        if (childElements.isEmpty() && !expandedList.contains(uea.getLongName()) && !PageAction.class.isAssignableFrom(type = this.getComponentType(uea.getComponentName())) && !PageValidation.class.isAssignableFrom(type)) {
            expandedList.add(uea.getLongName());
        }
    }

    private class PageNameMap
    extends FactoryMap<String, String> {
        private Map<String, String> longNameByPageNameMap;
        private CRC32 crc = new CRC32();

        public PageNameMap() {
            this.longNameByPageNameMap = new HashMap<String, String>();
        }

        public String getLongName(String pageName) throws UnifyException {
            String longName = this.longNameByPageNameMap.get(pageName);
            if (longName == null) {
                throw new UnifyException("UC_0052", new Object[]{pageName});
            }
            return longName;
        }

        public void clear() {
            super.clear();
            this.longNameByPageNameMap.clear();
        }

        protected String create(String longName, Object ... params) throws Exception {
            this.crc.update(longName.getBytes());
            String pageName = PageManagerImpl.this.pageNamePrefix + this.crc.getValue();
            this.longNameByPageNameMap.put(pageName, longName);
            return pageName;
        }
    }

    private class StandalonePanelContext {
        private StandalonePanelInfo standalonePanelInfo;
        private Map<String, Widget> componentsByLongNameMap;
        private WidgetRepository widgetRepository;

        public StandalonePanelContext(StandalonePanelInfo standalonePanelInfo) {
            this.standalonePanelInfo = standalonePanelInfo;
            this.componentsByLongNameMap = new HashMap<String, Widget>();
            this.widgetRepository = new WidgetRepository(standalonePanelInfo.getWidgetInfos());
        }

        public void addWidget(Widget widget) throws UnifyException {
            this.componentsByLongNameMap.put(widget.getLongName(), widget);
        }

        public Widget getWidget(String longName) {
            return this.componentsByLongNameMap.get(longName);
        }

        public void addRepositoryWidget(Widget widget) throws UnifyException {
            this.widgetRepository.putWidget(widget);
        }

        public Collection<String> getWidgetLongNames() {
            return this.componentsByLongNameMap.keySet();
        }

        public Collection<Widget> getWidgets() {
            return this.componentsByLongNameMap.values();
        }

        public StandalonePanelInfo getStandalonePanelInfo() {
            return this.standalonePanelInfo;
        }

        public WidgetRepository getWidgetRepository() {
            return this.widgetRepository;
        }
    }
}

