/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget;

import com.tcdng.unify.core.AbstractUnifyComponent;
import com.tcdng.unify.core.RequestContext;
import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.Configurable;
import com.tcdng.unify.core.annotation.Singleton;
import com.tcdng.unify.core.constant.MimeType;
import com.tcdng.unify.core.data.LargeStringWriter;
import com.tcdng.unify.core.data.Listable;
import com.tcdng.unify.core.format.DateTimeFormat;
import com.tcdng.unify.core.format.Pattern;
import com.tcdng.unify.core.upl.UplComponent;
import com.tcdng.unify.core.upl.UplComponentWriter;
import com.tcdng.unify.core.util.QueryUtils;
import com.tcdng.unify.core.util.StringUtils;
import com.tcdng.unify.core.util.json.JsonUtils;
import com.tcdng.unify.core.util.json.JsonWriter;
import com.tcdng.unify.web.ThemeManager;
import com.tcdng.unify.web.data.WebStringWriter;
import com.tcdng.unify.web.ui.PageRequestContextUtil;
import com.tcdng.unify.web.ui.util.UrlUtils;
import com.tcdng.unify.web.ui.widget.Behavior;
import com.tcdng.unify.web.ui.widget.Container;
import com.tcdng.unify.web.ui.widget.Document;
import com.tcdng.unify.web.ui.widget.DocumentLayout;
import com.tcdng.unify.web.ui.widget.Layout;
import com.tcdng.unify.web.ui.widget.PageManager;
import com.tcdng.unify.web.ui.widget.Panel;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.Widget;
import com.tcdng.unify.web.ui.widget.writer.BehaviorWriter;
import com.tcdng.unify.web.ui.widget.writer.DocumentLayoutWriter;
import com.tcdng.unify.web.ui.widget.writer.LayoutWriter;
import com.tcdng.unify.web.ui.widget.writer.PanelWriter;
import com.tcdng.unify.web.ui.widget.writer.WidgetWriter;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Singleton(value=false)
@Component(value="application-responsewriter")
public class ResponseWriterImpl
extends AbstractUnifyComponent
implements ResponseWriter {
    @Configurable
    private ThemeManager themeManager;
    @Configurable
    private PageRequestContextUtil pageRequestContextUtil;
    @Configurable(value="8192")
    private int initialBufferCapacity;
    private WebStringWriter buf;
    private List<WebStringWriter> secordaryList = new ArrayList<WebStringWriter>();
    private Map<Class<? extends UplComponent>, UplComponentWriter> writers;
    private boolean tableMode;
    private boolean openFunction;
    private boolean paramAppendSym;

    public void setThemeManager(ThemeManager themeManager) {
        this.themeManager = themeManager;
    }

    public void setPageRequestContextUtil(PageRequestContextUtil pageRequestContextUtil) {
        this.pageRequestContextUtil = pageRequestContextUtil;
    }

    public void setInitialBufferCapacity(int initialBufferCapacity) {
        this.initialBufferCapacity = initialBufferCapacity;
    }

    @Override
    public ResponseWriter writeResolvedApplicationMessage(String message, Object ... params) throws UnifyException {
        String msg = super.resolveApplicationMessage(message, params);
        this.writeWithHtmlEscape(msg);
        return this;
    }

    @Override
    public ResponseWriter writeResolvedSessionMessage(String message, Object ... params) throws UnifyException {
        String msg = super.resolveSessionMessage(message, params);
        this.writeWithHtmlEscape(msg);
        return this;
    }

    @Override
    public ResponseWriter writeStructureAndContent(Widget component) throws UnifyException {
        ((WidgetWriter)this.getWriter(component)).writeStructureAndContent(this, component);
        return this;
    }

    @Override
    public ResponseWriter writeStructureAndContent(Widget component, String id) throws UnifyException {
        ((WidgetWriter)this.getWriter(component)).writeStructureAndContent(this, component, id);
        return this;
    }

    @Override
    public ResponseWriter writeStructureAndContent(DocumentLayout documentLayout, Document document) throws UnifyException {
        ((DocumentLayoutWriter)this.getWriter(documentLayout)).writeStructureAndContent(this, documentLayout, document);
        return this;
    }

    @Override
    public ResponseWriter writeStructureAndContent(Layout layout, Container container) throws UnifyException {
        ((LayoutWriter)this.getWriter(layout)).writeStructureAndContent(this, layout, container);
        return this;
    }

    @Override
    public ResponseWriter writeInnerStructureAndContent(Panel panel) throws UnifyException {
        ((PanelWriter)this.getWriter(panel)).writeInnerStructureAndContent(this, panel);
        return this;
    }

    @Override
    public ResponseWriter writeBehavior(DocumentLayout documentLayout, Document document) throws UnifyException {
        ((DocumentLayoutWriter)this.getWriter(documentLayout)).writeBehaviour(this, documentLayout, document);
        return this;
    }

    @Override
    public ResponseWriter writeBehavior(Widget component) throws UnifyException {
        ((WidgetWriter)this.getWriter(component)).writeBehavior(this, component);
        return this;
    }

    @Override
    public ResponseWriter writeBehavior(Widget component, String id) throws UnifyException {
        ((WidgetWriter)this.getWriter(component)).writeBehavior(this, component, id);
        return this;
    }

    @Override
    public ResponseWriter writeBehavior(Behavior behavior, String id, String cmdTag) throws UnifyException {
        ((BehaviorWriter)this.getWriter(behavior)).writeBehavior(this, behavior, id, cmdTag);
        return this;
    }

    @Override
    public ResponseWriter write(Object object) {
        this.buf.append(object);
        return this;
    }

    @Override
    public ResponseWriter writeNotNull(Object object) {
        if (object != null) {
            this.buf.append(object);
        }
        return this;
    }

    @Override
    public ResponseWriter writeHtmlFixedSpace() {
        this.buf.append("&nbsp;");
        return this;
    }

    @Override
    public ResponseWriter writeWithHtmlEscape(String string) {
        this.buf.appendHtmlEscaped(string);
        return this;
    }

    @Override
    public ResponseWriter writeJsonArray(String ... stringArr) throws UnifyException {
        return this.writeJsonArray((Object[])stringArr, true);
    }

    @Override
    public ResponseWriter writeJsonArray(Integer ... intArr) throws UnifyException {
        return this.writeJsonArray((Object[])intArr, false);
    }

    @Override
    public ResponseWriter writeJsonArray(Long ... longArr) throws UnifyException {
        return this.writeJsonArray((Object[])longArr, false);
    }

    @Override
    public ResponseWriter writeJsonArray(BigDecimal ... bigArr) throws UnifyException {
        return this.writeJsonArray((Object[])bigArr, false);
    }

    @Override
    public ResponseWriter writeJsonArray(Double ... doubleArr) throws UnifyException {
        return this.writeJsonArray((Object[])doubleArr, false);
    }

    @Override
    public ResponseWriter writeJsonArray(Boolean ... boolArr) throws UnifyException {
        return this.writeJsonArray((Object[])boolArr, false);
    }

    @Override
    public ResponseWriter writeJsonArray(Collection<?> col) throws UnifyException {
        this.buf.append('[');
        if (col != null) {
            boolean appendSym = false;
            for (Object val : col) {
                if (appendSym) {
                    this.buf.append(',');
                } else {
                    appendSym = true;
                }
                if (val == null) {
                    this.buf.append(val);
                    continue;
                }
                if (val instanceof Number || val instanceof Boolean) {
                    this.buf.append(val);
                    continue;
                }
                this.writeJsonQuote(String.valueOf(val));
            }
        }
        this.buf.append(']');
        return this;
    }

    @Override
    public ResponseWriter writeParam(String paramName, Pattern[] pa) throws UnifyException {
        this.preParamWrite();
        this.buf.append('\"').append(paramName).append("\":");
        this.writeJsonPatternObject(pa);
        return this;
    }

    @Override
    public ResponseWriter writeJsonPatternObject(Pattern[] pa) throws UnifyException {
        this.buf.append("[");
        boolean appendSym = false;
        for (Pattern p : pa) {
            if (appendSym) {
                this.buf.append(',');
            } else {
                appendSym = true;
            }
            this.buf.append("{\"flag\":").append(p.isFiller()).append(",\"length\":").append((Object)p.getPattern().length()).append(",\"target\":");
            if (p.isFiller()) {
                this.writeJsonQuote(p.getPattern());
            } else {
                this.buf.append('\"').append(p.getTarget()).append('\"');
            }
            this.buf.append("}");
        }
        this.buf.append("]");
        return this;
    }

    @Override
    public ResponseWriter writeParam(String paramName, DateTimeFormat[] dateTimeFormat) throws UnifyException {
        this.preParamWrite();
        this.buf.append('\"').append(paramName).append("\":");
        this.writeJsonDateTimeFormatObject(dateTimeFormat);
        return this;
    }

    @Override
    public ResponseWriter writeJsonDateTimeFormatObject(DateTimeFormat[] dateTimeFormat) throws UnifyException {
        this.buf.append("[");
        boolean appendSym = false;
        for (DateTimeFormat dtf : dateTimeFormat) {
            if (appendSym) {
                this.buf.append(',');
            } else {
                appendSym = true;
            }
            if (dtf == null) {
                this.buf.append("null");
                continue;
            }
            this.buf.append("{\"flag\":");
            List listableList = dtf.getList();
            if (listableList != null) {
                this.buf.append(true).append(",\"min\":").append((Object)0).append(",\"max\":").append((Object)(listableList.size() - 1)).append(",\"list\":[");
                boolean appendSym1 = false;
                for (Listable listable : listableList) {
                    if (appendSym1) {
                        this.buf.append(',');
                    } else {
                        appendSym1 = true;
                    }
                    this.writeJsonQuote(listable.getListKey());
                }
                this.buf.append(']');
            } else {
                int[] range = dtf.getRange();
                this.buf.append(false).append(",\"min\":").append((Object)range[0]).append(",\"max\":").append((Object)range[1]);
            }
            this.buf.append("}");
        }
        this.buf.append("]");
        return this;
    }

    @Override
    public ResponseWriter writeJsonQuote(String string) throws UnifyException {
        this.buf.appendJsonQuoted(string);
        return this;
    }

    @Override
    public ResponseWriter writeJsonQuote(WebStringWriter lsw) throws UnifyException {
        this.buf.appendJsonQuoted(lsw);
        return this;
    }

    @Override
    public ResponseWriter writeJsonPageNameAliasesArray() throws UnifyException {
        this.buf.append('[');
        Map<String, Set<String>> childAliasesMap = this.getRequestContextUtil().getRequestPageNameAliases();
        if (childAliasesMap != null) {
            boolean appendSym = false;
            for (Map.Entry<String, Set<String>> entry : childAliasesMap.entrySet()) {
                if (appendSym) {
                    this.buf.append(',');
                } else {
                    appendSym = true;
                }
                this.buf.append("{\"pn\":\"").append(entry.getKey()).append("\",");
                this.buf.append("\"aliases\":");
                this.writeJsonArray((Collection)entry.getValue());
                this.buf.append('}');
            }
        }
        this.buf.append(']');
        return this;
    }

    @Override
    public ResponseWriter writeJsonPathVariable(String name, String path) throws UnifyException {
        this.useSecondary(128);
        this.writeContextURL(path, new String[0]);
        WebStringWriter pathLsw = this.discardSecondary();
        this.buf.append("\"").append(name).append("\":");
        this.buf.appendJsonQuoted(pathLsw);
        return this;
    }

    @Override
    public ResponseWriter writeJsonPanel(Panel panel, boolean innerOnly) throws UnifyException {
        this.useSecondary();
        if (innerOnly) {
            this.writeInnerStructureAndContent(panel);
        } else {
            this.writeStructureAndContent(panel);
        }
        WebStringWriter htmlLsw = this.discardSecondary();
        this.useSecondary();
        this.writeBehavior(panel);
        WebStringWriter scriptLsw = this.discardSecondary();
        this.buf.append("{\"target\":\"").append(panel.getId()).append('\"');
        this.buf.append(",\"html\":");
        this.buf.appendJsonQuoted(htmlLsw);
        this.buf.append(",\"script\":");
        this.buf.appendJsonQuoted(scriptLsw);
        this.buf.append('}');
        return this;
    }

    @Override
    public ResponseWriter writeJsonSection(Widget widget, String sectionPageName) throws UnifyException {
        WidgetWriter widgetWriter = (WidgetWriter)this.getWriter(widget);
        this.useSecondary();
        widgetWriter.writeSectionStructureAndContent(this, widget, sectionPageName);
        WebStringWriter htmlLsw = this.discardSecondary();
        this.useSecondary();
        widgetWriter.writeSectionBehavior(this, widget, sectionPageName);
        WebStringWriter scriptLsw = this.discardSecondary();
        this.buf.append("{\"target\":\"").append(sectionPageName).append('\"');
        this.buf.append(",\"html\":");
        this.buf.appendJsonQuoted(htmlLsw);
        this.buf.append(",\"script\":");
        this.buf.appendJsonQuoted(scriptLsw);
        this.buf.append('}');
        return this;
    }

    @Override
    public ResponseWriter writeContextURL(String path, String ... pathElement) throws UnifyException {
        RequestContext requestContext = this.getRequestContext();
        if (this.pageRequestContextUtil.isRemoteViewer()) {
            this.buf.append(this.getSessionContext().getUriBase());
        }
        this.buf.append(requestContext.getContextPath());
        if (requestContext.isWithTenantPath()) {
            this.buf.append(requestContext.getTenantPath());
        }
        this.buf.append(path);
        for (String element : pathElement) {
            this.buf.append(element);
        }
        return this;
    }

    @Override
    public ResponseWriter writeContextURL(StringBuilder sb, String path, String ... pathElement) throws UnifyException {
        RequestContext requestContext = this.getRequestContext();
        if (this.pageRequestContextUtil.isRemoteViewer()) {
            sb.append(this.getSessionContext().getUriBase());
        }
        sb.append(requestContext.getContextPath());
        if (requestContext.isWithTenantPath()) {
            sb.append(requestContext.getTenantPath());
        }
        sb.append(path);
        for (String element : pathElement) {
            sb.append(element);
        }
        return this;
    }

    @Override
    public ResponseWriter writeContextResourceURL(String path, String contentType, String resourceName) throws UnifyException {
        this.writeContextResourceURL(path, contentType, resourceName, null, false, false);
        return this;
    }

    @Override
    public ResponseWriter writeContextResourceURL(String path, String contentType, String resourceName, String scope, boolean attachment, boolean clearOnRead) throws UnifyException {
        this.writeContextURL(path, new String[0]);
        PageManager pageManager = this.getPageManager();
        this.buf.append('?').append(pageManager.getPageName("resourceName")).append("=").append(UrlUtils.encodeURLParameter(this.themeManager.expandThemeTag(resourceName)));
        if (StringUtils.isNotBlank((String)contentType)) {
            this.buf.append('&').append(pageManager.getPageName("contentType")).append("=").append(UrlUtils.encodeURLParameter(contentType));
        }
        if (StringUtils.isNotBlank((String)scope)) {
            this.buf.append('&').append(pageManager.getPageName("scope")).append("=").append(UrlUtils.encodeURLParameter(scope));
        }
        if (attachment) {
            this.buf.append('&').append(pageManager.getPageName("attachment")).append("=").append(attachment);
        }
        if (clearOnRead) {
            this.buf.append('&').append(pageManager.getPageName("clearOnRead")).append("=").append(clearOnRead);
        }
        if (this.pageRequestContextUtil.isRemoteViewer()) {
            this.buf.append('&').append("req_rv").append("=").append(this.pageRequestContextUtil.getRemoteViewer());
            this.buf.append('&').append("req_rsi").append("=").append(this.getRequestContext().getAttribute("req_rsi"));
        }
        return this;
    }

    @Override
    public ResponseWriter writeURLParameter(String name, String value) throws UnifyException {
        this.buf.append('&').append(this.getPageManager().getPageName(name)).append("=").append(UrlUtils.encodeURLParameter(value));
        return this;
    }

    @Override
    public ResponseWriter writeFileImageContextURL(String src) throws UnifyException {
        this.writeContextResourceURL("/resource/file", MimeType.IMAGE.template(), src);
        return this;
    }

    @Override
    public ResponseWriter writeScopeImageContextURL(String imageName) throws UnifyException {
        this.writeContextResourceURL("/resource/scope", MimeType.IMAGE.template(), imageName);
        return this;
    }

    @Override
    public ResponseWriter writeCommandURL() throws UnifyException {
        this.writeContextURL(this.getRequestContextUtil().getResponsePathParts().getControllerPathId(), "/command");
        return this;
    }

    @Override
    public ResponseWriter writeCommandURL(String pageControllerName) throws UnifyException {
        if (QueryUtils.isValidStringCriteria((String)pageControllerName)) {
            this.writeContextURL(pageControllerName, "/command");
        } else {
            this.writeCommandURL();
        }
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.buf.length() == 0;
    }

    @Override
    public ResponseWriter beginFunction(String functionName) throws UnifyException {
        if (this.openFunction) {
            try {
                throw new RuntimeException("Function write already started.");
            }
            catch (Exception e) {
                this.throwOperationErrorException(e);
            }
        }
        this.buf.append(functionName).append("({");
        this.openFunction = true;
        this.paramAppendSym = false;
        return this;
    }

    @Override
    public ResponseWriter endFunction() throws UnifyException {
        if (!this.openFunction) {
            try {
                throw new RuntimeException("Function write is not started");
            }
            catch (Exception e) {
                this.throwOperationErrorException(e);
            }
        }
        this.buf.append("});");
        this.openFunction = false;
        return this;
    }

    @Override
    public ResponseWriter writeParam(String paramName, String[] val) throws UnifyException {
        this.preParamWrite();
        JsonUtils.writeField((LargeStringWriter)this.buf, (String)paramName, (String[])val);
        return this;
    }

    @Override
    public ResponseWriter writeParam(String paramName, String val) throws UnifyException {
        this.preParamWrite();
        JsonUtils.writeField((LargeStringWriter)this.buf, (String)paramName, (String)val);
        return this;
    }

    @Override
    public ResponseWriter writeParam(String paramName, Number[] val) throws UnifyException {
        this.preParamWrite();
        JsonUtils.writeField((LargeStringWriter)this.buf, (String)paramName, (Number[])val);
        return this;
    }

    @Override
    public ResponseWriter writeParam(String paramName, Number val) throws UnifyException {
        this.preParamWrite();
        JsonUtils.writeField((LargeStringWriter)this.buf, (String)paramName, (Number)val);
        return this;
    }

    @Override
    public ResponseWriter writeParam(String paramName, Boolean[] val) throws UnifyException {
        this.preParamWrite();
        JsonUtils.writeField((LargeStringWriter)this.buf, (String)paramName, (Boolean[])val);
        return this;
    }

    @Override
    public ResponseWriter writeParam(String paramName, Boolean val) throws UnifyException {
        this.preParamWrite();
        JsonUtils.writeField((LargeStringWriter)this.buf, (String)paramName, (Boolean)val);
        return this;
    }

    @Override
    public ResponseWriter writeParam(String paramName, char[] val) throws UnifyException {
        this.preParamWrite();
        JsonUtils.writeField((LargeStringWriter)this.buf, (String)paramName, (char[])val);
        return this;
    }

    @Override
    public ResponseWriter writeParam(String paramName, char val) throws UnifyException {
        this.preParamWrite();
        JsonUtils.writeField((LargeStringWriter)this.buf, (String)paramName, (char)val);
        return this;
    }

    @Override
    public ResponseWriter writeParam(String paramName, int[] val) throws UnifyException {
        this.preParamWrite();
        JsonUtils.writeField((LargeStringWriter)this.buf, (String)paramName, (int[])val);
        return this;
    }

    @Override
    public ResponseWriter writeParam(String paramName, int val) throws UnifyException {
        this.preParamWrite();
        JsonUtils.writeField((LargeStringWriter)this.buf, (String)paramName, (int)val);
        return this;
    }

    @Override
    public ResponseWriter writeParam(String paramName, long[] val) throws UnifyException {
        this.preParamWrite();
        JsonUtils.writeField((LargeStringWriter)this.buf, (String)paramName, (long[])val);
        return this;
    }

    @Override
    public ResponseWriter writeParam(String paramName, long val) throws UnifyException {
        this.preParamWrite();
        JsonUtils.writeField((LargeStringWriter)this.buf, (String)paramName, (long)val);
        return this;
    }

    @Override
    public ResponseWriter writeParam(String paramName, short[] val) throws UnifyException {
        this.preParamWrite();
        JsonUtils.writeField((LargeStringWriter)this.buf, (String)paramName, (short[])val);
        return this;
    }

    @Override
    public ResponseWriter writeParam(String paramName, short val) throws UnifyException {
        this.preParamWrite();
        JsonUtils.writeField((LargeStringWriter)this.buf, (String)paramName, (short)val);
        return this;
    }

    @Override
    public ResponseWriter writeParam(String paramName, float[] val) throws UnifyException {
        this.preParamWrite();
        JsonUtils.writeField((LargeStringWriter)this.buf, (String)paramName, (float[])val);
        return this;
    }

    @Override
    public ResponseWriter writeParam(String paramName, float val) throws UnifyException {
        this.preParamWrite();
        JsonUtils.writeField((LargeStringWriter)this.buf, (String)paramName, (float)val);
        return this;
    }

    @Override
    public ResponseWriter writeParam(String paramName, double[] val) throws UnifyException {
        this.preParamWrite();
        JsonUtils.writeField((LargeStringWriter)this.buf, (String)paramName, (double[])val);
        return this;
    }

    @Override
    public ResponseWriter writeParam(String paramName, double val) throws UnifyException {
        this.preParamWrite();
        JsonUtils.writeField((LargeStringWriter)this.buf, (String)paramName, (double)val);
        return this;
    }

    @Override
    public ResponseWriter writeParam(String paramName, boolean[] val) throws UnifyException {
        this.preParamWrite();
        JsonUtils.writeField((LargeStringWriter)this.buf, (String)paramName, (boolean[])val);
        return this;
    }

    @Override
    public ResponseWriter writeParam(String paramName, boolean val) throws UnifyException {
        this.preParamWrite();
        JsonUtils.writeField((LargeStringWriter)this.buf, (String)paramName, (boolean)val);
        return this;
    }

    @Override
    public ResponseWriter writeParam(String paramName, JsonWriter val) throws UnifyException {
        this.preParamWrite();
        this.buf.append('\"').append(paramName).append("\":").append(val.toString());
        return this;
    }

    @Override
    public ResponseWriter writeContextURLParam(String paramName, String path, String ... pathElement) throws UnifyException {
        this.preParamWrite();
        this.buf.append('\"').append(paramName).append("\":\"");
        this.writeContextURL(path, pathElement);
        this.buf.append('\"');
        return this;
    }

    @Override
    public ResponseWriter writeCommandURLParam(String paramName) throws UnifyException {
        this.preParamWrite();
        this.buf.append('\"').append(paramName).append("\":\"");
        this.writeCommandURL();
        this.buf.append('\"');
        return this;
    }

    @Override
    public ResponseWriter writeCommandURLParam(String paramName, String pageControllerName) throws UnifyException {
        this.preParamWrite();
        this.buf.append('\"').append(paramName).append("\":\"");
        this.writeCommandURL(pageControllerName);
        this.buf.append('\"');
        return this;
    }

    @Override
    public ResponseWriter writeResolvedParam(String paramName, String val) throws UnifyException {
        this.preParamWrite();
        this.buf.append('\"').append(paramName).append("\":").append(val);
        return this;
    }

    @Override
    public WebStringWriter getStringWriter() {
        return this.buf;
    }

    @Override
    public void writeTo(Writer writer) throws UnifyException {
        try {
            this.buf.writeTo(writer);
        }
        catch (IOException e) {
            this.throwOperationErrorException(e);
        }
    }

    @Override
    public void useSecondary() {
        this.useSecondary(this.initialBufferCapacity);
    }

    @Override
    public void useSecondary(int initialCapacity) {
        this.secordaryList.add(this.buf);
        this.buf = new WebStringWriter(initialCapacity);
    }

    @Override
    public WebStringWriter discardSecondary() {
        WebStringWriter discLsw = this.buf;
        this.buf = this.secordaryList.remove(this.secordaryList.size() - 1);
        return discLsw;
    }

    @Override
    public void reset(Map<Class<? extends UplComponent>, UplComponentWriter> writers) {
        this.writers = writers;
        if (this.buf == null || !this.buf.isEmpty() || !this.secordaryList.isEmpty()) {
            this.buf = new WebStringWriter(this.initialBufferCapacity);
            this.secordaryList.clear();
            this.openFunction = false;
            this.paramAppendSym = false;
        }
    }

    @Override
    public boolean isTableMode() {
        return this.tableMode;
    }

    @Override
    public void setTableMode(boolean parentStyleMode) {
        this.tableMode = parentStyleMode;
    }

    public String toString() {
        return this.buf.toString();
    }

    protected void onInitialize() throws UnifyException {
    }

    protected void onTerminate() throws UnifyException {
    }

    private void preParamWrite() throws UnifyException {
        if (!this.openFunction) {
            try {
                throw new RuntimeException("Function write is not started");
            }
            catch (Exception e) {
                this.throwOperationErrorException(e);
            }
        }
        if (this.paramAppendSym) {
            this.buf.append(',');
        } else {
            this.paramAppendSym = true;
        }
    }

    private UplComponentWriter getWriter(UplComponent component) throws UnifyException {
        UplComponentWriter writer = this.writers.get(component.getClass());
        if (writer == null) {
            throw new UnifyException("UWI_0010", new Object[]{component.getName()});
        }
        return writer;
    }

    private PageManager getPageManager() throws UnifyException {
        return (PageManager)this.getComponent("application-pagemanager");
    }

    private PageRequestContextUtil getRequestContextUtil() throws UnifyException {
        return (PageRequestContextUtil)this.getComponent("application-pagerequestcontextutil");
    }

    private ResponseWriter writeJsonArray(Object[] arr, boolean quote) throws UnifyException {
        this.buf.append('[');
        if (arr != null) {
            if (quote) {
                boolean appendSym = false;
                for (Object val : arr) {
                    if (appendSym) {
                        this.buf.append(',');
                    } else {
                        appendSym = true;
                    }
                    if (val == null) {
                        this.buf.append(val);
                        continue;
                    }
                    this.writeJsonQuote(String.valueOf(val));
                }
            } else {
                boolean appendSym = false;
                for (Object val : arr) {
                    if (appendSym) {
                        this.buf.append(',');
                    } else {
                        appendSym = true;
                    }
                    this.buf.append(val);
                }
            }
        }
        this.buf.append(']');
        return this;
    }
}

