/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget;

import com.tcdng.unify.core.AbstractUnifyComponent;
import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.Configurable;
import com.tcdng.unify.core.data.AbstractPool;
import com.tcdng.unify.core.upl.UplComponentWriterManager;
import com.tcdng.unify.web.ClientRequest;
import com.tcdng.unify.web.ui.widget.ResponseWriter;
import com.tcdng.unify.web.ui.widget.ResponseWriterPool;
import java.util.Map;

@Component(value="application-responsewriterpool")
public class ResponseWriterPoolImpl
extends AbstractUnifyComponent
implements ResponseWriterPool {
    @Configurable
    private UplComponentWriterManager uplComponentWriterManager;
    @Configurable(value="4000")
    private long getTimeout;
    @Configurable(value="256")
    private int maxSize;
    @Configurable(value="8")
    private int minSize;
    private InternalPool internalPool;

    public void setUplComponentWriterManager(UplComponentWriterManager uplComponentWriterManager) {
        this.uplComponentWriterManager = uplComponentWriterManager;
    }

    public void setGetTimeout(long getTimeout) {
        this.getTimeout = getTimeout;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public void setMinSize(int minSize) {
        this.minSize = minSize;
    }

    @Override
    public ResponseWriter getResponseWriter(ClientRequest clientRequest) throws UnifyException {
        return (ResponseWriter)this.internalPool.borrowObject(new Object[]{this.uplComponentWriterManager.getWriters(clientRequest.getClientPlatform())});
    }

    @Override
    public boolean restore(ResponseWriter writer) throws UnifyException {
        return this.internalPool.returnObject(writer);
    }

    protected void onInitialize() throws UnifyException {
        this.internalPool = new InternalPool();
    }

    protected void onTerminate() throws UnifyException {
    }

    private class InternalPool
    extends AbstractPool<ResponseWriter> {
        public InternalPool() {
            super(ResponseWriterPoolImpl.this.getTimeout, ResponseWriterPoolImpl.this.minSize, ResponseWriterPoolImpl.this.maxSize, true);
        }

        protected ResponseWriter createObject(Object ... params) throws Exception {
            return (ResponseWriter)ResponseWriterPoolImpl.this.getComponent("application-responsewriter");
        }

        protected void onGetObject(ResponseWriter responseWriter, Object ... params) throws Exception {
            responseWriter.reset((Map)params[0]);
        }

        protected void destroyObject(ResponseWriter responseWriter) {
        }
    }
}

