/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget;

import com.tcdng.unify.core.AbstractUnifyComponent;
import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.data.FactoryMap;
import com.tcdng.unify.web.annotation.Action;
import com.tcdng.unify.web.ui.widget.Widget;
import com.tcdng.unify.web.ui.widget.WidgetCommandManager;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

@Component(value="application-uicommandmanager")
public class WidgetCommandManagerImpl
extends AbstractUnifyComponent
implements WidgetCommandManager {
    private FactoryMap<Class<? extends Widget>, UICommandInfo> uiCommandInfoMap = new FactoryMap<Class<? extends Widget>, UICommandInfo>(){

        protected UICommandInfo create(Class<? extends Widget> widgetClass, Object ... params) throws Exception {
            Method[] methods;
            UICommandInfo uiCommandInfo = new UICommandInfo();
            for (Method method : methods = widgetClass.getMethods()) {
                Action ca = method.getAnnotation(Action.class);
                if (ca != null) {
                    if (WidgetCommandManagerImpl.this.isCommandSignature(method)) {
                        uiCommandInfo.addCommandMethod(method);
                        continue;
                    }
                    throw new UnifyException("UWI_000F", new Object[]{widgetClass, method.getName()});
                }
                if (!WidgetCommandManagerImpl.this.isCommandSignature(method) || !WidgetCommandManagerImpl.this.isSuperCommandMethod(widgetClass, method.getName())) continue;
                uiCommandInfo.addCommandMethod(method);
            }
            return uiCommandInfo;
        }
    };

    @Override
    public void executeCommand(Widget widget, String command) throws UnifyException {
        try {
            Method method = ((UICommandInfo)this.uiCommandInfoMap.get(widget.getClass())).getCommandMethod(command);
            if (method == null) {
                throw new UnifyException("UWI_000E", new Object[]{widget.getClass(), command});
            }
            method.invoke((Object)widget, new Object[0]);
        }
        catch (UnifyException e) {
            throw e;
        }
        catch (Exception e) {
            this.throwOperationErrorException(e);
        }
    }

    protected void onInitialize() throws UnifyException {
    }

    protected void onTerminate() throws UnifyException {
    }

    private boolean isCommandSignature(Method method) throws UnifyException {
        return Void.TYPE.equals(method.getReturnType()) && method.getParameterTypes().length == 0 && method.getExceptionTypes().length == 1 && UnifyException.class.isAssignableFrom(method.getExceptionTypes()[0]);
    }

    private boolean isSuperCommandMethod(Class<? extends Widget> widgetClass, String methodName) throws UnifyException {
        Class<? extends Widget> clazz = widgetClass;
        while ((clazz = clazz.getSuperclass()) != null && Widget.class.isAssignableFrom(clazz)) {
            if (!((UICommandInfo)this.uiCommandInfoMap.get(clazz)).isCommandMethod(methodName)) continue;
            return true;
        }
        return false;
    }

    private class UICommandInfo {
        private Map<String, Method> commandMethods = new HashMap<String, Method>();

        public void addCommandMethod(Method method) {
            this.commandMethods.put(method.getName(), method);
        }

        public boolean isCommandMethod(String name) throws UnifyException {
            return this.commandMethods.containsKey(name);
        }

        public Method getCommandMethod(String name) throws UnifyException {
            return this.commandMethods.get(name);
        }
    }
}

