/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.data.FactoryMaps;
import com.tcdng.unify.core.util.StringUtils;
import com.tcdng.unify.web.ui.widget.Widget;
import com.tcdng.unify.web.ui.widget.WidgetNameInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WidgetRepository {
    private static FactoryMaps<String, String, String> longNamesByShortName = new FactoryMaps<String, String, String>(){

        protected String createObject(String parentName, String shortName, Object ... params) throws Exception {
            return StringUtils.dotify((Object[])new Object[]{parentName, shortName});
        }
    };
    private Map<String, Widget> widgets = new HashMap<String, Widget>();
    private Map<String, WidgetNameInfo> widgetNameInfos;

    public WidgetRepository(Map<String, WidgetNameInfo> widgetNameInfos) {
        this.widgetNameInfos = widgetNameInfos;
    }

    public Widget getWidget(String longName) throws UnifyException {
        return this.widgets.get(longName);
    }

    public Widget getWidget(String parentName, String shortName) throws UnifyException {
        return this.widgets.get(longNamesByShortName.get((Object)parentName, (Object)shortName, new Object[0]));
    }

    public boolean isWidget(String longName) throws UnifyException {
        return this.widgets.containsKey(longName);
    }

    public void putWidget(Widget widget) throws UnifyException {
        this.widgets.put(widget.getLongName(), widget);
    }

    public WidgetNameInfo getWidgetInfo(String ownerLongName) {
        return this.widgetNameInfos.get(ownerLongName);
    }

    public Set<String> getWidgetLongNames() {
        return this.widgets.keySet();
    }

    public List<String> getWidgetIds() throws UnifyException {
        ArrayList<String> list = new ArrayList<String>();
        for (Widget widget : this.widgets.values()) {
            list.add(widget.getId());
        }
        return list;
    }
}

