/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.container;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.UplAttribute;
import com.tcdng.unify.core.annotation.UplAttributes;
import com.tcdng.unify.core.data.ValueStore;
import com.tcdng.unify.web.ui.widget.AbstractContainer;
import com.tcdng.unify.web.ui.widget.Section;
import com.tcdng.unify.web.ui.widget.Widget;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

@Component(value="ui-form")
@UplAttributes(value={@UplAttribute(name="columns", type=int.class, defaultVal="1"), @UplAttribute(name="section", type=Section[].class, mandatory=true), @UplAttribute(name="requiredSymbol", type=String.class, defaultVal="*"), @UplAttribute(name="captionSuffix", type=String.class, defaultVal=":")})
public class Form
extends AbstractContainer {
    private FormSection[] formSections;
    private String dataGroupId;

    public Form() {
        super(false);
    }

    @Override
    public void onPageConstruct() throws UnifyException {
        super.onPageConstruct();
        Section[] sections = (Section[])this.getUplAttribute(Section[].class, "section");
        this.formSections = new FormSection[sections.length];
        for (int i = 0; i < sections.length; ++i) {
            this.formSections[i] = new FormSection(sections[i]);
        }
        this.dataGroupId = this.getPrefixedId("data_");
    }

    public List<String> getShallowReferencedLongNames(String attribute) throws UnifyException {
        return this.getWidgetInfo().getShallowNames();
    }

    @Override
    public void cascadeValueStore() throws UnifyException {
        super.cascadeValueStore();
        ValueStore valueStore = this.getChildBindingValueStore();
        for (FormSection formSection : this.formSections) {
            if (!formSection.isBinding()) continue;
            Object newValue = null;
            if (valueStore != null) {
                newValue = valueStore.retrieve(formSection.getBinding());
            }
            if (formSection.oldValue == newValue) continue;
            formSection.valueStore = null;
            formSection.valueStoreList = null;
            if (newValue != null) {
                int i;
                if (newValue.getClass().isArray()) {
                    ArrayList<ValueStore> valueList = new ArrayList<ValueStore>();
                    int len = Array.getLength(newValue);
                    for (i = 0; i < len; ++i) {
                        valueList.add(this.createArrayValueStore((Object[])newValue, i));
                    }
                    formSection.valueStoreList = valueList;
                } else if (newValue instanceof List) {
                    List list = (List)newValue;
                    ArrayList<ValueStore> valueList = new ArrayList<ValueStore>(list.size());
                    for (i = 0; i < list.size(); ++i) {
                        valueList.add(this.createListValueStore(list, i));
                    }
                    formSection.valueStoreList = valueList;
                } else {
                    formSection.valueStore = this.createValueStore(newValue);
                }
            }
            formSection.oldValue = newValue;
        }
    }

    @Override
    public void addPageAliases() throws UnifyException {
        if (this.isContainerEditable()) {
            this.getRequestContextUtil().addPageAlias(this.getId(), this.getDataGroupId());
        }
    }

    public FormSection[] getSections() throws UnifyException {
        return this.formSections;
    }

    public int getSectionCount() throws UnifyException {
        return this.formSections.length;
    }

    public String getDataGroupId() {
        return this.dataGroupId;
    }

    public void setSectionState(String id, boolean visible, boolean editable, boolean disabled) throws UnifyException {
        FormSection formSection = this.getFormSection(id);
        formSection.setVisible(visible);
        formSection.setEditable(editable);
        formSection.setDisabled(disabled);
    }

    public void setSectionVisible(int index, boolean visible) {
        this.formSections[index].setVisible(visible);
    }

    public boolean isSectionVisible(int index) {
        return this.formSections[index].isVisible();
    }

    public void setSectionEditable(int index, boolean editable) {
        this.formSections[index].setEditable(editable);
    }

    public boolean isSectionEditable(int index) {
        return this.formSections[index].isEditable();
    }

    public void setSectionDisabled(int index, boolean disabled) {
        this.formSections[index].setDisabled(disabled);
    }

    public boolean isSectionDisabled(int index) {
        return this.formSections[index].isDisabled();
    }

    public void reset() throws UnifyException {
        this.setEditable(true);
        for (FormSection formSection : this.formSections) {
            formSection.reset();
            for (String ref : formSection.getSection().getReferences()) {
                Widget widget = this.getWidgetByLongName(ref);
                widget.setVisible(true);
                widget.setEditable(true);
                widget.setDisabled(false);
            }
        }
    }

    protected FormSection getFormSection(String id) throws UnifyException {
        for (FormSection section : this.formSections) {
            if (!id.equals(section.getId())) continue;
            return section;
        }
        return null;
    }

    public static class FormSection {
        private Section section;
        private Object oldValue;
        private ValueStore valueStore;
        private List<ValueStore> valueStoreList;
        private boolean visible;
        private boolean editable;
        private boolean disabled;

        public FormSection(Section section) {
            this.section = section;
            this.reset();
        }

        public Section getSection() {
            return this.section;
        }

        public String getId() throws UnifyException {
            return this.section.getUplId();
        }

        public String getPrivilege() throws UnifyException {
            return this.section.getPrivilege();
        }

        public String getBinding() throws UnifyException {
            return this.section.getBinding();
        }

        public boolean isBinding() throws UnifyException {
            return this.section.isBinding();
        }

        public boolean isBindingValue() throws UnifyException {
            return this.valueStore != null;
        }

        public boolean isBindingValueList() throws UnifyException {
            return this.valueStoreList != null;
        }

        public ValueStore getValueStore() {
            return this.valueStore;
        }

        public List<ValueStore> getValueStoreList() {
            return this.valueStoreList;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        public boolean isEditable() {
            return this.editable;
        }

        public void setEditable(boolean editable) {
            this.editable = editable;
        }

        public boolean isDisabled() {
            return this.disabled;
        }

        public void setDisabled(boolean disabled) {
            this.disabled = disabled;
        }

        public void reset() {
            this.visible = true;
            this.editable = true;
            this.disabled = false;
        }
    }
}

