/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.control;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.UplAttribute;
import com.tcdng.unify.core.annotation.UplAttributes;
import com.tcdng.unify.core.data.Listable;
import com.tcdng.unify.core.format.Formatter;
import com.tcdng.unify.web.ui.widget.ListControl;
import com.tcdng.unify.web.ui.widget.ListControlInfo;
import com.tcdng.unify.web.ui.widget.ListControlUtils;
import com.tcdng.unify.web.ui.widget.ListParamType;
import com.tcdng.unify.web.ui.widget.WriteWork;
import com.tcdng.unify.web.ui.widget.control.AbstractPopupTextField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@UplAttributes(value={@UplAttribute(name="list", type=String.class), @UplAttribute(name="listBinding", type=String.class), @UplAttribute(name="listParams", type=String[].class), @UplAttribute(name="listKey", type=String.class), @UplAttribute(name="listDescription", type=String.class), @UplAttribute(name="listParamType", type=ListParamType.class, defaultVal="control"), @UplAttribute(name="exclude", type=String[].class)})
public abstract class AbstractListPopupTextField
extends AbstractPopupTextField
implements ListControl {
    private static final String WORK_LIST_INFO = "workListInfo";
    private Set<String> excludes;

    @Override
    public ListControlInfo getListControlInfo(Formatter<Object> formatter) throws UnifyException {
        WriteWork writeWork = this.getWriteWork();
        ListControlInfo listControlInfo = writeWork.get(ListControlInfo.class, WORK_LIST_INFO);
        if (listControlInfo == null) {
            listControlInfo = this.getListControlUtils().getListControlInfo(this, formatter);
            writeWork.set(WORK_LIST_INFO, listControlInfo);
        }
        return listControlInfo;
    }

    @Override
    public List<? extends Listable> getListables() throws UnifyException {
        if (!this.excludes.isEmpty()) {
            ArrayList<Listable> list = new ArrayList<Listable>();
            for (Listable listable : this.getListControlUtils().getListables(this)) {
                if (this.excludes.contains(listable.getListKey())) continue;
                list.add(listable);
            }
            return list;
        }
        return this.getListControlUtils().getListables(this);
    }

    @Override
    public Map<String, Listable> getListMap() throws UnifyException {
        if (!this.excludes.isEmpty()) {
            HashMap<String, Listable> map = new HashMap<String, Listable>();
            for (Map.Entry<String, Listable> entry : this.getListControlUtils().getListMap(this).entrySet()) {
                if (this.excludes.contains(entry.getKey())) continue;
                map.put(entry.getKey(), entry.getValue());
            }
            return map;
        }
        return this.getListControlUtils().getListMap(this);
    }

    @Override
    public boolean isPopupOnEditableOnly() {
        return false;
    }

    @Override
    public String getList() throws UnifyException {
        return this.getUplAttribute(String.class, "list", "listBinding");
    }

    @Override
    public String[] getListParams() throws UnifyException {
        return (String[])this.getUplAttribute(String[].class, "listParams");
    }

    @Override
    public ListParamType getListParamType() throws UnifyException {
        return (ListParamType)((Object)this.getUplAttribute(ListParamType.class, "listParamType"));
    }

    @Override
    public String getListKey() throws UnifyException {
        return (String)this.getUplAttribute(String.class, "listKey");
    }

    @Override
    public String getListDescription() throws UnifyException {
        return (String)this.getUplAttribute(String.class, "listDescription");
    }

    protected void onInitialize() throws UnifyException {
        super.onInitialize();
        String[] exclude = (String[])this.getUplAttribute(String[].class, "exclude");
        this.excludes = exclude != null && exclude.length > 0 ? new HashSet<String>(Arrays.asList(exclude)) : Collections.emptySet();
    }

    private ListControlUtils getListControlUtils() throws UnifyException {
        return (ListControlUtils)this.getComponent("application-listcontrolutil");
    }
}

