/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.control;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.UplAttribute;
import com.tcdng.unify.core.annotation.UplAttributes;
import com.tcdng.unify.core.format.DateTimeFormat;
import com.tcdng.unify.core.format.Formatter;
import com.tcdng.unify.core.format.Pattern;
import com.tcdng.unify.web.ui.widget.control.AbstractTimeField;
import com.tcdng.unify.web.ui.widget.control.DateFieldType;

@Component(value="ui-date")
@UplAttributes(value={@UplAttribute(name="buttonImgSrc", type=String.class, defaultVal="$t{images/calendar.png}"), @UplAttribute(name="buttonSymbol", type=String.class, defaultVal="calendar-alt"), @UplAttribute(name="formatter", type=Formatter.class, defaultVal="$d{!dateformat style:customshort}"), @UplAttribute(name="type", type=DateFieldType.class, defaultVal="standard")})
public class DateField
extends AbstractTimeField {
    private String[] shortDayList;
    private String[] longMonthList;

    @Override
    public void onPageConstruct() throws UnifyException {
        super.onPageConstruct();
        Formatter<Object> formatter = this.getFormatter();
        for (Pattern p : super.getPattern()) {
            if (p.isFiller() || 'M' != p.getPattern().charAt(0)) continue;
            DateTimeFormat monthDateTimeFormat = formatter.getFormatHelper().getSubPatternDateTimeFormat(p.getPattern(), formatter.getLocale());
            this.longMonthList = monthDateTimeFormat.getSubPatternDescriptions();
        }
        this.shortDayList = formatter.getFormatHelper().getSubPatternDateTimeFormat("EEE", formatter.getLocale()).getSubPatternKeys();
    }

    @Override
    public Pattern[] getPattern() throws UnifyException {
        Pattern[] pattern;
        block5: for (Pattern p : pattern = super.getPattern()) {
            if (p.isFiller()) continue;
            switch (p.getPattern().charAt(0)) {
                case 'y': {
                    p.setTarget("year_");
                    continue block5;
                }
                case 'd': {
                    p.setTarget("day_");
                    continue block5;
                }
                case 'M': {
                    p.setTarget("mon_");
                    continue block5;
                }
            }
        }
        return pattern;
    }

    public DateFieldType getType() throws UnifyException {
        return (DateFieldType)((Object)this.getUplAttribute(DateFieldType.class, "type"));
    }

    public String[] getShortDayList() {
        return this.shortDayList;
    }

    public String[] getLongMonthList() {
        return this.longMonthList;
    }
}

