/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.control;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.UplAttribute;
import com.tcdng.unify.core.annotation.UplAttributes;
import com.tcdng.unify.core.util.DataUtils;
import com.tcdng.unify.web.ui.widget.AbstractFormattedControl;
import java.math.BigDecimal;

@Component(value="ui-debitcreditlabel")
@UplAttributes(value={@UplAttribute(name="negativeCredit", type=boolean.class, defaultVal="true")})
public class DebitCreditLabel
extends AbstractFormattedControl {
    public DebitCreditLabel() {
        super.setEditable(false);
    }

    @Override
    public void setEditable(boolean editable) {
    }

    @Override
    public String getStringValue() throws UnifyException {
        BigDecimal val = this.getValue(BigDecimal.class);
        if (val != null) {
            boolean debit;
            String formatted = (String)DataUtils.convert(String.class, (Object)val.abs(), this.getFormatter());
            boolean bl = debit = val.compareTo(BigDecimal.ZERO) < 0;
            debit = this.isNegativeCredit() ? !debit : debit;
            return formatted + (debit ? " Dr" : " Cr");
        }
        return null;
    }

    @Override
    public boolean isSupportReadOnly() {
        return false;
    }

    @Override
    public boolean isSupportDisabled() {
        return false;
    }

    public boolean isNegativeCredit() throws UnifyException {
        return (Boolean)this.getUplAttribute(Boolean.TYPE, "negativeCredit");
    }
}

