/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.control;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.UplAttribute;
import com.tcdng.unify.core.annotation.UplAttributes;
import com.tcdng.unify.core.util.StringUtils;
import com.tcdng.unify.web.ui.widget.AbstractMultiControl;
import com.tcdng.unify.web.ui.widget.Control;
import java.util.HashMap;
import java.util.Map;

@Component(value="ui-dynamic")
@UplAttributes(value={@UplAttribute(name="descriptorBinding", type=String.class, mandatory=true)})
public class DynamicField
extends AbstractMultiControl {
    private Map<String, String> descriptorToIdMap = new HashMap<String, String>();

    @Override
    public String getStyleClass() throws UnifyException {
        return this.getControl().getStyleClass();
    }

    @Override
    public String getStyle() throws UnifyException {
        return this.getControl().getStyle();
    }

    @Override
    public String getHint() throws UnifyException {
        return this.getControl().getHint();
    }

    @Override
    public void setGroupId(String groupId) throws UnifyException {
        super.setGroupId(groupId);
        for (String id : this.descriptorToIdMap.values()) {
            this.getChildWidgetInfo(id).getWidget().setGroupId(groupId);
        }
    }

    public Control getControl() throws UnifyException {
        Control control = null;
        String descriptorBinding = (String)this.getUplAttribute(String.class, "descriptorBinding");
        String descriptor = (String)this.getValue(descriptorBinding);
        if (StringUtils.isNotBlank((String)descriptor)) {
            String id = this.descriptorToIdMap.get(descriptor);
            if (id == null) {
                String style;
                StringBuilder sb = new StringBuilder(descriptor);
                this.appendUplAttribute(sb, "binding");
                if (descriptor.indexOf("style:$s{") < 0 && !StringUtils.isBlank((String)(style = super.getStyle()))) {
                    sb.append(" style:$s{").append(style).append("}");
                }
                control = (Control)this.addInternalChildWidget(sb.toString(), true, false);
                this.descriptorToIdMap.put(descriptor, control.getBaseId());
            } else {
                control = (Control)this.getChildWidgetInfo(id).getWidget();
            }
            this.addPageAlias(control);
        }
        return control;
    }

    @Override
    protected void doOnPageConstruct() throws UnifyException {
    }
}

