/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.control;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.UplAttribute;
import com.tcdng.unify.core.annotation.UplAttributes;
import com.tcdng.unify.core.data.UploadedFile;
import com.tcdng.unify.core.data.ValueStore;
import com.tcdng.unify.core.util.StringUtils;
import com.tcdng.unify.web.annotation.Action;
import com.tcdng.unify.web.ui.DataTransferBlock;
import com.tcdng.unify.web.ui.widget.AbstractValueListMultiControl;
import com.tcdng.unify.web.ui.widget.Control;
import com.tcdng.unify.web.ui.widget.control.FileAttachmentHandler;
import com.tcdng.unify.web.ui.widget.control.FileUpload;
import com.tcdng.unify.web.ui.widget.data.FileAttachmentInfo;
import com.tcdng.unify.web.ui.widget.data.FileAttachmentsInfo;
import java.util.List;

@Component(value="ui-fileattachment")
@UplAttributes(value={@UplAttribute(name="handler", type=String.class), @UplAttribute(name="viewPath", type=String.class)})
public class FileAttachment
extends AbstractValueListMultiControl<ValueStore, FileAttachmentInfo> {
    private FileUpload fileCtrl;
    private Control attachCtrl;
    private Control viewCtrl;
    private Control removeCtrl;
    private FileAttachmentHandler handler;

    @Override
    public void populate(DataTransferBlock transferBlock) throws UnifyException {
        if (transferBlock != null) {
            DataTransferBlock nextBlock = transferBlock.getChildBlock();
            Object value = nextBlock.getValue();
            FileAttachmentsInfo fileAttachmentsInfo = this.getAttachmentsInfo();
            fileAttachmentsInfo.setSelectedIndex(nextBlock.getItemIndex());
            FileAttachmentInfo fileAttachmentInfo = fileAttachmentsInfo.getSelectedAttachmentInfo();
            UploadedFile uploadedFile = ((UploadedFile[])value)[0];
            fileAttachmentInfo.setFilename(uploadedFile.getFilename());
            fileAttachmentInfo.setAttachment(uploadedFile.getData());
            fileAttachmentsInfo.attach();
            if (this.isWithHandler()) {
                this.getFileAttachmentHandler().handleAttach(fileAttachmentsInfo.getParentId(), fileAttachmentInfo);
                fileAttachmentInfo.setAttachment(null);
            }
        }
    }

    @Action
    public void view() throws UnifyException {
        FileAttachmentsInfo fileAttachmentsInfo = this.getAttachmentsInfo();
        fileAttachmentsInfo.setSelectedIndex(this.getRequestTarget(Integer.TYPE));
        fileAttachmentsInfo.setHandlerName((String)this.getUplAttribute(String.class, "handler"));
        this.setRequestAttribute("WR.fileAttachmentsInfo", fileAttachmentsInfo);
        this.setCommandResultMapping("resrv.showattachment");
    }

    @Action
    public void detach() throws UnifyException {
        FileAttachmentsInfo fileAttachmentsInfo = this.getAttachmentsInfo();
        fileAttachmentsInfo.setSelectedIndex(this.getRequestTarget(Integer.TYPE));
        FileAttachmentInfo fileAttachmentInfo = fileAttachmentsInfo.detach();
        if (this.isWithHandler()) {
            this.getFileAttachmentHandler().handleDetach(fileAttachmentsInfo.getParentId(), fileAttachmentInfo);
        }
        this.invalidateValueList();
    }

    @Override
    public void addPageAliases() throws UnifyException {
        this.addPageAlias(this.fileCtrl);
    }

    public String getViewPath() throws UnifyException {
        return (String)this.getUplAttribute(String.class, "viewPath");
    }

    public FileAttachmentsInfo getAttachmentsInfo() throws UnifyException {
        return this.getValue(FileAttachmentsInfo.class);
    }

    public FileAttachmentHandler getFileAttachmentHandler() throws UnifyException {
        return this.handler;
    }

    public boolean isWithHandler() {
        return this.handler != null;
    }

    public FileUpload getFileCtrl() {
        return this.fileCtrl;
    }

    public Control getAttachCtrl() {
        return this.attachCtrl;
    }

    public Control getViewCtrl() {
        return this.viewCtrl;
    }

    public Control getRemoveCtrl() {
        return this.removeCtrl;
    }

    @Override
    protected void doOnPageConstruct() throws UnifyException {
        this.fileCtrl = (FileUpload)this.addInternalChildWidget("!ui-fileupload acceptBinding:typeName selectOnly:true hidden:true");
        this.attachCtrl = (Control)this.addInternalChildWidget("!ui-button styleClass:$e{fabutton} caption:$m{button.attach} hint:$m{button.attach} debounce:false");
        this.viewCtrl = (Control)this.addInternalChildWidget("!ui-button styleClass:$e{fabutton} caption:$m{button.view} hint:$m{button.view} debounce:false");
        this.removeCtrl = (Control)this.addInternalChildWidget("!ui-button styleClass:$e{fabutton-alert} caption:$m{button.remove} hint:$m{button.remove} debounce:false");
        String _handler = (String)this.getUplAttribute(String.class, "handler");
        if (!StringUtils.isBlank((String)_handler)) {
            this.handler = (FileAttachmentHandler)this.getComponent(_handler);
        }
    }

    @Override
    protected List<FileAttachmentInfo> getItemList() throws UnifyException {
        FileAttachmentsInfo fileAttachmentsInfo = this.getAttachmentsInfo();
        if (fileAttachmentsInfo != null) {
            return fileAttachmentsInfo.getAttachmentInfoList();
        }
        return null;
    }

    @Override
    protected ValueStore newValue(FileAttachmentInfo item, int index) throws UnifyException {
        return this.createValueStore(item, index);
    }

    @Override
    protected void onCreateValueList(List<ValueStore> valueList) throws UnifyException {
    }
}

