/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.control;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.UplAttribute;
import com.tcdng.unify.core.annotation.UplAttributes;
import com.tcdng.unify.core.constant.MimeType;
import com.tcdng.unify.core.data.DownloadFile;
import com.tcdng.unify.core.util.IOUtils;
import com.tcdng.unify.core.util.StringUtils;
import com.tcdng.unify.web.annotation.Action;
import com.tcdng.unify.web.ui.widget.control.Button;
import com.tcdng.unify.web.ui.widget.control.FileDownloadHandler;

@Component(value="ui-filedownload")
@UplAttributes(value={@UplAttribute(name="fileSrc", type=String.class), @UplAttribute(name="fileBinding", type=String.class), @UplAttribute(name="handler", type=String.class), @UplAttribute(name="imageSrc", type=String.class, defaultVal="$t{images/download.png}"), @UplAttribute(name="caption", type=String.class, defaultVal="$m{button.download}")})
public class FileDownload
extends Button {
    @Action
    public void download() throws UnifyException {
        DownloadFile downloadFile = null;
        String fileSrc = (String)this.getUplAttribute(String.class, "fileSrc");
        if (StringUtils.isNotBlank((String)fileSrc)) {
            byte[] data = IOUtils.readFileResourceInputStream((String)fileSrc);
            String fileName = fileSrc;
            int index = fileName.lastIndexOf(47) + 1;
            if (index > 0) {
                fileName = fileName.substring(index);
            }
            downloadFile = new DownloadFile(MimeType.APPLICATION_OCTETSTREAM, fileName, data);
        } else {
            String fileBinding = (String)this.getUplAttribute(String.class, "fileBinding");
            if (StringUtils.isNotBlank((String)fileBinding)) {
                downloadFile = (DownloadFile)this.getValue(fileBinding);
            } else {
                String handler = (String)this.getUplAttribute(String.class, "handler");
                if (StringUtils.isNotBlank((String)handler)) {
                    FileDownloadHandler fileDownloadHandler = (FileDownloadHandler)this.getComponent(handler);
                    String id = this.getRequestTarget(String.class);
                    downloadFile = fileDownloadHandler.handleFileDownload(id);
                }
            }
        }
        if (downloadFile != null) {
            this.setRequestAttribute("WR.downloadFile", downloadFile);
            this.setCommandResultMapping("resrv.downloadfile");
        }
    }
}

