/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.control;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.UplAttribute;
import com.tcdng.unify.core.annotation.UplAttributes;
import com.tcdng.unify.core.constant.FileAttachmentType;
import com.tcdng.unify.core.data.UploadedFile;
import com.tcdng.unify.core.database.Entity;
import com.tcdng.unify.web.annotation.Action;
import com.tcdng.unify.web.ui.DataTransferBlock;
import com.tcdng.unify.web.ui.widget.AbstractMultiControl;
import com.tcdng.unify.web.ui.widget.Control;
import com.tcdng.unify.web.ui.widget.control.FileUpload;
import com.tcdng.unify.web.ui.widget.control.FileUploadViewHandler;
import com.tcdng.unify.web.ui.widget.data.FileAttachmentInfo;

@Component(value="ui-fileuploadview")
@UplAttributes(value={@UplAttribute(name="type", type=FileAttachmentType.class, defaultVal="wildcard"), @UplAttribute(name="handler", type=String.class, mandatory=true), @UplAttribute(name="category", type=String.class), @UplAttribute(name="parentCategory", type=String.class), @UplAttribute(name="parentFieldName", type=String.class), @UplAttribute(name="viewPath", type=String.class)})
public class FileUploadView
extends AbstractMultiControl {
    private FileUpload fileCtrl;
    private Control attachCtrl;
    private Control viewCtrl;
    private Control removeCtrl;
    private FileUploadViewHandler handler;

    @Override
    public void populate(DataTransferBlock transferBlock) throws UnifyException {
        if (transferBlock != null) {
            DataTransferBlock nextBlock = transferBlock.getChildBlock();
            Object value = nextBlock.getValue();
            UploadedFile uploadedFile = ((UploadedFile[])value)[0];
            String category = (String)this.getUplAttribute(String.class, "category");
            FileAttachmentType type = (FileAttachmentType)this.getUplAttribute(FileAttachmentType.class, "type");
            Object uploadId = this.handler.save(this.getUploadId(), category, type, uploadedFile.getFilename(), uploadedFile.getData());
            this.setUploadId(uploadId);
        }
    }

    @Action
    public void view() throws UnifyException {
        Object uploadId = this.getUploadId();
        if (uploadId != null) {
            String category = (String)this.getUplAttribute(String.class, "category");
            FileAttachmentType type = (FileAttachmentType)this.getUplAttribute(FileAttachmentType.class, "type");
            FileAttachmentInfo fileAttachmentInfo = this.handler.retrive(uploadId, category, type);
            this.setRequestAttribute("WR.fileAttachmentsInfo", fileAttachmentInfo);
            this.setCommandResultMapping("resrv.showattachment");
        }
    }

    @Action
    public void detach() throws UnifyException {
        Object uploadId = this.getUploadId();
        Object parentId = null;
        Object valueObject = this.getValueStore().getValueObject();
        if (valueObject instanceof Entity) {
            parentId = ((Entity)valueObject).getId();
        }
        if (uploadId != null) {
            this.handler.delete(uploadId, (String)this.getUplAttribute(String.class, "category"), parentId, (String)this.getUplAttribute(String.class, "parentCategory"), (String)this.getUplAttribute(String.class, "parentFieldName"));
            this.setUploadId(null);
        }
    }

    @Override
    public void addPageAliases() throws UnifyException {
        this.addPageAlias(this.fileCtrl);
    }

    public String getViewPath() throws UnifyException {
        return (String)this.getUplAttribute(String.class, "viewPath");
    }

    public Object getUploadId() throws UnifyException {
        return this.getValue();
    }

    public FileUpload getFileCtrl() {
        return this.fileCtrl;
    }

    public Control getAttachCtrl() {
        return this.attachCtrl;
    }

    public Control getViewCtrl() {
        return this.viewCtrl;
    }

    public Control getRemoveCtrl() {
        return this.removeCtrl;
    }

    @Override
    protected void doOnPageConstruct() throws UnifyException {
        FileAttachmentType _type = (FileAttachmentType)this.getUplAttribute(FileAttachmentType.class, "type");
        this.fileCtrl = (FileUpload)this.addInternalChildWidget("!ui-fileupload accept:" + _type + " selectOnly:true hidden:true");
        this.attachCtrl = (Control)this.addInternalChildWidget("!ui-button styleClass:$e{fabutton} caption:$m{button.attach} hint:$m{button.attach} debounce:false");
        this.viewCtrl = (Control)this.addInternalChildWidget("!ui-button styleClass:$e{fabutton} caption:$m{button.view} hint:$m{button.view} debounce:false");
        this.removeCtrl = (Control)this.addInternalChildWidget("!ui-button styleClass:$e{fabutton-alert} caption:$m{button.remove} hint:$m{button.remove} debounce:false");
        String _handler = (String)this.getUplAttribute(String.class, "handler");
        this.handler = (FileUploadViewHandler)this.getComponent(_handler);
    }

    protected void setUploadId(Object uploadId) throws UnifyException {
        this.setValue(uploadId);
    }
}

