/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.control;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.UplAttribute;
import com.tcdng.unify.core.annotation.UplAttributes;
import com.tcdng.unify.core.data.Money;
import com.tcdng.unify.core.format.Formatter;
import com.tcdng.unify.core.format.NumberFormatter;
import com.tcdng.unify.web.constant.ExtensionType;
import com.tcdng.unify.web.ui.widget.ListParamType;
import com.tcdng.unify.web.ui.widget.WriteWork;
import com.tcdng.unify.web.ui.widget.control.AbstractListPopupTextField;

@Component(value="ui-money")
@UplAttributes(value={@UplAttribute(name="currency", type=String.class), @UplAttribute(name="precision", type=int.class), @UplAttribute(name="scale", type=int.class), @UplAttribute(name="acceptNegative", type=boolean.class), @UplAttribute(name="useGrouping", type=boolean.class), @UplAttribute(name="list", type=String.class, defaultVal="currencylist"), @UplAttribute(name="listParamType", type=ListParamType.class, defaultVal="immediate"), @UplAttribute(name="formatter", type=Formatter.class, defaultVal="$d{!decimalformat}"), @UplAttribute(name="extStyleClass", type=String.class, defaultVal="trread"), @UplAttribute(name="extReadOnly", type=boolean.class, defaultVal="false")})
public class MoneyField
extends AbstractListPopupTextField {
    @Override
    public void onPageConstruct() throws UnifyException {
        NumberFormatter numberFormatter = (NumberFormatter)this.getFormatter();
        int scale = (Integer)this.getUplAttribute(Integer.TYPE, "scale");
        numberFormatter.setScale(scale);
        super.onPageConstruct();
    }

    @Override
    public boolean isMultiple() {
        return true;
    }

    @Override
    public ExtensionType getExtensionType() {
        return ExtensionType.FACADE_HIDDEN;
    }

    @Override
    public boolean isPopupOnEditableOnly() {
        return true;
    }

    @Override
    public boolean isBindEventsToFacade() throws UnifyException {
        return false;
    }

    @Override
    public boolean isOpenPopupOnFac() {
        return false;
    }

    public String getAmountString() throws UnifyException {
        Money money = this.getMoney();
        if (money != null) {
            StringBuilder sb = new StringBuilder();
            Formatter formatter = (Formatter)this.getUplAttribute(Formatter.class, "formatter");
            if (money.getAmount() != null) {
                sb.append(formatter.format((Object)money.getAmount()));
            }
            return sb.toString();
        }
        return "";
    }

    public String getCurrencyString() throws UnifyException {
        Money money = this.getMoney();
        return money != null && money.getCurrencyCode() != null ? money.getCurrencyCode() : (String)this.getUplAttribute(String.class, "currency");
    }

    public String getCurrencyCode() throws UnifyException {
        return (String)this.getUplAttribute(String.class, "currency");
    }

    public boolean isMultiCurrency() throws UnifyException {
        return this.getUplAttribute(String.class, "currency") == null;
    }

    public String getFramePanelId() throws UnifyException {
        return this.getPrefixedId("frm_");
    }

    public String getListPanelId() throws UnifyException {
        return this.getPrefixedId("lst_");
    }

    private Money getMoney() throws UnifyException {
        WriteWork writeWork = this.getWriteWork();
        Money money = writeWork.get(Money.class, "money");
        if (money == null) {
            money = this.getValue(Money.class);
            writeWork.set("money", money);
        }
        return money;
    }
}

