/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.control;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.UplAttribute;
import com.tcdng.unify.core.annotation.UplAttributes;
import com.tcdng.unify.core.constant.FrequencyUnit;
import com.tcdng.unify.core.data.Period;
import com.tcdng.unify.core.format.Formatter;
import com.tcdng.unify.core.format.NumberFormatter;
import com.tcdng.unify.web.constant.ExtensionType;
import com.tcdng.unify.web.ui.widget.WriteWork;
import com.tcdng.unify.web.ui.widget.control.AbstractListPopupTextField;

@Component(value="ui-period")
@UplAttributes(value={@UplAttribute(name="precision", type=int.class, defaultVal="4"), @UplAttribute(name="list", type=String.class, defaultVal="frequencyunitlist"), @UplAttribute(name="formatter", type=Formatter.class, defaultVal="$d{!integerformat}"), @UplAttribute(name="extStyleClass", type=String.class, defaultVal="trread"), @UplAttribute(name="extReadOnly", type=boolean.class, defaultVal="false")})
public class PeriodField
extends AbstractListPopupTextField {
    @Override
    public void onPageConstruct() throws UnifyException {
        NumberFormatter numberFormatter = (NumberFormatter)this.getFormatter();
        int precision = (Integer)this.getUplAttribute(Integer.TYPE, "precision");
        numberFormatter.setPrecision(precision);
        super.onPageConstruct();
    }

    @Override
    public boolean isMultiple() {
        return true;
    }

    @Override
    public ExtensionType getExtensionType() {
        return ExtensionType.FACADE_HIDDEN;
    }

    @Override
    public boolean isPopupOnEditableOnly() {
        return true;
    }

    @Override
    public boolean isBindEventsToFacade() throws UnifyException {
        return false;
    }

    @Override
    public boolean isOpenPopupOnFac() {
        return false;
    }

    public Integer getMagnitude() throws UnifyException {
        Period period = this.getPeriod();
        return period != null ? Integer.valueOf(period.getMagnitude()) : null;
    }

    public FrequencyUnit getFrequencyUnit() throws UnifyException {
        Period period = this.getPeriod();
        return period != null ? period.getUnit() : null;
    }

    public String getFramePanelId() throws UnifyException {
        return this.getPrefixedId("frm_");
    }

    public String getListPanelId() throws UnifyException {
        return this.getPrefixedId("lst_");
    }

    private Period getPeriod() throws UnifyException {
        WriteWork writeWork = this.getWriteWork();
        Period period = writeWork.get(Period.class, "period");
        if (period == null) {
            period = this.getValue(Period.class);
            writeWork.set("period", period);
        }
        return period;
    }
}

