/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.control;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.UplAttribute;
import com.tcdng.unify.core.annotation.UplAttributes;
import com.tcdng.unify.web.ui.widget.Control;
import com.tcdng.unify.web.ui.widget.control.RackButtons;
import com.tcdng.unify.web.ui.widget.control.Table;
import java.util.Collections;
import java.util.List;

@Component(value="ui-rack")
@UplAttributes(value={@UplAttribute(name="actionButtons", type=String.class, defaultVal="!ui-shiftbuttons"), @UplAttribute(name="rowSelectable", type=boolean.class, defaultVal="true")})
public class Rack
extends Table {
    private RackButtons rackCtrl;
    private Control shiftDirectionCtrl;
    private int shiftDirection;

    @Override
    public String getShiftDirectionId() throws UnifyException {
        return this.shiftDirectionCtrl.getId();
    }

    public Control getShiftDirectionCtrl() {
        return this.shiftDirectionCtrl;
    }

    @Override
    public String getShiftTopId() throws UnifyException {
        return this.rackCtrl.getShiftTopGroupId();
    }

    @Override
    public String getShiftUpId() throws UnifyException {
        return this.rackCtrl.getShiftUpGroupId();
    }

    @Override
    public String getShiftDownId() throws UnifyException {
        return this.rackCtrl.getShiftDownGroupId();
    }

    @Override
    public String getShiftBottomId() throws UnifyException {
        return this.rackCtrl.getShiftBottomGroupId();
    }

    @Override
    public String getDeleteId() throws UnifyException {
        return this.rackCtrl.getDeleteGroupId();
    }

    public int isShiftDirection() {
        return this.shiftDirection;
    }

    public void setShiftDirection(int shiftDirection) {
        this.shiftDirection = shiftDirection;
    }

    @Override
    public void addPageAliases() throws UnifyException {
        super.addPageAliases();
        this.addPageAlias(this.shiftDirectionCtrl);
    }

    @Override
    protected void doOnPageConstruct() throws UnifyException {
        StringBuilder sb = new StringBuilder();
        sb.append((String)this.getUplAttribute(String.class, "actionButtons")).append("  caption:$m{table.rack.shift} columnStyle:$s{width:100px;} style:$s{text-align:center;}");
        this.appendUplAttribute(sb, "binding");
        this.rackCtrl = (RackButtons)this.addExternalChildWidget(sb.toString());
        this.shiftDirectionCtrl = (Control)this.addInternalChildWidget("!ui-hidden binding:shiftDirection");
        super.doOnPageConstruct();
    }

    @Override
    protected void doShift() throws UnifyException {
        List list = (List)this.getValue();
        if (list != null && list.size() > 1) {
            int viewIndex;
            boolean swap = false;
            int oldIndex = viewIndex = this.getViewIndex();
            switch (this.shiftDirection) {
                case 0: {
                    viewIndex = 0;
                    break;
                }
                case 1: {
                    if (viewIndex <= 0) break;
                    --viewIndex;
                    swap = true;
                    break;
                }
                case 2: {
                    if (viewIndex >= list.size() - 1) break;
                    ++viewIndex;
                    swap = true;
                    break;
                }
                case 3: {
                    viewIndex = list.size() - 1;
                }
            }
            if (oldIndex != viewIndex) {
                this.setViewIndex(viewIndex);
                if (swap) {
                    Collections.swap(this.getValueList(), oldIndex, viewIndex);
                    Collections.swap(list, oldIndex, viewIndex);
                } else {
                    this.getValueList().add(viewIndex, this.getValueList().remove(oldIndex));
                    list.add(viewIndex, list.remove(oldIndex));
                }
            }
        }
    }
}

