/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.control;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.UplAttribute;
import com.tcdng.unify.core.annotation.UplAttributes;
import com.tcdng.unify.web.annotation.Action;
import com.tcdng.unify.web.constant.ExtensionType;
import com.tcdng.unify.web.ui.widget.ListParamType;
import com.tcdng.unify.web.ui.widget.control.AbstractListPopupTextField;
import com.tcdng.unify.web.ui.widget.data.RefreshSection;

@Component(value="ui-search")
@UplAttributes(value={@UplAttribute(name="filterLabel", type=String.class, defaultVal="$m{search.filter}"), @UplAttribute(name="buttonImgSrc", type=String.class, defaultVal="$t{images/search.png}"), @UplAttribute(name="buttonSymbol", type=String.class, defaultVal="search"), @UplAttribute(name="listParamType", type=ListParamType.class, defaultVal="immediate")})
public class SearchField
extends AbstractListPopupTextField {
    private String filter;
    private boolean keyOnly;

    @Override
    public ExtensionType getExtensionType() {
        return ExtensionType.FACADE_HIDDEN;
    }

    @Override
    public boolean isMultiple() {
        return false;
    }

    @Override
    public String[] getListParams() throws UnifyException {
        String[] params = new String[4];
        if (this.keyOnly) {
            params[0] = this.getStringValue();
        }
        params[1] = this.filter;
        return params;
    }

    @Action
    public void search() throws UnifyException {
        this.filter = this.getRequestTarget(String.class);
        this.setKeyOnly(false);
        this.setRequestAttribute("WR.refreshSection", new RefreshSection(this, this.getResultPanelId()));
        this.setCommandResultMapping("resrv.refreshsection");
    }

    public String getFilter() {
        return this.filter;
    }

    public boolean isKeyOnly() {
        return this.keyOnly;
    }

    public void setKeyOnly(boolean keyOnly) {
        this.keyOnly = keyOnly;
    }

    public String getFilterLabel() throws UnifyException {
        return this.resolveSessionMessage((String)this.getUplAttribute(String.class, "filterLabel"), new Object[0]);
    }

    public String getFilterId() throws UnifyException {
        return this.getPrefixedId("fil_");
    }

    public String getSearchPanelId() throws UnifyException {
        return this.getPrefixedId("sch_");
    }

    public String getResultPanelId() throws UnifyException {
        return this.getPrefixedId("rlt_");
    }

    public String getClearButtonId() throws UnifyException {
        return this.getPrefixedId("clr_");
    }

    public String getCancelButtonId() throws UnifyException {
        return this.getPrefixedId("can_");
    }
}

