/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.control;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.Configurable;
import com.tcdng.unify.core.annotation.UplAttribute;
import com.tcdng.unify.core.annotation.UplAttributes;
import com.tcdng.unify.core.data.AbstractSingleObjectValueStore;
import com.tcdng.unify.core.data.ValueStore;
import com.tcdng.unify.core.format.Formatter;
import com.tcdng.unify.core.upl.UplElementReferences;
import com.tcdng.unify.core.util.DataUtils;
import com.tcdng.unify.core.util.ReflectUtils;
import com.tcdng.unify.core.util.StringUtils;
import com.tcdng.unify.web.annotation.Action;
import com.tcdng.unify.web.font.FontSymbolManager;
import com.tcdng.unify.web.ui.DataTransferBlock;
import com.tcdng.unify.web.ui.widget.AbstractMultiControl;
import com.tcdng.unify.web.ui.widget.AbstractValueListMultiControl;
import com.tcdng.unify.web.ui.widget.Control;
import com.tcdng.unify.web.ui.widget.EventHandler;
import com.tcdng.unify.web.ui.widget.control.ColumnState;
import com.tcdng.unify.web.ui.widget.control.RowState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

@Component(value="ui-table")
@UplAttributes(value={@UplAttribute(name="bodyStyle", type=String.class), @UplAttribute(name="selectBinding", type=String.class), @UplAttribute(name="summarySrc", type=String.class), @UplAttribute(name="summaryProcList", type=String[].class), @UplAttribute(name="summaryDependentList", type=UplElementReferences.class), @UplAttribute(name="contentDependentList", type=UplElementReferences.class), @UplAttribute(name="multiSelDependentList", type=UplElementReferences.class), @UplAttribute(name="selDependentList", type=UplElementReferences.class), @UplAttribute(name="multiSelect", type=boolean.class), @UplAttribute(name="multiSelectCheckboxes", type=boolean.class, defaultVal="true"), @UplAttribute(name="pagination", type=boolean.class), @UplAttribute(name="rowSelectable", type=boolean.class), @UplAttribute(name="serialNumbers", type=boolean.class), @UplAttribute(name="serialNumberSymbol", type=String.class, defaultVal="*"), @UplAttribute(name="windowed", type=boolean.class), @UplAttribute(name="headerEllipsis", type=boolean.class), @UplAttribute(name="contentEllipsis", type=boolean.class), @UplAttribute(name="rowEventHandler", type=EventHandler[].class)})
public class Table
extends AbstractValueListMultiControl<Row, Object> {
    private static final int DEFAULT_ITEMS_PER_PAGE = 50;
    @Configurable
    private FontSymbolManager fontSymbolManager;
    private Control viewIndexCtrl;
    private int viewIndex;
    private Control currentPageCtrl;
    private int currentPage;
    private Control itemsPerPageCtrl;
    private int itemsPerPage;
    private Control columnIndexCtrl;
    private int columnIndex;
    private Control sortDirectionCtrl;
    private boolean sortDirection;
    private boolean sortable;
    private int actualItemsPerPage;
    private int totalPages;
    private int pageItemIndex;
    private int pageItemCount;
    private int totalItemCount;
    private Control multiSelectCtrl;
    private Control ascendingImageCtrl;
    private Control descendingImageCtrl;
    private List<Column> columnList;
    private int pageSelectedRowCount;
    private int selectedRowCount;
    private int naviPageStart;
    private int naviPageStop;
    private int visibleColumnCount;
    private List<String> contentDependentList;
    private List<String> selDependentList;
    private List<String> multiSelDependentList;
    private List<String> summaryDependentList;
    private String dataGroupId;

    public void setFontSymbolManager(FontSymbolManager fontSymbolManager) {
        this.fontSymbolManager = fontSymbolManager;
    }

    @Override
    public void populate(DataTransferBlock transferBlock) throws UnifyException {
        if (transferBlock != null) {
            DataTransferBlock childBlock = transferBlock.getChildBlock();
            AbstractMultiControl.ChildWidgetInfo childWidgetInfo = this.getChildWidgetInfo(childBlock.getId());
            Control control = (Control)childWidgetInfo.getWidget();
            if (childWidgetInfo.isExternal()) {
                control.setValueStore((ValueStore)((Row)this.getValueList().get(childBlock.getItemIndex())).getRowValueStore());
            } else if (control == this.multiSelectCtrl) {
                control.setValueStore((ValueStore)((Row)this.getValueList().get(childBlock.getItemIndex())).getRowValueStore());
            }
            control.populate(childBlock);
            if (this.columnIndex >= 0 && (control == this.columnIndexCtrl || control == this.sortDirectionCtrl)) {
                this.getColumnList().get(this.columnIndex).setAscending(!this.sortDirection);
            }
        }
    }

    public void reset() throws UnifyException {
        this.currentPage = 0;
        for (Column column : this.getColumnList()) {
            if (!column.isVisible()) continue;
            column.setAscending(true);
        }
    }

    public void clear() throws UnifyException {
        this.invalidateValueList();
    }

    public String getBodyStyle() throws UnifyException {
        return (String)this.getUplAttribute(String.class, "bodyStyle");
    }

    public String getSummarySrc() throws UnifyException {
        return (String)this.getUplAttribute(String.class, "summarySrc");
    }

    public String[] getSummaryProcList() throws UnifyException {
        return (String[])this.getUplAttribute(String[].class, "summaryProcList");
    }

    public boolean isPagination() throws UnifyException {
        return (Boolean)this.getUplAttribute(Boolean.TYPE, "pagination");
    }

    public boolean isRowSelectable() throws UnifyException {
        return (Boolean)this.getUplAttribute(Boolean.TYPE, "rowSelectable");
    }

    public boolean isMultiSelect() throws UnifyException {
        return (Boolean)this.getUplAttribute(Boolean.TYPE, "multiSelect");
    }

    public boolean isShowMultiSelectCheckboxes() throws UnifyException {
        return (Boolean)this.getUplAttribute(Boolean.TYPE, "multiSelectCheckboxes");
    }

    public boolean isWindowed() throws UnifyException {
        return (Boolean)this.getUplAttribute(Boolean.TYPE, "windowed") != false || this.isPagination();
    }

    public boolean isSerialNumbers() throws UnifyException {
        return (Boolean)this.getUplAttribute(Boolean.TYPE, "serialNumbers");
    }

    public String getSerialNumberSymbol() throws UnifyException {
        return (String)this.getUplAttribute(String.class, "serialNumberSymbol");
    }

    public boolean isSortable() throws UnifyException {
        return this.sortable;
    }

    public boolean isHeaderEllipsis() throws UnifyException {
        return (Boolean)this.getUplAttribute(Boolean.TYPE, "headerEllipsis");
    }

    public boolean isContentEllipsis() throws UnifyException {
        return (Boolean)this.getUplAttribute(Boolean.TYPE, "contentEllipsis");
    }

    public String getDataGroupId() {
        return this.dataGroupId;
    }

    public List<String> getContentDependentList() throws UnifyException {
        if (this.contentDependentList == null) {
            this.contentDependentList = this.getPageNames((UplElementReferences)this.getUplAttribute(UplElementReferences.class, "contentDependentList"));
        }
        return this.contentDependentList;
    }

    public List<String> getSelDependentList() throws UnifyException {
        if (this.selDependentList == null) {
            this.selDependentList = this.getPageNames((UplElementReferences)this.getUplAttribute(UplElementReferences.class, "selDependentList"));
        }
        return this.selDependentList;
    }

    public List<String> getSummaryDependentList() throws UnifyException {
        if (this.summaryDependentList == null) {
            this.summaryDependentList = this.getPageNames((UplElementReferences)this.getUplAttribute(UplElementReferences.class, "summaryDependentList"));
        }
        return this.summaryDependentList;
    }

    public List<String> getMultiSelDependentList() throws UnifyException {
        if (this.multiSelDependentList == null) {
            this.multiSelDependentList = this.getPageNames((UplElementReferences)this.getUplAttribute(UplElementReferences.class, "multiSelDependentList"));
        }
        return this.multiSelDependentList;
    }

    @Action
    public void sort() throws UnifyException {
        if (this.columnIndex >= 0) {
            ColumnState columnState = this.getColumnList().get(this.columnIndex);
            List list = this.getValueList();
            if (columnState != null && list != null && !list.isEmpty()) {
                Collections.sort(list, new RowComparator(columnState.getFieldName(), this.sortDirection));
                this.reIndex();
                List items = (List)this.getValue();
                if (this.sortDirection) {
                    DataUtils.sortAscending((List)items, items.get(0).getClass(), (String)columnState.getFieldName());
                } else {
                    DataUtils.sortDescending((List)items, items.get(0).getClass(), (String)columnState.getFieldName());
                }
            }
        }
    }

    @Action
    public void shift() throws UnifyException {
        this.doShift();
        this.reIndex();
    }

    @Action
    public void delete() throws UnifyException {
        this.getValueList().remove(this.getViewIndex());
        this.reIndex();
    }

    public List<String> getColumnPropertyList() throws UnifyException {
        ArrayList<String> propertyList = new ArrayList<String>();
        for (AbstractMultiControl.ChildWidgetInfo childWidgetInfo : this.getChildWidgetInfos()) {
            if (!childWidgetInfo.isExternal()) continue;
            propertyList.add(childWidgetInfo.getWidget().getBinding());
        }
        return propertyList;
    }

    public List<? extends ColumnState> getColumnStates() throws UnifyException {
        return this.getColumnList();
    }

    public Control getViewIndexCtrl() {
        return this.viewIndexCtrl;
    }

    public Control getItemsPerPageCtrl() {
        return this.itemsPerPageCtrl;
    }

    public Control getCurrentPageCtrl() {
        return this.currentPageCtrl;
    }

    public String getSelectAllId() throws UnifyException {
        if (this.multiSelectCtrl != null) {
            this.multiSelectCtrl.setValueStore(null);
            return this.multiSelectCtrl.getPrefixedId("sela_");
        }
        return null;
    }

    public String getSelectGroupId() throws UnifyException {
        return this.getPrefixedId("sel_");
    }

    public Control getMultiSelectCtrl() {
        return this.multiSelectCtrl;
    }

    public Control getAscImageCtrl() {
        return this.ascendingImageCtrl;
    }

    public Control getDescImageCtrl() {
        return this.descendingImageCtrl;
    }

    public Control getColumnIndexCtrl() {
        return this.columnIndexCtrl;
    }

    public Control getSortDirectionCtrl() {
        return this.sortDirectionCtrl;
    }

    public String getRowId() throws UnifyException {
        return this.getPrefixedId("row_");
    }

    public String getShiftDirectionId() throws UnifyException {
        return null;
    }

    public String getShiftTopId() throws UnifyException {
        return null;
    }

    public String getShiftUpId() throws UnifyException {
        return null;
    }

    public String getShiftDownId() throws UnifyException {
        return null;
    }

    public String getShiftBottomId() throws UnifyException {
        return null;
    }

    public String getDeleteId() throws UnifyException {
        return null;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) throws UnifyException {
        this.currentPage = currentPage;
    }

    public int getItemsPerPage() {
        return this.itemsPerPage;
    }

    public void setItemsPerPage(int itemsPerPage) throws UnifyException {
        this.itemsPerPage = itemsPerPage;
    }

    public String getSortField() throws UnifyException {
        return this.getColumnList().get(this.columnIndex).getFieldName();
    }

    public boolean isSortAscending() {
        return this.sortDirection;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public void setColumnIndex(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    public void setColumnVisible(String shortName, boolean visible) throws UnifyException {
        for (Column column : this.getColumnList()) {
            if (!shortName.equals(column.getShortName())) continue;
            column.setVisible(visible);
            break;
        }
    }

    public boolean isSortDirection() {
        return this.sortDirection;
    }

    public void setSortDirection(boolean sortDirection) {
        this.sortDirection = sortDirection;
    }

    public void clearPageSelectedRowCount() {
        this.pageSelectedRowCount = 0;
    }

    public void incrementPageSelectedRowCount() {
        ++this.pageSelectedRowCount;
    }

    public int getPageSelectedRowCount() {
        return this.pageSelectedRowCount;
    }

    public void clearVisibleColumnCount() {
        this.visibleColumnCount = 0;
    }

    public void incrementVisibleColumnCount() {
        ++this.visibleColumnCount;
    }

    public int getSelectedRows() {
        return this.selectedRowCount;
    }

    public Object getSelectedItem() throws UnifyException {
        List rowList;
        if (this.viewIndex >= 0 && (rowList = this.getValueList()) != null && this.viewIndex < rowList.size()) {
            return ((Row)rowList.get(this.viewIndex)).getItem();
        }
        return null;
    }

    public Integer[] getSelectedRowIndexes() throws UnifyException {
        this.getValue();
        List rowList = this.getValueList();
        if (rowList == null || rowList.isEmpty()) {
            return DataUtils.ZEROLEN_INTEGER_ARRAY;
        }
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        for (int i = 0; i < rowList.size(); ++i) {
            if (!((Row)rowList.get(i)).isSelected()) continue;
            indexList.add(i);
        }
        return (Integer[])DataUtils.toArray(Integer.class, indexList);
    }

    public <T> List<T> getSelectedItems(Class<T> itemClazz) throws UnifyException {
        this.getValue();
        List rowList = this.getValueList();
        if (rowList == null || rowList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> selectedItems = new ArrayList<Object>();
        for (Row row : rowList) {
            if (!row.isSelected()) continue;
            selectedItems.add(row.getItem());
        }
        return selectedItems;
    }

    public <T> List<T> getSelectedItemsColumnValues(Class<T> itemColumnClazz, String columnProperty) throws UnifyException {
        this.getValue();
        List rowList = this.getValueList();
        if (rowList == null || rowList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> selectedItems = new ArrayList<Object>();
        for (Row row : rowList) {
            if (!row.isSelected()) continue;
            selectedItems.add(row.getRowValueStore().retrieve(itemColumnClazz, columnProperty));
        }
        return selectedItems;
    }

    public int getVisibleColumnCount() {
        return this.visibleColumnCount;
    }

    public int getViewIndex() {
        return this.viewIndex;
    }

    public void setViewIndex(int viewIndex) {
        this.viewIndex = viewIndex;
    }

    public boolean isViewIndexAtFirst() {
        return this.viewIndex == 0;
    }

    public boolean isViewIndexAtLast() {
        return this.viewIndex >= this.totalItemCount - 1;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public int getPageItemIndex() {
        return this.pageItemIndex;
    }

    public int getPageItemCount() {
        return this.pageItemCount;
    }

    public int getTotalItemCount() {
        return this.totalItemCount;
    }

    public int getNaviPageStart() {
        return this.naviPageStart;
    }

    public int getNaviPageStop() {
        return this.naviPageStop;
    }

    public void pageCalculations() throws UnifyException {
        List writeRowList = this.getValueList();
        if (writeRowList != null) {
            this.pageCalculations(writeRowList.size());
        } else {
            this.pageCalculations(0);
        }
        if (this.isPagination()) {
            this.naviPageStart = this.currentPage - 5;
            if (this.naviPageStart < 0) {
                this.naviPageStart = 0;
            }
            this.naviPageStop = this.naviPageStart + 10;
            if (this.naviPageStop >= this.totalPages) {
                this.naviPageStop = this.totalPages == 0 ? 0 : this.totalPages - 1;
            }
        }
    }

    @Override
    public void addPageAliases() throws UnifyException {
        this.addPageAlias(this.viewIndexCtrl);
        if (this.isPagination()) {
            this.addPageAlias(this.currentPageCtrl);
            this.addPageAlias(this.itemsPerPageCtrl);
        }
        if (this.isMultiSelect()) {
            this.addPageAlias(this.getSelectGroupId());
        }
        if (this.sortable) {
            this.addPageAlias(this.columnIndexCtrl);
            this.addPageAlias(this.sortDirectionCtrl);
        }
        if (this.isContainerEditable()) {
            this.addPageAlias(this.getDataGroupId());
        }
    }

    public String getWinId() throws UnifyException {
        return this.getPrefixedId("win_");
    }

    public String getHeaderId() throws UnifyException {
        return this.getPrefixedId("hdr_");
    }

    public String getBodyId() throws UnifyException {
        return this.getPrefixedId("bod_");
    }

    public String getBodyCellId() throws UnifyException {
        return this.getPrefixedId("bodc_");
    }

    public String getNavId() throws UnifyException {
        return this.getPrefixedId("nav_");
    }

    public String getNavLeftId() throws UnifyException {
        return this.getPrefixedId("navl_");
    }

    public String getNavRightId() throws UnifyException {
        return this.getPrefixedId("navr_");
    }

    @Override
    protected void doOnPageConstruct() throws UnifyException {
        this.viewIndexCtrl = (Control)this.addInternalChildWidget("!ui-hidden binding:viewIndex");
        if (this.isPagination()) {
            this.currentPageCtrl = (Control)this.addInternalChildWidget("!ui-hidden binding:currentPage");
            this.itemsPerPageCtrl = (Control)this.addInternalChildWidget("!ui-select styleClass:$e{tpselect} list:itemsperpagelist binding:itemsPerPage");
        }
        if (this.isMultiSelect()) {
            this.multiSelectCtrl = (Control)this.addInternalChildWidget("!ui-checkbox binding:selected");
        }
        this.getColumnList();
        if (this.sortable) {
            if (this.fontSymbolManager != null) {
                this.ascendingImageCtrl = (Control)this.addInternalChildWidget("!ui-symbol symbol:$s{sort} style:$s{width:16px;height:16px;cursor:pointer;}");
                this.descendingImageCtrl = (Control)this.addInternalChildWidget("!ui-symbol symbol:$s{sort} style:$s{width:16px;height:16px;cursor:pointer;}");
            } else {
                this.ascendingImageCtrl = (Control)this.addInternalChildWidget("!ui-image src:$t{images/ascending.png} style:$s{width:16px;height:16px;cursor:pointer;}");
                this.descendingImageCtrl = (Control)this.addInternalChildWidget("!ui-image src:$t{images/descending.png} style:$s{width:16px;height:16px;cursor:pointer;}");
            }
            this.columnIndexCtrl = (Control)this.addInternalChildWidget("!ui-hidden binding:columnIndex", false, true);
            this.sortDirectionCtrl = (Control)this.addInternalChildWidget("!ui-hidden binding:sortDirection", false, true);
        }
        this.dataGroupId = this.getPrefixedId("data_");
    }

    @Override
    protected List<Object> getItemList() throws UnifyException {
        return (List)this.getValue();
    }

    @Override
    protected Row newValue(Object item, int index) throws UnifyException {
        return new Row(item, index);
    }

    @Override
    protected void onCreateValueList(List<Row> valueList) throws UnifyException {
        this.selectedRowCount = 0;
        for (Row row : valueList) {
            if (!row.isSelected()) continue;
            ++this.selectedRowCount;
        }
    }

    protected void doShift() throws UnifyException {
    }

    private void reIndex() throws UnifyException {
        List list = this.getValueList();
        if (list != null && !list.isEmpty()) {
            int len = list.size();
            for (int i = 0; i < len; ++i) {
                ((Row)list.get(i)).setIndex(i);
            }
        }
    }

    public List<Column> getColumnList() throws UnifyException {
        if (this.columnList == null) {
            this.columnList = new ArrayList<Column>();
            for (AbstractMultiControl.ChildWidgetInfo childWidgetInfo : this.getChildWidgetInfos()) {
                if (!childWidgetInfo.isExternal()) continue;
                Column column = new Column((Control)childWidgetInfo.getWidget());
                if (column.isSortable()) {
                    this.sortable = true;
                }
                this.columnList.add(column);
            }
            this.columnList = Collections.unmodifiableList(this.columnList);
        }
        return this.columnList;
    }

    private void pageCalculations(int itemCount) throws UnifyException {
        if (itemCount == 0) {
            this.currentPage = 0;
            this.totalPages = 0;
            this.pageItemIndex = 0;
            this.pageItemCount = 0;
            this.totalItemCount = 0;
            this.actualItemsPerPage = 50;
            this.itemsPerPage = 50;
            return;
        }
        if (!this.isPagination()) {
            this.currentPage = 0;
            this.totalPages = 1;
            this.pageItemIndex = 0;
            this.pageItemCount = itemCount;
            this.totalItemCount = itemCount;
            this.actualItemsPerPage = itemCount;
            this.itemsPerPage = itemCount;
            return;
        }
        this.totalItemCount = itemCount;
        if (this.itemsPerPage == 0) {
            this.itemsPerPage = 50;
        }
        this.actualItemsPerPage = this.itemsPerPage;
        if (this.actualItemsPerPage < 0) {
            this.actualItemsPerPage = this.totalItemCount;
        }
        this.totalPages = this.totalItemCount / this.actualItemsPerPage;
        int lastItemCount = this.totalItemCount % this.actualItemsPerPage;
        if (lastItemCount > 0) {
            ++this.totalPages;
        } else {
            lastItemCount = this.actualItemsPerPage;
        }
        if (this.currentPage < 0) {
            this.currentPage = 0;
        } else if (this.currentPage >= this.totalPages) {
            this.currentPage = this.totalPages - 1;
        }
        this.pageItemIndex = this.currentPage * this.actualItemsPerPage;
        this.pageItemCount = this.actualItemsPerPage;
        if (this.currentPage == this.totalPages - 1) {
            this.pageItemCount = lastItemCount;
        }
    }

    private class RowComparator
    implements Comparator<Row> {
        private String property;
        private boolean ascending;

        public RowComparator(String property, boolean ascending) {
            this.property = property;
            this.ascending = ascending;
        }

        @Override
        public int compare(Row row1, Row row2) {
            try {
                if (this.ascending) {
                    return DataUtils.compareForSortAscending((Comparable)((Comparable)row1.getRowValueStore().retrieve(this.property)), (Comparable)((Comparable)row2.getRowValueStore().retrieve(this.property)));
                }
                return DataUtils.compareForSortDescending((Comparable)((Comparable)row1.getRowValueStore().retrieve(this.property)), (Comparable)((Comparable)row2.getRowValueStore().retrieve(this.property)));
            }
            catch (UnifyException unifyException) {
                return 0;
            }
        }
    }

    public class Column
    implements ColumnState {
        private Control control;
        private String strippedStyle;
        private boolean ascending;

        public Column(Control control) {
            this.control = control;
        }

        @Override
        public boolean isSortable() throws UnifyException {
            return (Boolean)this.control.getUplAttribute(Boolean.TYPE, "sortable");
        }

        public void setAscending(boolean ascending) {
            this.ascending = ascending;
        }

        @Override
        public boolean isAscending() {
            return this.ascending;
        }

        @Override
        public String getFieldName() throws UnifyException {
            return this.control.getBinding();
        }

        public Control getControl() {
            return this.control;
        }

        public String getShortName() throws UnifyException {
            return this.control.getShortName();
        }

        public void setVisible(boolean visible) {
            this.control.setVisible(visible);
        }

        public boolean isVisible() throws UnifyException {
            return this.control.isVisible();
        }

        public boolean isColumnSelectSummary() throws UnifyException {
            return this.control.getColumnSelectSummary();
        }

        public String getStrippedStyle() throws UnifyException {
            if (this.strippedStyle == null) {
                int endIndex;
                String style = this.control.getColumnStyle();
                int index = 0;
                if (StringUtils.isNotBlank((String)style) && (index = style.indexOf("width:")) >= 0 && (endIndex = style.indexOf(59, index)) > index) {
                    this.strippedStyle = (style.substring(0, index) + style.substring(endIndex + 1)).trim();
                    return this.strippedStyle;
                }
                this.strippedStyle = "";
            }
            return this.strippedStyle;
        }

        public boolean isWithStrippedStyle() throws UnifyException {
            return StringUtils.isNotBlank((String)this.getStrippedStyle());
        }
    }

    public class RowValueStore
    extends AbstractSingleObjectValueStore<Row> {
        private RowValueStore(Row row) {
            this(row, null, -1);
        }

        private RowValueStore(Row row, String dataMarker, int dataIndex) {
            super((Object)row, dataMarker, dataIndex);
        }

        public boolean isGettable(String name) throws UnifyException {
            if ("selected".equals(name)) {
                return true;
            }
            return ReflectUtils.isGettableField(((Row)this.storage).item.getClass(), (String)name);
        }

        public boolean isSettable(String name) throws UnifyException {
            if ("selected".equals(name)) {
                return true;
            }
            return ReflectUtils.isSettableField(((Row)this.storage).item.getClass(), (String)name);
        }

        protected Object doRetrieve(String property) throws UnifyException {
            if ("selected".equals(property)) {
                return ((Row)this.storage).selected;
            }
            return ReflectUtils.findNestedBeanProperty((Object)((Row)this.storage).item, (String)property);
        }

        protected void doStore(String property, Object value, Formatter<?> formatter) throws UnifyException {
            if ("selected".equals(property)) {
                ((Row)this.storage).setSelected((Boolean)DataUtils.convert(Boolean.class, (Object)value, formatter));
                return;
            }
            DataUtils.setNestedBeanProperty((Object)((Row)this.storage).item, (String)property, (Object)value, formatter);
        }

        public Object getItem() {
            return ((Row)this.storage).item;
        }
    }

    public class Row
    implements RowState {
        private RowValueStore rowValueStore;
        private Object item;
        private boolean selected;

        public Row(Object item, int index) throws UnifyException {
            this.item = item;
            this.rowValueStore = new RowValueStore(this, Table.this.getUplValueMarker(), index);
            String selectBinding = (String)Table.this.getUplAttribute(String.class, "selectBinding");
            if (selectBinding != null) {
                this.selected = (Boolean)ReflectUtils.findNestedBeanProperty((Object)item, (String)selectBinding);
                if (this.selected) {
                    Table.this.selectedRowCount++;
                }
            }
        }

        @Override
        public boolean isSelected() {
            return this.selected;
        }

        public Object getItem() {
            return this.item;
        }

        public void setRowValueStore(RowValueStore rowValueStore) {
            this.rowValueStore = rowValueStore;
        }

        public void setIndex(int index) {
            this.rowValueStore.setDataIndex(index);
        }

        public RowValueStore getRowValueStore() {
            return this.rowValueStore;
        }

        public void setSelected(boolean selected) throws UnifyException {
            if (this.selected != selected) {
                this.selected = selected;
                String selectBinding = (String)Table.this.getUplAttribute(String.class, "selectBinding");
                if (selectBinding != null) {
                    DataUtils.setNestedBeanProperty((Object)this.item, (String)selectBinding, (Object)selected);
                }
                if (selected) {
                    Table.this.selectedRowCount++;
                } else {
                    Table.this.selectedRowCount--;
                }
            }
        }
    }
}

