/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.control;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.UplAttribute;
import com.tcdng.unify.core.annotation.UplAttributes;
import com.tcdng.unify.core.format.DateTimeFormat;
import com.tcdng.unify.core.format.Formatter;
import com.tcdng.unify.core.format.Pattern;
import com.tcdng.unify.web.ui.widget.control.AbstractTimeField;

@Component(value="ui-time")
@UplAttributes(value={@UplAttribute(name="buttonImgSrc", type=String.class, defaultVal="$t{images/clock.png}"), @UplAttribute(name="buttonSymbol", type=String.class, defaultVal="clock"), @UplAttribute(name="formatter", type=Formatter.class, defaultVal="$d{!timeformat style:short}")})
public class TimeField
extends AbstractTimeField {
    private DateTimeFormat[] dateTimeFormat;

    @Override
    public void onPageConstruct() throws UnifyException {
        super.onPageConstruct();
        Pattern[] pattern = super.getPattern();
        this.dateTimeFormat = new DateTimeFormat[pattern.length];
        Formatter<Object> formatter = this.getFormatter();
        for (int i = 0; i < pattern.length; ++i) {
            Pattern fp = pattern[i];
            if (fp.isFiller()) continue;
            this.dateTimeFormat[i] = formatter.getFormatHelper().getSubPatternDateTimeFormat(fp.getPattern(), formatter.getLocale());
        }
    }

    @Override
    public Pattern[] getPattern() throws UnifyException {
        Pattern[] pattern = super.getPattern();
        block7: for (int i = 0; i < pattern.length; ++i) {
            Pattern fp = pattern[i];
            if (fp.isFiller()) continue;
            switch (fp.getPattern().charAt(0)) {
                case 'H': {
                    fp.setTarget("h24_");
                    continue block7;
                }
                case 'h': {
                    fp.setTarget("h12_");
                    continue block7;
                }
                case 'm': {
                    fp.setTarget("min_");
                    continue block7;
                }
                case 's': {
                    fp.setTarget("sec_");
                    continue block7;
                }
                case 'a': {
                    fp.setTarget("mer_");
                    continue block7;
                }
            }
        }
        return pattern;
    }

    public DateTimeFormat[] getDateTimeFormat() {
        return this.dateTimeFormat;
    }
}

