/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.control;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.UplAttribute;
import com.tcdng.unify.core.annotation.UplAttributes;
import com.tcdng.unify.core.data.MarkedTree;
import com.tcdng.unify.core.upl.UplElementReferences;
import com.tcdng.unify.core.util.DataUtils;
import com.tcdng.unify.core.util.StringUtils;
import com.tcdng.unify.web.TargetPath;
import com.tcdng.unify.web.annotation.Action;
import com.tcdng.unify.web.ui.widget.AbstractMultiControl;
import com.tcdng.unify.web.ui.widget.Control;
import com.tcdng.unify.web.ui.widget.data.Tree;
import com.tcdng.unify.web.ui.widget.data.TreeEvent;
import com.tcdng.unify.web.ui.widget.data.TreeEventType;
import com.tcdng.unify.web.ui.widget.data.TreeItem;
import com.tcdng.unify.web.ui.widget.data.TreeItemTypeInfo;
import com.tcdng.unify.web.ui.widget.data.TreeMenuItemInfo;
import com.tcdng.unify.web.ui.widget.data.TreePolicy;
import com.tcdng.unify.web.ui.widget.data.TreeTypeInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Component(value="ui-treeexplorer")
@UplAttributes(value={@UplAttribute(name="collapsedIcon", type=String.class, defaultVal="$t{images/collapsed.png}"), @UplAttribute(name="expandedIcon", type=String.class, defaultVal="$t{images/expanded.png}"), @UplAttribute(name="treeEventPath", type=String.class), @UplAttribute(name="dataComponents", type=UplElementReferences.class)})
public class TreeExplorer
extends AbstractMultiControl {
    private Control eventTypeCtrl;
    private Control menuCodeCtrl;
    private Control selectedItemIdsCtrl;
    private Control selectedCtrlIdCtrl;
    private Control dropTrgItemIdCtrl;
    private Control dropSrcIdCtrl;
    private Control dropSrcItemIdsCtrl;
    private TreeEventType eventType;
    private String menuCode;
    private List<Long> singleSelectedItemId;
    private Long selectedCtrlId;
    private Long dropTrgItemId;
    private String dropSrcId;
    private String dropSrcItemIds;
    private Tree tree;

    @Override
    public void addPageAliases() throws UnifyException {
        this.addPageAlias(this.menuCodeCtrl);
        this.addPageAlias(this.selectedItemIdsCtrl);
        this.addPageAlias(this.selectedCtrlIdCtrl);
        this.addPageAlias(this.dropTrgItemIdCtrl);
        this.addPageAlias(this.dropSrcIdCtrl);
        this.addPageAlias(this.dropSrcItemIdsCtrl);
        this.addPageAlias(this.eventTypeCtrl);
    }

    @Action
    public void collapse() throws UnifyException {
        this.tree.collapse(this.selectedCtrlId);
    }

    @Action
    public void expand() throws UnifyException {
        this.tree.expand(this.selectedCtrlId);
    }

    @Action
    public void executeEventPath() throws UnifyException {
        String treeEventPath = this.getTreeEventPath();
        if (StringUtils.isNotBlank((String)treeEventPath)) {
            if (TreeEventType.TREEITEM_DROP.equals((Object)this.eventType)) {
                String srcLongName = this.getPageManager().getLongName(this.dropSrcId);
                List srcItemIdList = (List)DataUtils.convert(List.class, Long.class, (Object)StringUtils.commaSplit((String)this.dropSrcItemIds));
                this.tree.registerEvent(this.eventType, this.dropTrgItemId, srcLongName, srcItemIdList);
            } else {
                this.tree.registerEvent(this.eventType, this.menuCode);
            }
            this.setCommandResponsePath(new TargetPath(treeEventPath));
            this.menuCode = null;
        }
    }

    public void setTree(Tree tree) throws UnifyException {
        this.tree = tree;
    }

    public TreePolicy getTreePolicy() {
        return this.tree.getTreePolicy();
    }

    public String getCollapsedIcon() throws UnifyException {
        return (String)this.getUplAttribute(String.class, "collapsedIcon");
    }

    public String getExpandedIcon() throws UnifyException {
        return (String)this.getUplAttribute(String.class, "expandedIcon");
    }

    public String getTreeEventPath() throws UnifyException {
        return (String)this.getUplAttribute(String.class, "treeEventPath");
    }

    public String getMenuId() throws UnifyException {
        return this.getPrefixedId("m_");
    }

    public String getMenuBaseId() throws UnifyException {
        return this.getPrefixedId("mb_");
    }

    public String getMenuSeperatorId() throws UnifyException {
        return this.getPrefixedId("sp_");
    }

    public Control getEventTypeCtrl() {
        return this.eventTypeCtrl;
    }

    public Control getMenuCodeCtrl() {
        return this.menuCodeCtrl;
    }

    public Control getSelectedItemIdsCtrl() {
        return this.selectedItemIdsCtrl;
    }

    public Control getSelectedCtrlIdCtrl() {
        return this.selectedCtrlIdCtrl;
    }

    public Control getDropTrgItemIdCtrl() {
        return this.dropTrgItemIdCtrl;
    }

    public Control getDropSrcIdCtrl() {
        return this.dropSrcIdCtrl;
    }

    public Control getDropSrcItemIdsCtrl() {
        return this.dropSrcItemIdsCtrl;
    }

    public TreeEventType getEventType() {
        return this.eventType;
    }

    public void setEventType(TreeEventType eventType) {
        this.eventType = eventType;
    }

    public Long getDropTrgItemId() {
        return this.dropTrgItemId;
    }

    public void setDropTrgItemId(Long dropTrgItemId) {
        this.dropTrgItemId = dropTrgItemId;
    }

    public String getDropSrcId() {
        return this.dropSrcId;
    }

    public void setDropSrcId(String dropSrcId) {
        this.dropSrcId = dropSrcId;
    }

    public String getDropSrcItemIds() {
        return this.dropSrcItemIds;
    }

    public void setDropSrcItemIds(String dropSrcItemIds) {
        this.dropSrcItemIds = dropSrcItemIds;
    }

    public String getMenuCode() {
        return this.menuCode;
    }

    public void setMenuCode(String menuCode) {
        this.menuCode = menuCode;
    }

    public Long getSelectedCtrlId() {
        return this.selectedCtrlId;
    }

    public void setSelectedCtrlId(Long selectedCtrlId) {
        this.selectedCtrlId = selectedCtrlId;
    }

    public List<Long> getSelectedItemIds() {
        return this.tree.getSelectedItems();
    }

    public void setSelectedItemIds(List<Long> selectedItemIds) {
        this.tree.setSelectedItems(selectedItemIds);
    }

    public void setSelectedItem(Long itemId) {
        this.singleSelectedItemId.set(0, itemId);
        this.setSelectedItemIds(this.singleSelectedItemId);
    }

    public String getControlImgIdBase() throws UnifyException {
        return this.getPrefixedId("ctrl_");
    }

    public String getIconIdBase() throws UnifyException {
        return this.getPrefixedId("icon_");
    }

    public String getCaptionIdBase() throws UnifyException {
        return this.getPrefixedId("cap_");
    }

    public Long addTreeItem(Long parentItemId, String itemTypeCode, Object item) throws UnifyException {
        return this.tree.addTreeItem(parentItemId, itemTypeCode, item);
    }

    public TreeItemTypeInfo getTreeItemTypeInfo(String itemTypeCode) {
        return this.tree.getTreeItemTypeInfo(itemTypeCode);
    }

    public MarkedTree.Node<TreeItem> getRootNode() {
        return this.tree.getRootNode();
    }

    public MarkedTree.Node<TreeItem> getParentNode(Long itemId) {
        return this.tree.getParentNode(itemId);
    }

    public MarkedTree.Node<TreeItem> getNode(Long itemId) {
        return this.tree.getNode(itemId);
    }

    public MarkedTree.Node<TreeItem> getNode(TreeEvent treeEvent, int index) {
        return this.tree.getNode(treeEvent, index);
    }

    public TreeItem getTreeItem(Long itemId) {
        return this.tree.getTreeItem(itemId);
    }

    public TreeItem getTreeItem(TreeEvent treeEvent, int index) {
        return this.tree.getTreeItem(treeEvent, index);
    }

    public TreeItem removeTreeItem(Long mark) throws UnifyException {
        return this.tree.removeTreeItem(mark);
    }

    public int itemCount() {
        return this.tree.itemCount();
    }

    public Collection<TreeTypeInfo.ExtendedTreeItemTypeInfo> getExtendedTreeItemTypeInfos() {
        return this.tree.getExtendedTreeItemTypeInfos();
    }

    public List<TreeMenuItemInfo> getMenuItemInfoList() {
        return this.tree.getMenuItemInfoList();
    }

    public boolean hasMenu() {
        return this.tree.isMenuItemList();
    }

    public TreeEvent getEvent() {
        return this.tree.getEvent();
    }

    public List<Integer> getMultiSelectMenuSequence() {
        return this.tree.getMultiSelectMenuSequence();
    }

    public boolean isMultiSelectMenu() {
        return this.tree.isMultiSelectMenu();
    }

    @Override
    protected void doOnPageConstruct() throws UnifyException {
        this.eventTypeCtrl = (Control)this.addInternalChildWidget("!ui-hidden binding:eventType");
        this.menuCodeCtrl = (Control)this.addInternalChildWidget("!ui-hidden binding:menuCode");
        this.selectedItemIdsCtrl = (Control)this.addInternalChildWidget("!ui-hidden binding:selectedItemIds");
        this.selectedCtrlIdCtrl = (Control)this.addInternalChildWidget("!ui-hidden binding:selectedCtrlId");
        this.dropTrgItemIdCtrl = (Control)this.addInternalChildWidget("!ui-hidden binding:dropTrgItemId");
        this.dropSrcIdCtrl = (Control)this.addInternalChildWidget("!ui-hidden binding:dropSrcId");
        this.dropSrcItemIdsCtrl = (Control)this.addInternalChildWidget("!ui-hidden binding:dropSrcItemIds");
        this.singleSelectedItemId = new ArrayList<Long>(1);
        this.singleSelectedItemId.add(null);
    }
}

