/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.data;

import com.tcdng.unify.core.AbstractUnifyComponent;
import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.util.StringUtils;
import com.tcdng.unify.web.ui.widget.data.AbstractTreeItemUpdater;
import com.tcdng.unify.web.ui.widget.data.TreeItem;
import com.tcdng.unify.web.ui.widget.data.TreeItemTypeInfo;
import com.tcdng.unify.web.ui.widget.data.TreeItemUpdater;
import com.tcdng.unify.web.ui.widget.data.TreePolicy;

public abstract class AbstractTreePolicy
extends AbstractUnifyComponent
implements TreePolicy {
    private static final TreeItemCollapser TREEITEM_COLLAPSER = new TreeItemCollapser();
    private static final TreeItemExpander TREEITEM_EXPANDER = new TreeItemExpander();

    @Override
    public String getTreeItemCaption(TreeItemTypeInfo category, Object item) throws UnifyException {
        String itemCaptionKey = category.getItemCaptionKey();
        if (StringUtils.isBlank((String)itemCaptionKey)) {
            return String.valueOf(item);
        }
        return this.resolveSessionMessage(itemCaptionKey, new Object[]{item});
    }

    @Override
    public TreeItemUpdater getTreeItemExpander() throws UnifyException {
        return TREEITEM_EXPANDER;
    }

    @Override
    public TreeItemUpdater getTreeItemCollapser() throws UnifyException {
        return TREEITEM_COLLAPSER;
    }

    public int addDecision(TreeItem siblingItem, TreeItem childItem) {
        if (childItem.getBuoyancy() < siblingItem.getBuoyancy()) {
            return -1;
        }
        return 0;
    }

    protected void onInitialize() throws UnifyException {
    }

    protected void onTerminate() throws UnifyException {
    }

    private static class TreeItemExpander
    extends AbstractTreeItemUpdater {
        private TreeItemExpander() {
        }

        public void update(TreeItem treeItem) {
            treeItem.setExpanded(true);
        }
    }

    private static class TreeItemCollapser
    extends AbstractTreeItemUpdater {
        private TreeItemCollapser() {
        }

        public void update(TreeItem treeItem) {
            treeItem.setExpanded(false);
        }
    }
}

