/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.data;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.util.ReflectUtils;
import java.util.ArrayList;
import java.util.List;

public class DialogCrudInfo<T> {
    private Class<? extends T> typeClass;
    private List<T> itemList;
    private T item;
    private Mode mode;
    private String title;

    public DialogCrudInfo(Class<? extends T> typeClass) {
        this.typeClass = typeClass;
    }

    public Mode getMode() {
        return this.mode;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void init() throws UnifyException {
        if (this.mode == null) {
            this.newItem();
        }
    }

    public void newItem() throws UnifyException {
        this.mode = Mode.CREATE;
        this.item = ReflectUtils.newInstance(this.typeClass);
    }

    public void saveItem() throws UnifyException {
        if (this.itemList == null) {
            this.itemList = new ArrayList<T>();
        }
        if (this.item != null) {
            this.itemList.add(this.item);
        }
    }

    public void removeItem() throws UnifyException {
        if (this.item != null && this.itemList != null) {
            this.itemList.remove(this.item);
        }
    }

    public void selectItem(int index) {
        if (index >= 0 && this.itemList != null && index < this.itemList.size()) {
            this.mode = Mode.MAINTAIN;
            this.item = this.itemList.get(index);
        }
    }

    public T getItem() {
        return this.item;
    }

    public List<T> getItemList() {
        return this.itemList;
    }

    public void setItemList(List<T> itemList) {
        this.mode = null;
        this.item = null;
        this.itemList = itemList;
    }

    public static enum Mode {
        CREATE,
        MAINTAIN;

    }
}

