/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.data;

import com.tcdng.unify.core.constant.FileAttachmentType;
import com.tcdng.unify.core.util.DataUtils;
import com.tcdng.unify.web.ui.widget.data.FileAttachmentInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class FileAttachmentsInfo {
    private Object parentId;
    private List<FileAttachmentInfo> attachmentInfoList;
    private FileAttachmentType defaultType;
    private String handlerName;
    private int selectedIndex;
    private int maxAutoItems;
    private boolean viewTimestamped;
    private boolean adhoc;
    private boolean disabled;

    public FileAttachmentsInfo(FileAttachmentType defaultType, int maxAutoItems) {
        this(null, defaultType, maxAutoItems);
    }

    public FileAttachmentsInfo(Object parentId, FileAttachmentType defaultType, int maxAutoItems) {
        this.parentId = parentId;
        this.defaultType = defaultType;
        this.maxAutoItems = maxAutoItems;
        this.attachmentInfoList = new ArrayList<FileAttachmentInfo>();
        this.viewTimestamped = true;
        this.adhoc = true;
        this.attach();
    }

    public FileAttachmentsInfo(FileAttachmentInfo ... fileAttachmentInfo) {
        this(null, Arrays.asList(fileAttachmentInfo));
    }

    public FileAttachmentsInfo(List<FileAttachmentInfo> fileAttachmentInfoList) {
        this(null, fileAttachmentInfoList);
    }

    public FileAttachmentsInfo(Object parentId, FileAttachmentInfo ... fileAttachmentInfo) {
        this(parentId, Arrays.asList(fileAttachmentInfo));
    }

    public FileAttachmentsInfo(Object parentId, List<FileAttachmentInfo> fileAttachmentInfoList) {
        this.parentId = parentId;
        this.maxAutoItems = 0;
        this.defaultType = null;
        this.attachmentInfoList = Collections.unmodifiableList(fileAttachmentInfoList);
        this.viewTimestamped = true;
        this.adhoc = false;
    }

    private FileAttachmentsInfo(Object parentId, List<FileAttachmentInfo> attachmentInfoList, FileAttachmentType defaultType, String handlerName, int maxAutoItems, boolean viewTimestamped, boolean adhoc) {
        this.parentId = parentId;
        this.attachmentInfoList = attachmentInfoList;
        this.defaultType = defaultType;
        this.handlerName = handlerName;
        this.maxAutoItems = maxAutoItems;
        this.viewTimestamped = viewTimestamped;
        this.adhoc = adhoc;
    }

    public void attach() {
        if (this.adhoc) {
            if (!this.attachmentInfoList.isEmpty() && this.attachmentInfoList.get(this.attachmentInfoList.size() - 1).isEmpty()) {
                return;
            }
            if (this.maxAutoItems > 0 && this.maxAutoItems <= this.attachmentInfoList.size()) {
                return;
            }
            this.attachmentInfoList.add(new FileAttachmentInfo(this.defaultType));
        }
    }

    public FileAttachmentInfo detach() {
        FileAttachmentInfo result = null;
        if (this.adhoc) {
            result = this.attachmentInfoList.remove(this.selectedIndex);
            this.attach();
        } else {
            result = this.attachmentInfoList.get(this.selectedIndex);
            result.setFilename(null);
            result.setAttachment(null);
        }
        return result;
    }

    public List<FileAttachmentInfo> getAttachmentInfoList() {
        return this.attachmentInfoList;
    }

    public FileAttachmentInfo getSelectedAttachmentInfo() {
        return this.attachmentInfoList.get(this.selectedIndex);
    }

    public FileAttachmentInfo getAttachmentInfo(int index) {
        return this.attachmentInfoList.get(index);
    }

    public Object getParentId() {
        return this.parentId;
    }

    public FileAttachmentType getDefaultType() {
        return this.defaultType;
    }

    public int size() {
        return this.attachmentInfoList.size();
    }

    public int getMaxAutoItems() {
        return this.maxAutoItems;
    }

    public boolean isViewTimestamped() {
        return this.viewTimestamped;
    }

    public boolean isAdhoc() {
        return this.adhoc;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int selectedIndex) {
        this.selectedIndex = selectedIndex;
    }

    public String getHandlerName() {
        return this.handlerName;
    }

    public void setHandlerName(String handlerName) {
        this.handlerName = handlerName;
    }

    public static Builder newBuilder(Object parentId) {
        return new Builder(parentId);
    }

    public static class Builder {
        private Object parentId;
        private Map<String, FileAttachmentInfo> attachmentInfos;
        private FileAttachmentType defaultType;
        private String handlerName;
        private int maxAutoItems;
        private boolean viewTimestamped;
        private boolean adhoc;

        public Builder(Object parentId) {
            this.parentId = parentId;
        }

        public Builder defaultAttachmentType(FileAttachmentType defaultType) {
            this.defaultType = defaultType;
            return this;
        }

        public Builder attachmentHandler(String handlerName) {
            this.handlerName = handlerName;
            return this;
        }

        public Builder maxAutoItems(int maxAutoItems) {
            this.maxAutoItems = maxAutoItems;
            return this;
        }

        public Builder viewTimestamped(boolean viewTimestamped) {
            this.viewTimestamped = viewTimestamped;
            return this;
        }

        public Builder adhoc(boolean adhoc) {
            this.adhoc = adhoc;
            return this;
        }

        public Builder addFileAttachmentInfo(FileAttachmentType type, String name, String description) {
            return this.addFileAttachmentInfo(type, name, description, null);
        }

        public Builder addFileAttachmentInfo(FileAttachmentType type, String name, String description, String filename) {
            this.checkAndEnsureAttachmentInfos(name);
            this.attachmentInfos.put(name, new FileAttachmentInfo(type, name, description, filename));
            return this;
        }

        public void checkAndEnsureAttachmentInfos(String name) {
            if (this.attachmentInfos == null) {
                this.attachmentInfos = new LinkedHashMap<String, FileAttachmentInfo>();
            }
            if (this.attachmentInfos.containsKey(name)) {
                throw new RuntimeException("File attachment information with name [" + name + "] already exists in this object.");
            }
        }

        public FileAttachmentsInfo build() {
            List attachmentInfoList = null;
            if (this.adhoc) {
                attachmentInfoList = new ArrayList();
                if (this.attachmentInfos != null) {
                    attachmentInfoList.addAll(this.attachmentInfos.values());
                }
            } else {
                attachmentInfoList = Collections.emptyList();
                if (this.attachmentInfos != null) {
                    attachmentInfoList = DataUtils.unmodifiableList(this.attachmentInfos.values());
                }
            }
            return new FileAttachmentsInfo(this.parentId, attachmentInfoList, this.defaultType, this.handlerName, this.maxAutoItems, this.viewTimestamped, this.adhoc);
        }
    }
}

