/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.data;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.UnifyOperationException;
import com.tcdng.unify.web.ui.widget.data.LinkCategoryInfo;
import com.tcdng.unify.web.ui.widget.data.LinkInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class LinkGridInfo {
    private List<LinkCategoryInfo> linkCategoryList;

    public LinkGridInfo(List<LinkCategoryInfo> linkCategoryList) {
        this.linkCategoryList = linkCategoryList;
    }

    public List<LinkCategoryInfo> getLinkCategoryList() {
        return this.linkCategoryList;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Map<String, CategoryInfo> categories = new LinkedHashMap<String, CategoryInfo>();

        private Builder() {
        }

        public Builder addCategory(String name, String caption, String path) throws UnifyException {
            if (this.categories.containsKey(name)) {
                throw new UnifyOperationException(new Object[]{"Category with name [" + name + "] exists."});
            }
            this.categories.put(name, new CategoryInfo(caption, path));
            return this;
        }

        public Builder addLink(String categoryName, String code, String caption) throws UnifyException {
            CategoryInfo categoryInfo = this.categories.get(categoryName);
            if (categoryInfo == null) {
                throw new UnifyOperationException(new Object[]{"Category with name [" + categoryName + "] is unknown."});
            }
            categoryInfo.getLinkInfoList().add(new LinkInfo(code, caption));
            return this;
        }

        public boolean isCategory(String name) {
            return this.categories.containsKey(name);
        }

        public LinkGridInfo build() {
            ArrayList<LinkCategoryInfo> linkCategoryList = new ArrayList<LinkCategoryInfo>();
            for (Map.Entry<String, CategoryInfo> entry : this.categories.entrySet()) {
                CategoryInfo categoryInfo = entry.getValue();
                linkCategoryList.add(new LinkCategoryInfo(entry.getKey(), categoryInfo.getCaption(), categoryInfo.getPath(), Collections.unmodifiableList(categoryInfo.getLinkInfoList())));
            }
            return new LinkGridInfo(Collections.unmodifiableList(linkCategoryList));
        }

        private class CategoryInfo {
            private String caption;
            private String path;
            private List<LinkInfo> linkInfoList;

            public CategoryInfo(String caption, String path) {
                this.caption = caption;
                this.path = path;
                this.linkInfoList = new ArrayList<LinkInfo>();
            }

            public String getCaption() {
                return this.caption;
            }

            public String getPath() {
                return this.path;
            }

            public List<LinkInfo> getLinkInfoList() {
                return this.linkInfoList;
            }
        }
    }
}

