/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.data;

import com.tcdng.unify.core.task.TaskMonitor;
import com.tcdng.unify.core.task.TaskOutput;

public class TaskMonitorInfo {
    public static final int BUSY = 0;
    public static final int PASS = 1;
    public static final int FAIL = 2;
    public static final int ERROR = 3;
    private TaskMonitor taskMonitor;
    private String caption;
    private String onSuccessPath;
    private String onFailurePath;

    public TaskMonitorInfo(TaskMonitor taskMonitor, String caption) {
        this(taskMonitor, caption, null, null);
    }

    public TaskMonitorInfo(TaskMonitor taskMonitor, String caption, String onSuccessPath, String onFailurePath) {
        this.taskMonitor = taskMonitor;
        this.caption = caption;
        this.onSuccessPath = onSuccessPath;
        this.onFailurePath = onFailurePath;
    }

    public String getCaption() {
        return this.caption;
    }

    public String getOnSuccessPath() {
        return this.onSuccessPath;
    }

    public String getOnFailurePath() {
        return this.onFailurePath;
    }

    public String[] getMessages() {
        return this.taskMonitor.getMessages();
    }

    public String getLastMessage() {
        return this.taskMonitor.getLastMessage();
    }

    public TaskOutput getTaskOutput(int taskIndex) {
        return this.taskMonitor.getTaskOutput(taskIndex);
    }

    public int getTaskState() {
        switch (this.taskMonitor.getCurrentTaskStatus()) {
            case ABORTED: 
            case CANCELED: 
            case FAILED: {
                return 2;
            }
            case SUCCESSFUL: {
                if (this.taskMonitor.isExceptions()) {
                    return 3;
                }
                return 1;
            }
        }
        return 0;
    }

    public void cancelTask() {
        this.taskMonitor.cancel();
    }
}

