/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.data;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.UnifyOperationException;
import com.tcdng.unify.core.data.MarkedTree;
import com.tcdng.unify.web.ui.widget.data.TreeEvent;
import com.tcdng.unify.web.ui.widget.data.TreeEventType;
import com.tcdng.unify.web.ui.widget.data.TreeItem;
import com.tcdng.unify.web.ui.widget.data.TreeItemTypeInfo;
import com.tcdng.unify.web.ui.widget.data.TreeMenuItemInfo;
import com.tcdng.unify.web.ui.widget.data.TreePolicy;
import com.tcdng.unify.web.ui.widget.data.TreeTypeInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class Tree {
    private TreePolicy treePolicy;
    private TreeTypeInfo typeInfo;
    private MarkedTree<TreeItem> markedTree;
    private List<Long> selectedItemIdList;
    private Queue<TreeEvent> eventQueue;

    private Tree(TreeTypeInfo typeInfo, TreePolicy treePolicy, MarkedTree<TreeItem> markedTree) {
        this.typeInfo = typeInfo;
        this.treePolicy = treePolicy;
        this.markedTree = markedTree;
        this.selectedItemIdList = Collections.emptyList();
        this.eventQueue = new LinkedList<TreeEvent>();
    }

    public Long addTreeItem(Long parentItemId, String itemTypeCode, Object item) throws UnifyException {
        TreeItemTypeInfo treeItemTypeInfo = this.typeInfo.getTreeItemTypeInfo(itemTypeCode);
        if (treeItemTypeInfo == null) {
            throw new UnifyOperationException(new Object[]{"Unknown tree item type code [" + itemTypeCode + "]."});
        }
        Long itemId = this.markedTree.addChild(parentItemId, (Object)new TreeItem(treeItemTypeInfo, item));
        this.markedTree.updateParentNodes(itemId, (MarkedTree.MarkedTreeItemUpdater)this.treePolicy.getTreeItemExpander());
        return itemId;
    }

    public TreePolicy getTreePolicy() {
        return (TreePolicy)this.markedTree.getTreePolicy();
    }

    public boolean isTreePolicy() {
        return this.markedTree.isTreePolicy();
    }

    public MarkedTree.Node<TreeItem> getRootNode() {
        return this.markedTree.getRoot();
    }

    public MarkedTree.Node<TreeItem> getNode(Long itemId) {
        return this.markedTree.getNode(itemId);
    }

    public MarkedTree.Node<TreeItem> getNode(TreeEvent treeEvent, int index) {
        return this.markedTree.getNode(treeEvent.getItemIdList().get(index));
    }

    public MarkedTree.Node<TreeItem> findFirstNode(Long firstItemId, MarkedTree.MarkedTreeItemMatcher<TreeItem> matcher) throws UnifyException {
        return this.markedTree.findFirstNode(firstItemId, matcher);
    }

    public List<MarkedTree.Node<TreeItem>> findNodes(Long firstItemId, MarkedTree.MarkedTreeItemMatcher<TreeItem> matcher) throws UnifyException {
        return this.markedTree.findNodes(firstItemId, matcher);
    }

    public MarkedTree.Node<TreeItem> findFirstChildNode(Long parentItemId, MarkedTree.MarkedTreeItemMatcher<TreeItem> childMatcher) throws UnifyException {
        return this.markedTree.getFirstChildNode(parentItemId, childMatcher);
    }

    public List<MarkedTree.Node<TreeItem>> getChildNodes(Long parentItemId) throws UnifyException {
        return this.markedTree.getChildNodes(parentItemId);
    }

    public List<MarkedTree.Node<TreeItem>> getChildNodes(Long parentItemId, MarkedTree.MarkedTreeItemMatcher<TreeItem> matcher) throws UnifyException {
        return this.markedTree.getChildNodes(parentItemId, matcher);
    }

    public MarkedTree.Node<TreeItem> getParentNode(Long itemId) {
        return this.markedTree.getParentNode(itemId);
    }

    public List<TreeItem> getChildTreeItems(Long parentItemId) throws UnifyException {
        return this.markedTree.getChildItems(parentItemId);
    }

    public List<TreeItem> getChildTreeItems(Long parentItemId, MarkedTree.MarkedTreeItemMatcher<TreeItem> matcher) throws UnifyException {
        return this.markedTree.getChildItems(parentItemId, matcher);
    }

    public TreeItem getTreeItem(Long itemId) {
        MarkedTree.Node node = this.markedTree.getNode(itemId);
        if (node != null) {
            return (TreeItem)node.getItem();
        }
        return null;
    }

    public TreeItem getTreeItem(TreeEvent treeEvent, int index) {
        return this.getTreeItem(treeEvent.getItemIdList().get(index));
    }

    public TreeItem removeTreeItem(Long mark) throws UnifyException {
        MarkedTree.Node node = this.markedTree.remove(mark);
        if (node != null) {
            return (TreeItem)node.getItem();
        }
        return null;
    }

    public int itemCount() {
        return this.markedTree.size();
    }

    public TreeItemTypeInfo getTreeItemTypeInfo(String itemTypeCode) {
        return this.typeInfo.getTreeItemTypeInfo(itemTypeCode);
    }

    public Collection<TreeTypeInfo.ExtendedTreeItemTypeInfo> getExtendedTreeItemTypeInfos() {
        return this.typeInfo.getExtendedTreeItemTypeInfos();
    }

    public List<TreeMenuItemInfo> getMenuItemInfoList() {
        return this.typeInfo.getMenuItemInfoList();
    }

    public boolean isMenuItemList() {
        return this.typeInfo.isMenuItemList();
    }

    public List<Integer> getMultiSelectMenuSequence() {
        return this.typeInfo.getMultiSelectMenuSequence();
    }

    public boolean isMultiSelectMenu() {
        return this.typeInfo.isMultiSelectMenu();
    }

    public void setSelectedItems(List<Long> selectedItemIdList) {
        this.selectedItemIdList = selectedItemIdList;
        for (Long itemId : selectedItemIdList) {
            try {
                this.markedTree.updateParentNodes(itemId, (MarkedTree.MarkedTreeItemUpdater)this.treePolicy.getTreeItemExpander());
            }
            catch (UnifyException unifyException) {}
        }
    }

    public List<Long> getSelectedItems() {
        return this.selectedItemIdList;
    }

    public void registerEvent(TreeEventType eventType, String menuCode) {
        this.eventQueue.offer(new TreeEvent(eventType, menuCode, this.selectedItemIdList));
    }

    public void registerEvent(TreeEventType eventType, Long dropTrgItemId, String srcLongName, List<Long> srcItemIdList) {
        this.eventQueue.offer(new TreeEvent(eventType, this.selectedItemIdList, dropTrgItemId, srcLongName, srcItemIdList));
    }

    public TreeEvent getEvent() {
        return this.eventQueue.poll();
    }

    public void collapseAll() throws UnifyException {
        this.markedTree.updateNodes((MarkedTree.MarkedTreeItemUpdater)this.treePolicy.getTreeItemCollapser());
    }

    public boolean collapse(Long itemId) {
        TreeItem treeItem = this.getTreeItem(itemId);
        if (treeItem != null) {
            treeItem.setExpanded(false);
            return true;
        }
        return false;
    }

    public void expandAll() throws UnifyException {
        this.markedTree.updateNodes((MarkedTree.MarkedTreeItemUpdater)this.treePolicy.getTreeItemExpander());
    }

    public boolean expand(Long itemId) {
        TreeItem treeItem = this.getTreeItem(itemId);
        if (treeItem != null) {
            treeItem.setExpanded(true);
            return true;
        }
        return false;
    }

    public static Builder newBuilder(TreeTypeInfo typeInfo) {
        return new Builder(typeInfo);
    }

    public static class Builder {
        private TreeTypeInfo typeInfo;
        private TreePolicy treePolicy;
        private MarkedTree<TreeItem> markedTree;

        private Builder(TreeTypeInfo typeInfo) {
            this.typeInfo = typeInfo;
            this.markedTree = new MarkedTree((Object)new TreeItem());
        }

        public Builder usePolicy(TreePolicy treePolicy) {
            this.treePolicy = treePolicy;
            this.markedTree.setTreePolicy((MarkedTree.MarkedTreePolicy)treePolicy);
            return this;
        }

        public Builder addTreeItem(String type, Object item) throws UnifyException {
            if (!this.typeInfo.isTreeItemType(type)) {
                throw new UnifyOperationException(new Object[]{"Unknown category [" + type + "]."});
            }
            this.markedTree.add((Object)new TreeItem(this.typeInfo.getTreeItemTypeInfo(type), item));
            return this;
        }

        public MarkedTree.Node<TreeItem> getLastNode() {
            return this.markedTree.getChainLast();
        }

        public boolean descend() throws UnifyException {
            return this.markedTree.descend();
        }

        public boolean ascend() throws UnifyException {
            return this.markedTree.ascend();
        }

        public Tree build() throws UnifyException {
            this.markedTree.setChain(false);
            return new Tree(this.typeInfo, this.treePolicy, this.markedTree);
        }
    }
}

