/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.data;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.util.DataUtils;
import com.tcdng.unify.web.ui.widget.data.TreeEventType;
import java.util.ArrayList;
import java.util.List;

public class TreeItemTypeInfo {
    private String code;
    private String icon;
    private String itemCaptionKey;
    private List<String> menuCodeList;
    private List<String> acceptDropList;
    private int eventFlags;
    private int buoyancy;

    private TreeItemTypeInfo(String code, String icon, String itemCaptionKey, List<String> menuCodeList, List<String> acceptDropList, int eventFlags, int buoyancy) {
        this.code = code;
        this.icon = icon;
        this.itemCaptionKey = itemCaptionKey;
        this.eventFlags = eventFlags;
        this.menuCodeList = menuCodeList;
        this.acceptDropList = acceptDropList;
        this.buoyancy = buoyancy;
    }

    public String getCode() {
        return this.code;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getItemCaptionKey() {
        return this.itemCaptionKey;
    }

    public List<String> getMenuCodeList() {
        return this.menuCodeList;
    }

    public boolean isMenuCodeList() {
        return this.menuCodeList != null && !this.menuCodeList.isEmpty();
    }

    public List<String> getAcceptDropList() {
        return this.acceptDropList;
    }

    public boolean isAcceptDropList() {
        return this.acceptDropList != null && !this.acceptDropList.isEmpty();
    }

    public boolean isDraggable() {
        return (this.eventFlags & TreeEventType.TREEITEM_DRAG.flag()) > 0;
    }

    public int getEventFlags() {
        return this.eventFlags;
    }

    public int getBuoyancy() {
        return this.buoyancy;
    }

    public static Builder newBuilder(String code) {
        return new Builder(code);
    }

    public static class Builder {
        private String code;
        private String icon;
        private String itemCaptionKey;
        private List<String> acceptDropList;
        private List<String> menuCodeList;
        private int eventFlags;
        private int buoyancy;

        private Builder(String code) {
            this.code = code;
        }

        public Builder useIcon(String icon) {
            this.icon = icon;
            return this;
        }

        public Builder useItemCaptionKey(String itemCaptionKey) {
            this.itemCaptionKey = itemCaptionKey;
            return this;
        }

        public Builder atBuoyancy(int buoyancy) {
            this.buoyancy = buoyancy;
            return this;
        }

        public Builder listenTo(TreeEventType ... eventTypes) {
            for (TreeEventType eventType : eventTypes) {
                this.eventFlags |= eventType.flag();
            }
            return this;
        }

        public Builder useMenuItems(String ... codes) throws UnifyException {
            for (String code : codes) {
                this.useMenuItem(code);
            }
            return this;
        }

        public Builder useMenuItem(String code) throws UnifyException {
            if (this.menuCodeList == null) {
                this.menuCodeList = new ArrayList<String>();
            }
            this.menuCodeList.add(code);
            this.listenTo(TreeEventType.TREEITEM_RIGHTCLICK);
            return this;
        }

        public Builder acceptDrops(String ... typeCodes) throws UnifyException {
            for (String typeCode : typeCodes) {
                this.acceptDrop(typeCode);
            }
            return this;
        }

        public Builder acceptDrop(String typeCode) throws UnifyException {
            if (this.acceptDropList == null) {
                this.acceptDropList = new ArrayList<String>();
            }
            this.acceptDropList.add(typeCode);
            return this;
        }

        public TreeItemTypeInfo build() {
            return new TreeItemTypeInfo(this.code, this.icon, this.itemCaptionKey, DataUtils.unmodifiableList(this.menuCodeList), DataUtils.unmodifiableList(this.acceptDropList), this.eventFlags, this.buoyancy);
        }
    }
}

