/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.data;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.UnifyOperationException;
import com.tcdng.unify.core.util.DataUtils;
import com.tcdng.unify.web.ui.widget.data.TreeItemTypeInfo;
import com.tcdng.unify.web.ui.widget.data.TreeMenuItemInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TreeTypeInfo {
    private List<TreeMenuItemInfo> menuItemInfoList;
    private List<Integer> multiSelectMenuSequence;
    private Map<String, ExtendedTreeItemTypeInfo> treeItemTypeInfos;

    private TreeTypeInfo(List<TreeMenuItemInfo> menuItemInfoList, List<Integer> multiSelectMenuSequence, Map<String, ExtendedTreeItemTypeInfo> treeItemTypeInfos) {
        this.menuItemInfoList = menuItemInfoList;
        this.multiSelectMenuSequence = multiSelectMenuSequence;
        this.treeItemTypeInfos = treeItemTypeInfos;
    }

    public List<TreeMenuItemInfo> getMenuItemInfoList() {
        return this.menuItemInfoList;
    }

    public List<Integer> getMultiSelectMenuSequence() {
        return this.multiSelectMenuSequence;
    }

    public Collection<ExtendedTreeItemTypeInfo> getExtendedTreeItemTypeInfos() {
        return this.treeItemTypeInfos.values();
    }

    public TreeItemTypeInfo getTreeItemTypeInfo(String itemTypeCode) {
        ExtendedTreeItemTypeInfo in = this.treeItemTypeInfos.get(itemTypeCode);
        if (in != null) {
            return in.getTreeItemTypeInfo();
        }
        return null;
    }

    public boolean isTreeItemType(String code) {
        return this.treeItemTypeInfos.containsKey(code);
    }

    public List<Integer> getMenuItemSequence(String itemTypeCode) {
        ExtendedTreeItemTypeInfo in = this.treeItemTypeInfos.get(itemTypeCode);
        if (in != null) {
            return in.getMenuSequence();
        }
        return null;
    }

    public boolean isMultiSelectMenu() {
        return !this.multiSelectMenuSequence.isEmpty();
    }

    public boolean isMenuItemList() {
        return !this.menuItemInfoList.isEmpty();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class ExtendedTreeItemTypeInfo {
        private TreeItemTypeInfo treeItemTypeInfo;
        private List<Integer> menuSequence;

        public ExtendedTreeItemTypeInfo(TreeItemTypeInfo treeItemTypeInfo, List<Integer> menuSequence) {
            this.treeItemTypeInfo = treeItemTypeInfo;
            this.menuSequence = menuSequence;
        }

        public TreeItemTypeInfo getTreeItemTypeInfo() {
            return this.treeItemTypeInfo;
        }

        public List<Integer> getMenuSequence() {
            return this.menuSequence;
        }
    }

    public static class Builder {
        private List<TreeMenuItemInfo> menuItemInfoList = new ArrayList<TreeMenuItemInfo>();
        private List<String> menuCodeList = new ArrayList<String>();
        private List<Integer> multiSelectMenuSequence;
        private Map<String, ExtendedTreeItemTypeInfo> treeItemTypeInfos = new HashMap<String, ExtendedTreeItemTypeInfo>();
        private int menuItemGroupIndex;

        private Builder() {
        }

        public Builder addMenuItem(String code, String caption) throws UnifyException {
            return this.addMenuItem(code, caption, null);
        }

        public Builder addMenuItem(String code, String caption, String confirm) throws UnifyException {
            if (this.menuCodeList.contains(code)) {
                throw new UnifyOperationException(new Object[]{"Menu item with code [" + code + "] already exists."});
            }
            this.menuCodeList.add(code);
            this.menuItemInfoList.add(new TreeMenuItemInfo(code, caption, confirm, this.menuItemGroupIndex));
            return this;
        }

        public Builder nextMenuItemGroup() throws UnifyException {
            ++this.menuItemGroupIndex;
            return this;
        }

        public Builder addMultiSelectMenuItem(String menuItemCode) throws UnifyException {
            int menuIndex = this.menuCodeList.indexOf(menuItemCode);
            if (menuIndex < 0) {
                throw new UnifyOperationException(new Object[]{"Multi-select setup refers to unknown menu item [" + menuItemCode + "]."});
            }
            if (this.multiSelectMenuSequence == null) {
                this.multiSelectMenuSequence = new ArrayList<Integer>();
            }
            if (!this.multiSelectMenuSequence.contains(menuIndex)) {
                this.multiSelectMenuSequence.add(menuIndex);
            }
            return this;
        }

        public Builder addTreeItemType(TreeItemTypeInfo treeItemTypeInfo) throws UnifyException {
            if (this.treeItemTypeInfos.containsKey(treeItemTypeInfo.getCode())) {
                throw new UnifyOperationException(new Object[]{"Tree item type with code [" + treeItemTypeInfo.getCode() + "] exists."});
            }
            ArrayList<Integer> menuSequence = null;
            if (treeItemTypeInfo.isMenuCodeList()) {
                menuSequence = new ArrayList<Integer>();
                for (String menuCode : treeItemTypeInfo.getMenuCodeList()) {
                    int menuIndex = this.menuCodeList.indexOf(menuCode);
                    if (menuIndex < 0) {
                        throw new UnifyOperationException(new Object[]{"Tree item type with code [" + treeItemTypeInfo.getCode() + "] refers to unknown menu item [" + menuCode + "]."});
                    }
                    menuSequence.add(menuIndex);
                }
            }
            this.treeItemTypeInfos.put(treeItemTypeInfo.getCode(), new ExtendedTreeItemTypeInfo(treeItemTypeInfo, DataUtils.unmodifiableList(menuSequence)));
            return this;
        }

        public TreeTypeInfo build() throws UnifyException {
            return new TreeTypeInfo(Collections.unmodifiableList(this.menuItemInfoList), DataUtils.unmodifiableList(this.multiSelectMenuSequence), Collections.unmodifiableMap(this.treeItemTypeInfos));
        }
    }
}

