/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.panel;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.UplBinding;
import com.tcdng.unify.core.database.Entity;
import com.tcdng.unify.core.util.ReflectUtils;
import com.tcdng.unify.web.ui.widget.panel.AbstractTableCrudPanel;
import java.util.List;

@UplBinding(value="web/panels/upl/inmemorytablecrudpanel.upl")
public abstract class AbstractInMemoryTableCrudPanel<T extends Entity>
extends AbstractTableCrudPanel<T> {
    private boolean populateListOnly;

    public AbstractInMemoryTableCrudPanel(Class<T> entityClass, String title, boolean populateListOnly) {
        super(entityClass, title);
        this.populateListOnly = populateListOnly;
    }

    @Override
    protected List<T> doFindRecords() throws UnifyException {
        return this.getCrudData().getRecordList();
    }

    @Override
    protected T doPrepareCreateRecord() throws UnifyException {
        return (T)((Entity)ReflectUtils.newInstance(this.getCrudData().getEntityClass()));
    }

    @Override
    protected void doCreateRecord() throws UnifyException {
        Object record = this.getCrudData().getRecord();
        if (this.populateListOnly) {
            this.getGenericService().populateListOnly(record);
        }
        this.getCrudData().getRecordList().add(record);
    }

    @Override
    protected void doUpdateRecord() throws UnifyException {
        Object record = this.getCrudData().getRecord();
        if (this.populateListOnly) {
            this.getGenericService().populateListOnly(record);
        }
    }

    @Override
    protected void doDeleteRecord() throws UnifyException {
        Object record = this.getCrudData().getRecord();
        this.getCrudData().getRecordList().remove(record);
    }
}

