/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.panel;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Configurable;
import com.tcdng.unify.core.annotation.UplAttribute;
import com.tcdng.unify.core.annotation.UplAttributes;
import com.tcdng.unify.core.annotation.UplBinding;
import com.tcdng.unify.core.business.GenericService;
import com.tcdng.unify.core.data.ValueStore;
import com.tcdng.unify.core.data.WrappedData;
import com.tcdng.unify.core.database.Entity;
import com.tcdng.unify.core.database.Query;
import com.tcdng.unify.core.util.ReflectUtils;
import com.tcdng.unify.web.annotation.Action;
import com.tcdng.unify.web.ui.widget.AbstractPanel;
import com.tcdng.unify.web.ui.widget.control.Table;
import com.tcdng.unify.web.ui.widget.panel.TableCrudPanel;
import java.util.ArrayList;
import java.util.List;

@UplBinding(value="web/panels/upl/tablecrudpanel.upl")
@UplAttributes(value={@UplAttribute(name="createNext", type=boolean.class, defaultVal="false")})
public abstract class AbstractTableCrudPanel<T extends Entity>
extends AbstractPanel
implements TableCrudPanel<T> {
    @Configurable
    private GenericService genericService;
    private FORMMODE formMode;
    private CrudData crudData;
    private boolean searchOnSwitchState;

    public AbstractTableCrudPanel(Class<T> entityClass, String title) {
        this(entityClass, title, false);
    }

    public AbstractTableCrudPanel(Class<T> entityClass, String title, boolean searchOnSwitchState) {
        this.searchOnSwitchState = searchOnSwitchState;
        this.crudData = new CrudData(entityClass, title);
    }

    public void setGenericService(GenericService genericService) {
        this.genericService = genericService;
    }

    @Override
    public void onPageConstruct() throws UnifyException {
        super.onPageConstruct();
        this.setFormMode(FORMMODE.CREATE, null);
    }

    @Override
    public void clear() throws UnifyException {
        this.setRecordList(null);
        this.crudData.setParentId(null);
        this.crudData.getQuery().clear();
    }

    @Override
    public T getRecord(int index) throws UnifyException {
        return (T)((Entity)this.crudData.getRecordList().get(index));
    }

    @Override
    public void setRecordList(List<T> recordList) throws UnifyException {
        this.crudData.setRecordList(recordList);
        Table table = (Table)this.getWidgetByShortName("simpleCrudTbl");
        table.reset();
    }

    @Override
    public List<T> getRecordList() throws UnifyException {
        return this.crudData.getRecordList();
    }

    @Override
    @Action
    public void switchState() throws UnifyException {
        super.switchState();
        boolean editable = this.isContainerEditable() && !this.isContainerDisabled();
        this.setVisible("addBtn", editable);
        this.setVisible("editBtn", editable);
        this.setVisible("deleteBtn", editable);
        this.setVisible("createFrmBtn", false);
        this.setVisible("createNextFrmBtn", false);
        this.setVisible("saveFrmBtn", false);
        this.setVisible("deleteFrmBtn", false);
        this.setVisible("cancelFrmBtn", false);
        this.setVisible("doneFrmBtn", false);
        switch (this.formMode) {
            case CREATE: {
                this.setEditable("formPanel", editable);
                this.setVisible("createFrmBtn", editable);
                this.setVisible("cancelFrmBtn", true);
                this.setVisible("createNextFrmBtn", editable && (Boolean)this.getUplAttribute(Boolean.TYPE, "createNext") != false);
                break;
            }
            case DELETE: {
                this.setEditable("formPanel", false);
                this.setVisible("deleteFrmBtn", editable);
                this.setVisible("cancelFrmBtn", true);
                break;
            }
            case UPDATE: {
                this.setEditable("formPanel", editable);
                this.setVisible("saveFrmBtn", editable);
                this.setVisible("cancelFrmBtn", true);
                break;
            }
            default: {
                this.setEditable("formPanel", false);
                this.setVisible("doneFrmBtn", true);
            }
        }
        if (this.searchOnSwitchState) {
            this.findRecords();
        }
    }

    @Override
    public void setValueStore(ValueStore valueStore) throws UnifyException {
        if (this.getValueStore() == null) {
            super.setValueStore(this.createValueStore(this.crudData));
        }
    }

    @Action
    public void prepareCreateRecord() throws UnifyException {
        this.crudData.setRecord(this.doPrepareCreateRecord());
        this.setFormMode(FORMMODE.CREATE, "simplecrudpanel.createrecord");
        this.showPopup();
    }

    @Action
    public void createRecord() throws UnifyException {
        this.doCreateRecord();
        this.findRecords();
        this.hidePopup();
        this.notifyListeners("CREATE");
    }

    @Action
    public void createNextRecord() throws UnifyException {
        this.doCreateRecord();
        this.findRecords();
        this.prepareCreateRecord();
        this.refreshTable();
        this.notifyListeners("CREATE_NEXT");
    }

    @Action
    public void prepareViewRecord() throws UnifyException {
        this.loadSelectedRecordForView();
        this.setFormMode(FORMMODE.RETRIEVE, "simplecrudpanel.viewrecord");
        this.showPopup();
    }

    @Action
    public void prepareUpdateRecord() throws UnifyException {
        this.loadSelectedRecordForView();
        this.setFormMode(FORMMODE.UPDATE, "simplecrudpanel.editrecord");
        this.showPopup();
    }

    @Action
    public void updateRecord() throws UnifyException {
        this.doUpdateRecord();
        this.findRecords();
        this.hidePopup();
        this.notifyListeners("UPDATE");
    }

    @Action
    public void prepareDeleteRecord() throws UnifyException {
        this.loadSelectedRecordForView();
        this.setFormMode(FORMMODE.DELETE, "simplecrudpanel.deleterecord");
        this.showPopup();
    }

    @Action
    public void deleteRecord() throws UnifyException {
        this.doDeleteRecord();
        this.findRecords();
        this.hidePopup();
        this.notifyListeners("DELETE");
    }

    @Action
    public void cancel() throws UnifyException {
        this.hidePopup();
        this.notifyListeners("CANCEL");
    }

    protected void setFormMode(FORMMODE formMode, String captionKey) throws UnifyException {
        this.formMode = formMode;
        if (formMode == null) {
            this.formMode = FORMMODE.CREATE;
        }
        if (captionKey != null) {
            String crudTypeTitle = this.crudData.getTitleKey();
            if (crudTypeTitle != null) {
                this.crudData.setCaption(this.getSessionMessage(captionKey, new Object[]{this.resolveSessionMessage(crudTypeTitle, new Object[0])}));
            } else {
                this.crudData.setCaption(this.getSessionMessage(captionKey, new Object[0]));
            }
            this.cascadeValueStore();
            this.switchState();
        }
    }

    protected FORMMODE getFormMode() {
        return this.formMode;
    }

    protected CrudData getCrudData() throws UnifyException {
        return this.crudData;
    }

    protected boolean isRecord() throws UnifyException {
        return this.crudData.getRecord() != null;
    }

    protected void showPopup() throws UnifyException {
        this.commandShowPopup(this.getWidgetByShortName("simpleCrudPopup").getLongName());
    }

    protected void hidePopup() throws UnifyException {
        this.commandHidePopup();
    }

    protected void refreshTable() throws UnifyException {
        this.getRequestContextUtil().setRequestPopupName(this.getWidgetByShortName("simpleCrudPopup").getLongName());
        this.setCommandResultMapping("resrv.refreshshowpopup");
    }

    protected T loadSelectedRecordForView() throws UnifyException {
        Integer idx = this.getRequestTarget(Integer.class);
        Entity record = (Entity)this.crudData.getRecordList().get(idx);
        this.crudData.setRecord(record);
        return (T)record;
    }

    protected final void findRecords() throws UnifyException {
        this.setRecordList(this.doFindRecords());
    }

    protected List<T> doFindRecords() throws UnifyException {
        this.doSetSearchFilter(this.crudData.getQuery());
        return this.genericService.listAll(this.crudData.getQuery());
    }

    protected T doPrepareCreateRecord() throws UnifyException {
        return (T)((Entity)ReflectUtils.newInstance(this.crudData.getEntityClass()));
    }

    protected void doCreateRecord() throws UnifyException {
        this.genericService.create(this.crudData.getRecord());
    }

    protected void doUpdateRecord() throws UnifyException {
        this.genericService.update(this.crudData.getRecord());
    }

    protected void doDeleteRecord() throws UnifyException {
        Object record = this.crudData.getRecord();
        this.genericService.delete(record.getClass(), record.getId());
    }

    protected void doSetSearchFilter(Query<T> query) throws UnifyException {
        query.ignoreEmptyCriteria(true);
    }

    protected GenericService getGenericService() {
        return this.genericService;
    }

    protected class CrudData {
        private Long parentId;
        private String title;
        private String caption;
        private List<T> recordList;
        private T record;
        private WrappedData<T> wrappedRecord;
        private Query<T> query;

        public CrudData(Class<T> entityClass, String title) {
            this.title = title;
            this.recordList = new ArrayList();
            this.query = Query.of(entityClass);
        }

        public Long getParentId() {
            return this.parentId;
        }

        public void setParentId(Long parentId) {
            this.parentId = parentId;
        }

        public String getTitleKey() {
            return this.title;
        }

        public Query<T> getQuery() {
            return this.query;
        }

        public Class<T> getEntityClass() {
            return this.query.getEntityClass();
        }

        public List<T> getRecordList() {
            return this.recordList;
        }

        public void setRecordList(List<T> recordList) {
            this.recordList = recordList;
        }

        public T getRecord() {
            return this.record;
        }

        public void setRecord(T record) {
            this.record = record;
        }

        public WrappedData<T> getWrappedRecord() {
            return this.wrappedRecord;
        }

        public void setWrappedRecord(WrappedData<T> wrappedRecord) {
            this.wrappedRecord = wrappedRecord;
            this.record = (Entity)wrappedRecord.getData();
        }

        public String getCaption() {
            return this.caption;
        }

        public void setCaption(String caption) {
            this.caption = caption;
        }
    }

    protected static enum FORMMODE {
        CREATE,
        RETRIEVE,
        UPDATE,
        DELETE;

    }
}

