/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.panel;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.Configurable;
import com.tcdng.unify.core.annotation.UplAttribute;
import com.tcdng.unify.core.annotation.UplAttributes;
import com.tcdng.unify.core.upl.UplElementReferences;
import com.tcdng.unify.core.util.StringUtils;
import com.tcdng.unify.web.ControllerPathParts;
import com.tcdng.unify.web.constant.ClosePageMode;
import com.tcdng.unify.web.ui.PagePathInfoRepository;
import com.tcdng.unify.web.ui.widget.AbstractContentPanel;
import com.tcdng.unify.web.ui.widget.Page;
import com.tcdng.unify.web.ui.widget.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component(value="ui-contentpanel")
@UplAttributes(value={@UplAttribute(name="path", type=String.class), @UplAttribute(name="pathBinding", type=String.class), @UplAttribute(name="tabbed", type=boolean.class), @UplAttribute(name="tabbedBinding", type=String.class), @UplAttribute(name="titlebar", type=boolean.class), @UplAttribute(name="sidebar", type=UplElementReferences.class)})
public class ContentPanelImpl
extends AbstractContentPanel {
    @Configurable
    private PagePathInfoRepository pathInfoRepository;
    private Map<String, ContentInfo> contentByPathIdMap = new HashMap<String, ContentInfo>();
    private List<ContentInfo> contentList = new ArrayList<ContentInfo>();
    private int contentIndex;

    public void setPathInfoRepository(PagePathInfoRepository pathInfoRepository) {
        this.pathInfoRepository = pathInfoRepository;
    }

    public String getPath() throws UnifyException {
        return this.getUplAttribute(String.class, "path", "pathBinding");
    }

    public boolean isTabbed() throws UnifyException {
        String tabbedBinding = (String)this.getUplAttribute(String.class, "tabbedBinding");
        if (StringUtils.isNotBlank((String)tabbedBinding)) {
            return this.getValue(Boolean.TYPE, tabbedBinding);
        }
        return (Boolean)this.getUplAttribute(Boolean.TYPE, "tabbed");
    }

    public boolean isTitleBar() throws UnifyException {
        return (Boolean)this.getUplAttribute(Boolean.TYPE, "titlebar");
    }

    public String getHintPanelId() throws UnifyException {
        return this.getPrefixedId("hint_");
    }

    @Override
    public String getBaseContentId() throws UnifyException {
        return this.getPrefixedId("base_");
    }

    @Override
    public String getBusyIndicatorId() throws UnifyException {
        return this.getPrefixedId("busy_");
    }

    public String getTabItemId(int index) throws UnifyException {
        return this.getPrefixedId("tabitem_") + index;
    }

    public String getTabItemImgId(int index) throws UnifyException {
        return this.getPrefixedId("tabimg_") + index;
    }

    public String getTabPaneId() throws UnifyException {
        return this.getPrefixedId("tp_");
    }

    public String getMenuId() throws UnifyException {
        return this.getPrefixedId("m_");
    }

    public String getMenuBaseId() throws UnifyException {
        return this.getPrefixedId("mb_");
    }

    public String getMenuCloseId() throws UnifyException {
        return this.getPrefixedId("mic_");
    }

    public String getMenuCloseOtherId() throws UnifyException {
        return this.getPrefixedId("mico_");
    }

    public String getMenuCloseAllId() throws UnifyException {
        return this.getPrefixedId("mica_");
    }

    public boolean isSidebar() throws UnifyException {
        return this.getUplAttribute(UplElementReferences.class, "sidebar") != null;
    }

    public Widget getSidebar() throws UnifyException {
        return this.getWidgetByLongName((String)this.getShallowReferencedLongNames("sidebar").get(0));
    }

    public int getPageCount() {
        return this.contentList.size();
    }

    public int getPageIndex() {
        return this.contentIndex;
    }

    public ContentInfo getContentInfo(int pageIndex) throws UnifyException {
        return this.contentList.get(pageIndex);
    }

    public ContentInfo getCurrentContentInfo() {
        return this.contentList.get(this.contentIndex);
    }

    @Override
    public void clearPages() throws UnifyException {
        this.contentByPathIdMap.clear();
        this.contentList.clear();
        this.contentIndex = 0;
    }

    @Override
    public Page getCurrentPage() {
        return this.contentList.get(this.contentIndex).getPage();
    }

    @Override
    public void addContent(Page page) throws UnifyException {
        ContentInfo contentInfo = this.contentByPathIdMap.get(page.getPathId());
        if (contentInfo != null) {
            this.contentIndex = contentInfo.getPageIndex();
            return;
        }
        this.untabbedClear();
        this.contentIndex = this.contentList.size();
        contentInfo = new ContentInfo(page, this.contentIndex);
        this.contentList.add(contentInfo);
        this.contentByPathIdMap.put(page.getPathId(), contentInfo);
    }

    @Override
    public String insertContent(Page page) throws UnifyException {
        ContentInfo contentInfo = this.contentByPathIdMap.get(page.getPathId());
        if (contentInfo != null) {
            this.contentIndex = contentInfo.getPageIndex();
            return null;
        }
        this.untabbedClear();
        String replacedPathId = null;
        int len = this.contentList.size();
        if (len <= 1) {
            this.contentIndex = len;
            contentInfo = new ContentInfo(page, this.contentIndex);
            this.contentList.add(contentInfo);
        } else {
            replacedPathId = this.contentList.get(this.contentIndex).getPathId();
            contentInfo = new ContentInfo(page, this.contentIndex);
            this.contentList.add(this.contentIndex, contentInfo);
            for (int i = this.contentIndex + 1; i <= len; ++i) {
                this.contentList.get(i).incPageIndex();
            }
        }
        this.contentByPathIdMap.put(page.getPathId(), contentInfo);
        return replacedPathId;
    }

    private void untabbedClear() throws UnifyException {
        if (!this.isTabbed()) {
            for (ContentInfo oldContentInfo : this.contentList) {
                this.getSessionContext().removeAttribute(oldContentInfo.getPage().getPathId());
            }
            this.contentList.clear();
            this.contentByPathIdMap.clear();
        }
    }

    @Override
    public List<String> evaluateRemoveContent(Page page, ClosePageMode closePageMode) throws UnifyException {
        ArrayList<String> toRemovePathIdList = new ArrayList<String>();
        if (closePageMode == null) {
            closePageMode = ClosePageMode.CLOSE;
        }
        boolean removeSrc = false;
        switch (closePageMode) {
            case CLOSE: {
                removeSrc = true;
                break;
            }
            case CLOSE_ALL: {
                removeSrc = true;
            }
            case CLOSE_OTHERS: {
                ArrayList<ContentInfo> refContentList = new ArrayList<ContentInfo>(this.contentList);
                for (int i = 1; i < refContentList.size(); ++i) {
                    Page refPage = ((ContentInfo)refContentList.get(i)).getPage();
                    if (refPage == page) continue;
                    toRemovePathIdList.add(refPage.getPathId());
                }
                break;
            }
        }
        if (removeSrc) {
            toRemovePathIdList.add(page.getPathId());
        }
        return toRemovePathIdList;
    }

    @Override
    public void removeContent(List<String> toRemovePathIdList) throws UnifyException {
        for (String removePathId : toRemovePathIdList) {
            ContentInfo contentInfo = this.contentByPathIdMap.remove(removePathId);
            if (contentInfo == null) {
                // empty if block
            }
            int pageIndex = contentInfo.getPageIndex();
            this.contentList.remove(pageIndex);
            int size = this.contentList.size();
            for (int i = pageIndex; i < size; ++i) {
                this.contentList.get(i).decPageIndex();
            }
            if (pageIndex > this.contentIndex) continue;
            --this.contentIndex;
        }
    }

    public class ContentInfo {
        private Page page;
        private int pageIndex;

        public ContentInfo(Page page, int pageIndex) throws UnifyException {
            this.page = page;
            this.pageIndex = pageIndex;
        }

        public String getColorScheme() throws UnifyException {
            return ContentPanelImpl.this.pathInfoRepository.getPagePathInfo(this.page).getColorScheme();
        }

        public String getOpenPath() throws UnifyException {
            return ContentPanelImpl.this.pathInfoRepository.getPagePathInfo(this.page).getOpenPagePath();
        }

        public String getClosePath() throws UnifyException {
            return ContentPanelImpl.this.pathInfoRepository.getPagePathInfo(this.page).getClosePagePath();
        }

        public String getSavePath() throws UnifyException {
            return ContentPanelImpl.this.pathInfoRepository.getPagePathInfo(this.page).getSavePagePath();
        }

        public boolean isRemoteSave() throws UnifyException {
            return ContentPanelImpl.this.pathInfoRepository.getPagePathInfo(this.page).isRemoteSave();
        }

        public ControllerPathParts getPathParts() throws UnifyException {
            return ContentPanelImpl.this.pathInfoRepository.getControllerPathParts(this.page);
        }

        public Page getPage() {
            return this.page;
        }

        public String getPathId() {
            return this.page.getPathId();
        }

        public int getPageIndex() {
            return this.pageIndex;
        }

        public void decPageIndex() {
            --this.pageIndex;
        }

        public void incPageIndex() {
            ++this.pageIndex;
        }
    }
}

