/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.panel;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.UplBinding;
import com.tcdng.unify.web.annotation.Action;
import com.tcdng.unify.web.ui.widget.control.Table;
import com.tcdng.unify.web.ui.widget.data.DialogCrudInfo;
import com.tcdng.unify.web.ui.widget.panel.AbstractDialogPanel;

@Component(value="ui-dialogtablecrudpanel")
@UplBinding(value="web/panels/upl/dialogtablecrudpanel.upl")
public class DialogTableCrudPanel
extends AbstractDialogPanel {
    @Override
    public void switchState() throws UnifyException {
        super.switchState();
        DialogCrudInfo<?> dialogCrudInfo = this.getDialogCrudInfo();
        dialogCrudInfo.init();
        switch (dialogCrudInfo.getMode()) {
            case MAINTAIN: {
                this.setVisible("saveFrmBtn", false);
                this.setVisible("updateFrmBtn", true);
                this.setVisible("deleteFrmBtn", true);
                this.setVisible("cancelFrmBtn", true);
                break;
            }
            case CREATE: {
                this.setVisible("saveFrmBtn", true);
                this.setVisible("updateFrmBtn", false);
                this.setVisible("deleteFrmBtn", false);
                this.setVisible("cancelFrmBtn", false);
            }
        }
    }

    @Action
    public void prepareCreate() throws UnifyException {
        DialogCrudInfo<?> dialogCrudInfo = this.getDialogCrudInfo();
        dialogCrudInfo.newItem();
        this.switchState();
    }

    @Action
    public void prepareMaintain() throws UnifyException {
        DialogCrudInfo<?> dialogCrudInfo = this.getDialogCrudInfo();
        dialogCrudInfo.selectItem(this.getWidgetByShortName(Table.class, "itemListTbl").getViewIndex());
        this.switchState();
    }

    @Action
    public void save() throws UnifyException {
        DialogCrudInfo<?> dialogCrudInfo = this.getDialogCrudInfo();
        dialogCrudInfo.saveItem();
        dialogCrudInfo.newItem();
        this.switchState();
    }

    @Action
    public void update() throws UnifyException {
        DialogCrudInfo<?> dialogCrudInfo = this.getDialogCrudInfo();
        dialogCrudInfo.newItem();
        this.switchState();
    }

    @Action
    public void delete() throws UnifyException {
        DialogCrudInfo<?> dialogCrudInfo = this.getDialogCrudInfo();
        dialogCrudInfo.removeItem();
        dialogCrudInfo.newItem();
        this.switchState();
    }

    @Action
    public void cancel() throws UnifyException {
        DialogCrudInfo<?> dialogCrudInfo = this.getDialogCrudInfo();
        dialogCrudInfo.newItem();
        this.switchState();
    }

    private DialogCrudInfo<?> getDialogCrudInfo() throws UnifyException {
        return this.getValue(DialogCrudInfo.class);
    }
}

