/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.panel;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.UplAttribute;
import com.tcdng.unify.core.annotation.UplAttributes;
import com.tcdng.unify.core.data.ValueStore;
import com.tcdng.unify.core.upl.UplUtils;
import com.tcdng.unify.core.util.DataUtils;
import com.tcdng.unify.web.ui.widget.AbstractPanel;
import com.tcdng.unify.web.ui.widget.Page;
import com.tcdng.unify.web.ui.widget.Widget;
import com.tcdng.unify.web.ui.widget.panel.StandalonePanel;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Component(value="ui-dynamicpanel")
@UplAttributes(value={@UplAttribute(name="panelNameBinding", type=String.class, mandatory=true), @UplAttribute(name="panelValueBinding", type=String.class), @UplAttribute(name="hideOnNoComponents", type=boolean.class, defaultVal="false")})
public class DynamicPanel
extends AbstractPanel {
    private Set<String> panelNames = new HashSet<String>();

    @Override
    public void resetState() throws UnifyException {
        this.getStandalonePanel().resetState();
    }

    @Override
    public Widget getRelayWidget() throws UnifyException {
        return this.getStandalonePanel();
    }

    @Override
    public boolean isRelayCommand() {
        return true;
    }

    public String getHiddenId() throws UnifyException {
        return this.getPrefixedId("hid_");
    }

    @Override
    public StandalonePanel getStandalonePanel() throws UnifyException {
        StandalonePanel standalonePanel;
        String panelName = (String)this.getValue((String)this.getUplAttribute(String.class, "panelNameBinding"));
        String uniqueName = UplUtils.generateUplComponentCloneName((String)panelName, (String)this.getPageManager().getPageName(this.getLongName()));
        Page page = this.getRequestContextUtil().getRequestPage();
        this.getPageManager().invalidateStaleDocument(uniqueName);
        if (page == null) {
            page = (Page)this.getSessionAttribute("unload_origin");
        }
        if ((standalonePanel = page.getStandalonePanel(uniqueName)) == null) {
            standalonePanel = this.getPageManager().createStandalonePanel(this.getSessionLocale(), uniqueName);
            page.addStandalonePanel(uniqueName, standalonePanel);
            this.getUIControllerUtil().updatePageControllerInfo(this.getRequestContextUtil().getResponsePathParts().getControllerName(), uniqueName);
            this.panelNames.add(uniqueName);
        }
        this.setValueStore(standalonePanel);
        standalonePanel.setContainer(this);
        return standalonePanel;
    }

    @Override
    public void addPageAliases() throws UnifyException {
        List<String> aliases = this.getPageManager().getExpandedReferences(this.getStandalonePanel().getId());
        this.getRequestContextUtil().addPageAlias(this.getId(), (String[])DataUtils.toArray(String.class, aliases));
    }

    private void setValueStore(StandalonePanel standalonePanel) throws UnifyException {
        ValueStore valueStore = this.getValueStore();
        String valueBinding = (String)this.getUplAttribute(String.class, "panelValueBinding");
        if (valueBinding != null) {
            ValueStore oldValueStore = standalonePanel.getValueStore();
            Object valueObject = this.getValue(valueBinding);
            if (oldValueStore == null || oldValueStore.getValueObject() != valueObject) {
                standalonePanel.setValueStore(this.createValueStore(valueObject));
            }
        } else {
            standalonePanel.setValueStore(valueStore);
        }
    }
}

