/*
 * Decompiled with CFR 0.152.
 */
package com.tcdng.unify.web.ui.widget.panel;

import com.tcdng.unify.core.UnifyException;
import com.tcdng.unify.core.annotation.Component;
import com.tcdng.unify.core.annotation.UplAttribute;
import com.tcdng.unify.core.annotation.UplAttributes;
import com.tcdng.unify.core.annotation.UplBinding;
import com.tcdng.unify.core.list.SearchProvider;
import com.tcdng.unify.core.util.DataUtils;
import com.tcdng.unify.core.util.QueryUtils;
import com.tcdng.unify.core.util.ReflectUtils;
import com.tcdng.unify.web.annotation.Action;
import com.tcdng.unify.web.ui.widget.AbstractPanel;
import com.tcdng.unify.web.ui.widget.data.SearchBox;
import com.tcdng.unify.web.ui.widget.panel.TablePanel;
import java.util.Collections;
import java.util.List;

@Component(value="ui-searchboxpanel")
@UplBinding(value="web/panels/upl/searchboxpanel.upl")
@UplAttributes(value={@UplAttribute(name="searchProvider", type=String.class, mandatory=true)})
public class SearchBoxPanel
extends AbstractPanel {
    private String filter;
    private List<?> resultList;

    @Override
    public void onPageConstruct() throws UnifyException {
        super.onPageConstruct();
        this.setComponentValueBeanToThis("filter");
        this.setComponentValueBeanToThis("searchResultTablePanel");
    }

    @Override
    @Action
    public void switchState() throws UnifyException {
        if (QueryUtils.isValidStringCriteria((String)this.filter)) {
            SearchProvider searchProvider = (SearchProvider)this.getComponent((String)this.getUplAttribute(String.class, "searchProvider"));
            this.resultList = searchProvider.search(this.filter);
        } else {
            this.resultList = Collections.emptyList();
        }
    }

    public void clear() throws UnifyException {
        this.filter = null;
        this.resultList = null;
    }

    public void setResultBeanProperties() throws UnifyException {
        SearchBox searchBoxInfo = (SearchBox)this.getValue();
        TablePanel tablePanel = (TablePanel)this.getWidgetByShortName("searchResultTablePanel");
        Object item = this.resultList.get(tablePanel.getTable().getViewIndex());
        Object resultBean = searchBoxInfo.getResultBean();
        for (SearchBox.Mapping mapping : searchBoxInfo.getMappings()) {
            Object fieldValue = ReflectUtils.getBeanProperty(item, (String)mapping.getSelectFieldName());
            DataUtils.setBeanProperty((Object)resultBean, (String)mapping.getResultFieldName(), (Object)fieldValue);
        }
    }

    public <T> T getSelectedItemProperty(Class<T> typeClass, String property) throws UnifyException {
        TablePanel tablePanel = (TablePanel)this.getWidgetByShortName("searchResultTablePanel");
        Object item = this.resultList.get(tablePanel.getTable().getViewIndex());
        return (T)this.convert(typeClass, ReflectUtils.getBeanProperty(item, (String)property), null);
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public List<?> getResultList() {
        return this.resultList;
    }

    public void setResultList(List<?> resultList) {
        this.resultList = resultList;
    }
}

